<?php
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * DbRepair
 *
 * @category     name
 * @package      Core package
 * @copyright    Manuela v.d.Decken <manuela@isteam.de>
 * @author       Manuela v.d.Decken <manuela@isteam.de>
 * @author       Manuela v.d.Decken <manuela@isteam.de>
 * @license      GNU General Public License 2.0
 * @version      0.0.1 $Rev: 4 $
 * @revision     $Id: cronJob.php 4 2025-08-08 07:53:04Z Uwe $
 * @since        File available since 06.04.2021
 * @deprecated   no / since 0000/00/00
 * @description  xxx
 */
declare(strict_types=1);


use bin\{WbAdaptor};
use bin\helpers\{PreCheck};


//use App\cronCheck;

// BEGIN this part helps to prevent direct access
    $sAddonFile   = \str_replace('\\','/',__FILE__);
    $sAddonPath   = \dirname($sAddonFile).'/';
    $sModulesPath = \dirname($sAddonPath).'/'; //
    $sModuleName  = \basename($sModulesPath);
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = \preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    $aJsonRespond = [];  //
    $sAddonName   = \basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    if (! \defined('SYSTEM_RUN')) {
        if (\is_readable($sAppPath.'config.php')){require($sAppPath.'config.php');}      // load WB configuration
    } else {
        //\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; ob_flush();flush(); exit;
    }
// END this part helps to prevent direct access
// --------------------------------------------------------------------------------------------------------------------------------------------
$sCronCheckConfigFile = $sAppPath.'install/setup/cronJob.conf';
if (!is_readable($sCronCheckConfigFile)){
// Configuration default settings
$emailAddressToAlert = SERVER_EMAIL;        // Alternative something like:  $emailAddressToAlert = 'ruud.eisinga@gmail.com';
$scanPath   = WB_PATH;                      // Scan your complete WebsiteBaker webspace
$noScanDirs = "/cache,/awstats,/stats";     // Directories with these names will not be scanned (i.e. awstats generates files daily)
$noScanExt  = ".jpg,.png,.gif";             // Files with these extensions will not be scanned (i.e. images)
$checkmd5   = true;                         // A better way of detecting all changes, but with more load and slower on your server.
$silent     = false;                        // When set true, the script will not output anything.
}
else
{
  require $sCronCheckConfigFile;
}
// End configuration, do not change anything below this line!
// ---------------------------------------------------------------------------------------------------------------------------------
$aDebugInfo = [
    'emailAddressToAlert' => $emailAddressToAlert,
    'scanPath' => WB_PATH,
    'noScanDirs' => $noScanDirs,
    'noScanExt' => $noScanExt,
    'checkmd5' => ($checkmd5 ? 'true' : 'false'),
    'silent' => ($silent ? 'true' : 'false'),
];

    $sMessage = 'cronCheck Response!'."\n";
    $iPages   = 0;
    $sMessage = '';
    $aJsonRespond = [];
    //$bTrigger = (\is_readable($sAddonPath.'.setTrigger'));
    $aJsonRespond['title'] = 'Search file modification';
    $aJsonRespond['message'] = '<b>Error file modification</b>'."\n";
    $aJsonRespond['success'] = false;
    try {
    // check autentification
        $admin = new admin('Modules', 'modules_advanced',false);
        $oReg  = WbAdaptor::getInstance();
        $oDb   = $oReg->getDatabase();
        if (!$admin->is_authenticated()  || !$admin->ami_group_member('1')) {
            $sMessage .= 'Permission denied'."\n"; //$oDb->get_error()
            throw new \Exception($sMessage);
        }
        $aJsonRespond['message'] = '<b>Error file calling constructor</b>'."\n";

        $oCron = new cronCheck($emailAddressToAlert, $scanPath, $checkmd5, $noScanDirs, $noScanExt, $silent);

        $sError = ($oDb->get_error() ?? \sprintf("<!-- [%03d] vardump %s -->\n",__LINE__,$sAddonPath));
        if (!empty($sError)){
            throw new \Exception($sError); //\sprintf
        } else {
            $aJsonRespond['success'] = true;
            $sMessage = ($oCron->getResponse());
            $aJsonRespond['success'] = true;
        }
    } catch (\Exception $ex) {
        $sMessage .= $aJsonRespond['message'].$ex->getMessage();
        $aJsonRespond['success'] = false;
    }
    $sMessage = \str_replace(['\\/','\\'],'/',$sMessage);
    $sMessage = \str_replace(['/n'],"\n",$sMessage);
    $sMessage = \str_replace(["\r\n","\n"], '<br>', $sMessage); //,"\r"
    $aJsonRespond['message'] = $sMessage;
    $aJsonRespond['message'] = PreCheck::xnl2br($sMessage);
    $sJson = \json_encode($aJsonRespond,\JSON_UNESCAPED_SLASHES); //
    exit($sJson);

    class cronCheck {
/** active instance */
        private static $oInstance = null;

        private \bin\WbAdaptor $oReg;
        private array $aPrevious = [];
        private array $aChanged = [];
        private array $aNew = [];
        private array $aCurrent = [];
        private $md5result;
        private $md5calc;
        private $startScan;
        private $noScanDirs;
        private $noScanExt;
        private $emailAddress;
        private $fromEmailAddress;
        private string $resultMessage = '';
        private $silent;
        private array $aRespond = [];

        public function __construct($emailAddress = SERVER_EMAIL, $path = WB_PATH, $checkmd5 = true, $noScanDirs = "", $noScanExt = "", $silent = true) {
            $this->init($emailAddress , $path, $checkmd5, $noScanDirs, $noScanExt, $silent);
            $sRespond = $this->report();
            $this->cleanTable();
            $this->aRespond['success'] = true;
            $this->aRespond['message'] = $sRespond;
            self::$oInstance = $this;

        }

        private function init($emailAddress , $path, $checkmd5, $noScanDirs, $noScanExt, $silent){
            $admin = new \admin('Modules', 'modules_advanced',false);
            $this->oReg = \bin\WbAdaptor::getInstance();
            $this->startScan = microtime(true);
            if(!$this->hasTable()){ $this->createTable();}
            $this->getLast();
            $this->noScanDirs   = \explode(",",$noScanDirs);
            $this->noScanExt    = \explode(",",$noScanExt);
            $this->emailAddress = $emailAddress;
            $this->fromEmailAddress = $emailAddress;
            $this->silent = $silent;
            $this->scan($path,$checkmd5);
            $this->saveScan();
        }
/**
 * Get active instance
 * @return WbAdaptor
 */
    public static function getInstance()
    {
        if (self::$oInstance === null) {
            $c = __CLASS__;
            self::$oInstance = new $c();
        } else {
        }
        return self::$oInstance;
    }

        public function __destruct() {
            \clearstatcache();
        }

        public function getResponse()
        {
            return \json_encode($this->aRespond['message']);
        }

        private function getScantime() {
            $now = \microtime(true);
            $time = ((float)$now - (float)$this->startScan);
            return \number_format($time,2);
        }

        private function hasTable() {
            if ($this->oReg->Db->get_one("SHOW TABLES LIKE '`".$this->oReg->Db->TablePrefix."croncheck`';")) {
                return true;
            } else {
                return false;
            }
        }

        private function dropTable() {
            $this->oReg->Db->query("DROP TABLE IF EXISTS `".$this->oReg->Db->TablePrefix."croncheck`");
        }

        private function cleanTable() {
            $this->oReg->Db->query("DELETE FROM `".$this->oReg->Db->TablePrefix."croncheck` WHERE `id` NOT IN ( SELECT `id` FROM ( SELECT `id` FROM `".$this->oReg->Db->TablePrefix."croncheck` ORDER BY `timestamp` DESC LIMIT 5 ) foo );");
        }

        private function getLast() {
            $query = $this->oReg->Db->query("SELECT * from `".$this->oReg->Db->TablePrefix."croncheck` ORDER BY `id` DESC LIMIT 1");
            if($query && $query->numRows()) {
                $row = $query->fetchRow();
                $this->aPrevious = $this->unserialize($row['data']);
            }
        }

        private function createTable(){
            //-- it´s a orcale SQL Server
            //-- utf8: An alias for utf8mb3. In MySQL 8.0, this alias is deprecated;
            //-- use utf8mb4 instead. utf8 is expected in a future release to become an alias for utf8mb4
            //-- Tabellenstruktur für Tabelle `croncheck`
            //--
            $sSql = "CREATE TABLE IF NOT EXISTS `".$this->oReg->Db->TablePrefix."croncheck` (\n"
                  . "  `id` int NOT NULL AUTO_INCREMENT,\n"
                  . "  `timestamp` int NOT NULL DEFAULT '0',\n"
                  . "  `md5` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',\n"
                  . "  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,\n"
                  . "  `added` longtext COLLATE utf8mb4_unicode_ci NOT NULL,\n"
                  . "  `removed` longtext COLLATE utf8mb4_unicode_ci NOT NULL,\n"
                  . "  `modified` longtext COLLATE utf8mb4_unicode_ci NOT NULL,\n"
                  . "  PRIMARY KEY (`id`)\n"
                  . "  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

            if ($this->oReg->Db->query($sSql)){;}
        }

        private function saveScan() {
            $save = false;
            if (!$this->aNew && !$this->aChanged && !$this->aPrevious){ return;}
            $sSql  = 'INSERT INTO `'.$this->oReg->Db->TablePrefix.'croncheck` (`timestamp`,`md5`,`data`,`added`,`removed`,`modified`) VALUES ( '."\n";
            $sSql .= ''.(int)\time().','."\n";
            $sSql .= '\'\','."\n";
            $sSql .= '\''.$this->oReg->Db->escapeString(\serialize($this->aCurrent)).'\','."\n";
            $sSql .= '\''.$this->oReg->Db->escapeString(\serialize($this->aNew)).'\','."\n";
            $sSql .= '\''.$this->oReg->Db->escapeString(\serialize($this->aPrevious)).'\','."\n";
            $sSql .= '\''.$this->oReg->Db->escapeString(\serialize($this->aChanged)).'\')'."\n";
            $this->oReg->Db->query($sSql);
            if ($this->oReg->Db->is_error()) {
              $this->resultMessage .= $sSql;
              $this->resultMessage .= $this->oReg->Db->get_error()."\n";
            }
        }

        private function unserialize($sObject) {
            $aRetval = [];
            $sObject = \stripslashes($sObject);
            if ($sObject){
                $_ret = \preg_replace_callback(
                            '!s:(\d+):"(.*?)";!s',
                            function($matches) {return 's:'.\strlen($matches[2]).':"'.$matches[2].'";';},
                            $sObject
                         );
                if ($_ret) {$aRetval = @\unserialize($_ret);}
            }
            return $aRetval;
        }

        private function scan($path = './',$checkmd5 = true) {
            $base = \str_replace('\\','/',WB_PATH);
            $md = '';
            $file = new \RecursiveIteratorIterator(
                    new \RecursiveDirectoryIterator($path
//                          ,\FilesystemIterator::CURRENT_AS_SELF|
//                          \FilesystemIterator::FOLLOW_SYMLINKS|
//                          \FilesystemIterator::KEY_AS_PATHNAME|
//                          \FilesystemIterator::KEY_AS_FILENAME|
//                          \FilesystemIterator::SKIP_DOTS|
//                          \FilesystemIterator::UNIX_PATHS
                          )
                    );
            while($file->valid()) {
                if (!$file->isDot() && !$file->isDir() ) {
                    $cf =  \str_replace('\\','/',$file->getPathname());
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$cf));
                    if ($this->strpos_array($cf,$this->noScanDirs) === false) {
                        if ($this->strpos_array($cf,$this->noScanExt, true) === false) {
                            $ft = $file->getMTime();
                            if ($checkmd5) {$md = \md5_file($cf);} //$this->md5calc =
                            $curr = \addslashes(\str_replace($base,'',$cf));
                            if(isset($this->aPrevious[$curr])) {
                                $details = \explode("|", $this->aPrevious[$curr]);
                                if (($checkmd5 && $md != $details[1]) || $ft != $details[0]) {
                                    $this->aChanged[$curr] = $ft.'|'.$md;
                                }
                                unset($this->aPrevious[$curr]);
                            } elseif (!isset($this->aCurrent[$curr])) {
                                $this->aNew[$curr] = $ft.'|'.$md;
                            }
                            $this->aCurrent[$curr] = $ft.'|'.$md;
                        }
                    }
                }
                $file->next();
            }
        }

        private function strpos_array($haystack, $needles,$ext = false) {
            if ( \is_array($needles) ) {
                foreach ($needles as $str) {
                    if ( \is_array($str) ) {
                        $pos = \strpos_array($haystack, $str);
                    } else {
                        if ($ext) {
                            $pos = \strcasecmp(\substr($haystack,-(\strlen($str))),$str)==0;
                        } else {
                            $pos = \stripos($haystack, $str);
                        }
                    }
                    if ($pos !== FALSE) {
                        return $pos;
                    }
                }
            } else {
                return \stripos($haystack, $needles);
            }
            return false;
        }

        private function sendSmtp(string $emailSubject){
        /* call smtp routine */
        }

        private function sendMail(string $emailSubject){
                $fExecutiontime = $this->getScantime();
                $this->resultMessage .= "\nThe script was running for ".$fExecutiontime." seconds\n";
                $sMessage = \wordwrap($this->resultMessage, 70, "\r\n");
                $headers  = "From: CronCheck <".SERVER_EMAIL.">\r\n";
                $headers .= "Reply-To: ".$this->emailAddress."\r\n";
                if (!\mail($this->emailAddress, $emailSubject, \strip_tags($sMessage), $headers)){
                  echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,'mail send error'));
                }
         }
        private function report() {
            if (($this->aNew) || ($this->aChanged) || ($this->aPrevious)) {
                $this->resultMessage .= "Something has changed on <b>".WB_URL."</b>\n";
                if($this->aNew) {
                    $this->resultMessage .= "\n<b>New files were added:</b> \n";
                    foreach ($this->aNew as $key => $value) {
                        $details = \explode("|",$value);
                        $this->resultMessage .= $key .' -> ' . \gmdate(DATE_FORMAT.' '.TIME_FORMAT,$details[0]+TIMEZONE). "\n";
                    }
                }
                if($this->aChanged) {
                    $this->resultMessage .= "\n<b>These files are changed:</b>\n";
                    foreach ($this->aChanged as $key => $value) {
                        $details = \explode("|",$value);
                        $this->resultMessage .= $key .' -> ' . \gmdate(DATE_FORMAT.' '.TIME_FORMAT,$details[0]+TIMEZONE). "\n";
                    }
                }
                if($this->aPrevious) {
                    $this->resultMessage .= "\n<b>These files have been removed:</b>\n";
                    foreach ($this->aPrevious as $key => $value) {
                        $details = \explode("|",$value);
                        $this->resultMessage .= $key .' -> ' . \gmdate(DATE_FORMAT.' '.TIME_FORMAT,$details[0]+TIMEZONE). "\n";
                    }
                }
                $emailSubject = "IMPORTANT! File(s) in ".WB_URL." have changed";
                $this->sendMail($emailSubject);
            } else {
                $this->resultMessage = ' - ALLOK - Nothing has changed'."\n\n";  // .'The script was running for '.$this->getScantime().' seconds'
                $emailSubject = "IMPORTANT! Files in ".WB_URL." not changed";
                $this->sendMail($emailSubject);
            }
            if (!$this->silent){
              //echo ''.$this->resultMessage;
            }
            return ''.$this->resultMessage;
        }
    }
