<?php
/**
 *
 * @category        admin
 * @package         pages
 * @author          WebsiteBaker Project
 * @copyright       Ryan Djurovich
 * @copyright       WebsiteBaker Org. e.V.
 * @link            https://websitebaker.org/
 * @license         https://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.12.2
 * @requirements    PHP 7.2 and higher
 * @version         $Id: sections_save.php 4 2025-08-08 07:53:04Z Uwe $
 * @filesource      $HeadURL: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/admin/pages/sections_save.php $
 * @lastmodified    $Date: 2025-08-08 09:53:04 +0200 (Fr, 08 Aug 2025) $
 *
 */

use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck};

// Include config file
if (!\defined('SYSTEM_RUN')) {require( (\dirname(\dirname((__DIR__)))).'/config.php');}
try {

/*
    $requestMethod = '_'.\strtoupper($_SERVER['REQUEST_METHOD']);
    $aRequestVars = (isset(${$requestMethod}) ? ${$requestMethod} : $_REQUEST);
*/
/*
    // Make sure people are allowed to access this page
    if (MANAGE_SECTIONS !== true) {
        \header('Location: '.ADMIN_URL.'/pages/index.php');
        exit(0);
    }
*/
/**/
// Create new admin object
// suppress to print the header, so no new FTAN will be set
    $admin_header = ($admin_header ?? false);
    $admin_auth   = ($admin_auth ?? true);
    $section_name = ($section_name ?? 'Pages');
    $section_permission = ($section_permission ?? 'pages_modify');
//    \trigger_error(sprintf('[%d] <b>BEFORE instance admin wrapper</b> %s',__LINE__,$sDumpPathname), E_USER_NOTICE);
    $admin = new \admin($section_name, $section_permission,(bool)$admin_header, $admin_auth);
    $oReg     = WbAdaptor::getInstance();
    $oTrans   = $oReg->getTranslate();
    $oRequest = $oReg->getRequester();
    $database = database::getInstance();
    $oApp     = $oReg->getApplication();
    $sDomain  = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);
    $module_dir = \basename(\dirname($oReg->Request->getServerVar("SCRIPT_NAME")));

// get request method
    $requestMethod = \strtoupper($oReg->Request->getServerVar('REQUEST_METHOD'));
    $aRequestVars  = [];
// get POST or GET requests, never both at once
    $aVars = $oReg->Request->getParamNames();
    foreach ($aVars as $sName) {
        $aRequestVars[$sName] = $oReg->Request->getParam($sName);
    }

    if (!(function_exists('jscalendar_to_timestamp')))(require($oReg->AppPath."include/jscalendar/jscalendar-functions.php"));
    //$callingScript = $_SERVER['HTTP_REFERER'];
    $sCallingScript = $oRequest->getServerVar('HTTP_REFERER');
    $sBackLink = $oReg->AcpUrl.'pages/index.php';
// Get page id
    if (!isset($aRequestVars['page_id']) || !\is_numeric($aRequestVars['page_id'])) {
        $sErrorMsg = sprintf("Missing page_id -> %s",$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']);
        throw new \Exception ($sErrorMsg);
    } else {
        $iPageId = $page_id = (int)$aRequestVars['page_id'];
    }

    $sBackLink = ($oReg->AcpUrl.'pages/sections.php?page_id='.$iPageId);

//    if (!$admin->checkFTAN()){
      if (!\bin\SecureTokens::checkFTAN ()) {
        $sErrorMsg = sprintf("%s",$MESSAGE['GENERIC_SECURITY_ACCESS']);
        throw new \Exception ($sErrorMsg);
    }
//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( [$module_dir,$sBackLink] ); print '</pre>'; \flush (); //  sleep(10); die();

/*
if( (!($page_id = $admin->checkIDKEY('page_id', 0, $_SERVER['REQUEST_METHOD']))) )
{
    $admin->print_error($MESSAGE['GENERIC_SECURITY_ACCESS']);
    exit();
}
*/
// Get perms
    $sql  = 'SELECT `admin_groups`,`admin_users` FROM `'.$database->TablePrefix.'pages` '
          . ' WHERE `page_id` = '.(int)$page_id. '';
    $results = $database->query($sql);
    $results_array = $results->fetchAssoc();
    $old_admin_groups = \explode(',', $results_array['admin_groups']);
    $old_admin_users  = \explode(',', $results_array['admin_users']);
    $in_old_group = false;
    foreach($admin->get_groups_id() as $cur_gid){
        if (\in_array($cur_gid, $old_admin_groups)) {
            $in_old_group = true;
        }
    }

    if ((!$in_old_group) && !\is_numeric(\array_search($admin->getUserId(), $old_admin_users))) {
        $sErrorMsg = sprintf("%s",$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']);
        throw new \Exception ($sErrorMsg);
    }

// Get page details
    $query = 'SELECT COUNT(`page_id`) `numRows` FROM `'.TABLE_PREFIX.'pages` WHERE `page_id` = '.(int)$page_id.'';
    $numRows = $database->get_one($query);
    if ($database->is_error()) {
        $sErrorMsg = sprintf("%s",$database->get_error());
        throw new \Exception ($sErrorMsg);
    }
    if ($numRows === 0) {
        $sErrorMsg = sprintf("%s",$MESSAGE['PAGES_NOT_FOUND']);
        throw new \Exception ($sErrorMsg);
    }

    $results_array = $results->fetchAssoc();
// Set module permissions
    $module_permissions = $_SESSION['MODULE_PERMISSIONS'];

    $aSql = [];
    $sec_anchor = '';
    $section_id = \intval($admin->get_post('section_id') );
    $sTitle  = $admin->StripCodeFromText( $admin->get_post('title_'.$section_id ));

    $iAnchor    = $oRequest->getParam('anchor'.$section_id, FILTER_VALIDATE_BOOLEAN);
    $iActive    = $oRequest->getParam('active'.$section_id, FILTER_VALIDATE_BOOLEAN);
    $sAttribute = $oRequest->getParam('attribute'.$section_id, FILTER_SANITIZE_FULL_SPECIAL_CHARS);

    $bSaveTitle = isset($aRequestVars['inputSection']);
    if ($bSaveTitle ) {
        $aSql[]  = 'UPDATE `'.$database->TablePrefix.'sections` SET '
                 . '`title`=\''.$database->escapeString($sTitle).'\', '
                 . '`anchor`='.(int)$iAnchor.', '
                 . '`active`='.(int)$iActive.', '
                 . '`attribute`=\''.$database->escapeString($sAttribute).'\' '
                 . 'WHERE `section_id`='.(int)$section_id;
        foreach( $aSql as $sSql ) {
              if(!$database->query($sSql)) {
// TODO Exception Message
            }
        }
        $sec_anchor = '#'.(\defined('SEC_ANCHOR') && !empty(SEC_ANCHOR) ? SEC_ANCHOR : 'Sec' ).(int)$section_id;
        $sBackLink = ADMIN_URL.'/pages/modify.php?page_id='.$page_id.$sec_anchor;
    } else {
// Loop through sections
        $sql  = 'SELECT `section_id`,`module`,`position` FROM `'.$database->TablePrefix.'sections` '
              . 'WHERE `page_id` = '.(int)$page_id.' '
              . 'ORDER BY `position` ';
        if($query_sections = $database->query($sql))
        {
            $num_sections = $query_sections->numRows();
            while($section = $query_sections->fetchAssoc()) {
                if (!\is_numeric(\array_search($section['module'], $module_permissions))) {
                    // Update the section record with properties
                    $section_id = $section['section_id'];
                    $sqlBody = ''; $publ_start = 0; $publ_end = 0;
                    //$dst = \date("I")?" DST":""; // daylight saving time?

                    if (isset($aRequestVars['block'.$section_id]) && $aRequestVars['block'.$section_id] != '') {
                        $sqlBody = "block = '".$admin->add_slashes($aRequestVars['block'.$section_id])."'";
                    }
                    // update publ_start and publ_end, trying to make use of the strtotime()-features like "next week", "+1 month", ...
                    if (isset($aRequestVars['start_date'.$section_id]) && isset($aRequestVars['end_date'.$section_id])) {
                        if (\trim($aRequestVars['start_date'.$section_id]) == '0' || empty(\trim($aRequestVars['start_date'.$section_id]))) {
                            $publ_start = 0;
                        } else {
                            $publ_start = jscalendar_to_timestamp($aRequestVars['start_date'.$section_id]);
                        }
                        if (\trim($aRequestVars['end_date'.$section_id]) == '0' || empty(\trim($aRequestVars['end_date'.$section_id]))) {
                            $publ_end = 2147483647;
                        } else {
                            $publ_end = jscalendar_to_timestamp($aRequestVars['end_date'.$section_id], $publ_start);
                        }
                        if ($sqlBody != ''){$sqlBody .= ",";}
                        $sqlBody .= " publ_start = '".$database->escapeString($publ_start)."'";
                        $sqlBody .= ", publ_end = '".$database->escapeString($publ_end)."'";
                    }
                    $sSql = 'UPDATE `'.$database->TablePrefix.'sections` SET '
                          . $sqlBody. ' '
                          . 'WHERE `section_id` = '.(int)$section_id;
                    if($sSql != '') {
                        $database->query($sSql);
                    }
                }
            }
        }
    }
//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( [$aRequestVars,$sSql] ); print '</pre>'; \flush (); //  sleep(10); die();
// Check for error or print success message
    if ($database->is_error()) {
        $sErrorMsg = sprintf("%s",$database->get_error());
        throw new \Exception ($sErrorMsg);
    }
    $admin->print_header();
    $admin->print_success($MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED'], $sBackLink );
}catch (\Exception $ex) {
    $admin->print_header();
    $sErrMsg = PreCheck::xnl2br(sprintf('[%d] %s', $ex->getLine(), $ex->getMessage()));
    $admin->print_error ($sErrMsg, $sBackLink);
    exit;
}

// Print admin footer
    $admin->print_footer();

// end of script ------------------------------------------------------------------------
