<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of \languages\FR
 * @package          CoreTranslation
 * @copyright        Manuela v.d.Decken <manuela@isteam.de>
 * @author          $Author: Uwe $
 * @license         GNU General Public License 2.0
 * @version         4.0.3
 * @revision        $Revision: 63 $
 * @since           $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @lastmodified    $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @deprecated      no
 * @description     CoreTranslation
 * @svn-id          $Header: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/languages/FR.php 63 2025-09-01 10:08:14Z Uwe $
 */

//declare(strict_types = 1);

//declare(encoding = 'UTF-8');

if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
// Define that this file is loaded
if (!defined('LANGUAGE_LOADED')) { define('LANGUAGE_LOADED', true); }

// Set the language information
$language_code = 'FR';
$language_name = 'Français';
$language_version = '4.0.3';
$language_platform = '2.11.0';
$language_author = 'Jacobi22';// All translations by Google AI
$language_license = 'GNU General Public License 2.0';

$HEADING['ADDON_PRECHECK_FAILED']            = 'Exigences du module complémentaire non satisfaites';
$HEADING['ADD_CHILD_PAGE']                   = 'Ajouter une sous-page';
$HEADING['ADD_GROUP']                        = 'Ajouter un groupe';
$HEADING['ADD_GROUPS']                       = 'Ajouter des groupes';
$HEADING['ADD_HEADING']                      = 'Ajouter un titre';
$HEADING['ADD_PAGE']                         = 'Ajouter une page';
$HEADING['ADD_USER']                         = 'Ajouter un utilisateur';
$HEADING['ADMINISTRATION_TOOLS']             = 'Outils d’administration';
$HEADING['BROWSE_MEDIA']                     = 'Parcourir les médias';
$HEADING['CREATE_FOLDER']                    = 'Créer un dossier';
$HEADING['DEFAULT_SETTINGS']                 = 'Paramètres par défaut';
$HEADING['DELETED_PAGES']                    = 'Pages supprimées';
$HEADING['FILESYSTEM_SETTINGS']              = 'Paramètres du système de fichiers';
$HEADING['GENERAL_SETTINGS']                 = 'Paramètres généraux';
$HEADING['INSTALL_LANGUAGE']                 = 'Installer la langue';
$HEADING['INSTALL_MODULE']                   = 'Installer le module';
$HEADING['INSTALL_TEMPLATE']                 = 'Installer le modèle';
$HEADING['INVOKE_LANGUAGE_FILES']            = 'Exécuter les fichiers de langue manuellement';
$HEADING['INVOKE_MODULE_FILES']              = 'Exécuter les fichiers de module manuellement';
$HEADING['INVOKE_TEMPLATE_FILES']            = 'Exécuter les fichiers de modèle manuellement';
$HEADING['LANGUAGE_DETAILS']                 = 'Détails de la langue';
$HEADING['MANAGE_SECTIONS']                  = 'Gérer les sections';
$HEADING['MODIFY_ADVANCED_PAGE_SETTINGS']    = 'Modifier les paramètres avancés de la page';
$HEADING['MODIFY_DELETE_GROUP']              = 'Modifier/Supprimer un groupe';
$HEADING['MODIFY_DELETE_PAGE']               = 'Modifier/Supprimer une page';
$HEADING['MODIFY_DELETE_USER']               = 'Modifier/Supprimer un utilisateur';
$HEADING['MODIFY_GROUP']                     = 'Modifier un groupe';
$HEADING['MODIFY_GROUPS']                    = 'Modifier des groupes';
$HEADING['MODIFY_INTRO_PAGE']                = 'Modifier la page d’introduction';
$HEADING['MODIFY_PAGE']                      = 'Modifier la page';
$HEADING['MODIFY_PAGE_SETTINGS']             = 'Modifier les paramètres de la page';
$HEADING['MODIFY_USER']                      = 'Modifier un utilisateur';
$HEADING['MODULE_DETAILS']                   = 'Détails du module';
$HEADING['MY_EMAIL']                         = 'Mon e-mail';
$HEADING['MY_PASSWORD']                      = 'Mon mot de passe';
$HEADING['MY_SETTINGS']                      = 'Mes paramètres';
$HEADING['SEARCH_SETTINGS']                  = 'Paramètres de recherche';
$HEADING['SERVER_SETTINGS']                  = 'Paramètres du serveur';
$HEADING['TEMPLATE_DETAILS']                 = 'Détails du modèle';
$HEADING['UNINSTALL_LANGUAGE']               = 'Désinstaller la langue';
$HEADING['UNINSTALL_MODULE']                 = 'Désinstaller le module';
$HEADING['UNINSTALL_TEMPLATE']               = 'Désinstaller le modèle';
$HEADING['UPGRADE_LANGUAGE']                 = 'Enregistrement/mise à niveau de la langue';
$HEADING['UPLOAD_FILES']                     = 'Télécharger fichier(s)';
$HEADING['WBMAILER_SETTINGS']                = 'Paramètres du Mailer';
$MENU['ACCESS']                             = 'Gestion des utilisateurs';
$MENU['ADDON']                              = 'Module complémentaire';
$MENU['ADDONS']                             = 'Modules complémentaires';
$MENU['ADMINTOOLS']                         = 'Outils d’administration';
$MENU['BREADCRUMB']                         = 'Vous êtes ici : ';
$MENU['FORGOT']                             = 'Récupérer les détails de connexion';
$MENU['GROUP']                              = 'Groupe';
$MENU['GROUPS']                             = 'Groupes';
$MENU['HELP']                               = 'Aide';
$MENU['LANGUAGES']                          = 'Langues';
$MENU['LOGIN']                              = 'Connexion';
$MENU['LOGOUT']                             = 'Déconnexion';
$MENU['MEDIA']                              = 'Médias';
$MENU['MODULES']                            = 'Modules';
$MENU['MY_PROFILE']                         = 'Mon profil';
$MENU['PAGES']                              = 'Pages';
$MENU['PREFERENCES']                        = 'Préférences';
$MENU['REORG_TABLE']                        = 'Réorganiser les tables';
$MENU['SETTINGS']                           = 'Paramètres';
$MENU['START']                              = 'Démarrer';
$MENU['TEMPLATES']                          = 'Modèles';
$MENU['USERS']                              = 'Utilisateurs';
$MENU['VIEW']                               = 'Afficher';
$MESSAGE['ADDON_ERROR_RELOAD']               = 'Erreur lors de la mise à jour des informations du module complémentaire.';
$MESSAGE['ADDON_LANGUAGES_RELOADED']         = 'Langues rechargées avec succès';
$MESSAGE['ADDON_MANUAL_FTP_LANGUAGE']        = '<strong>ATTENTION !</strong> Pour des raisons de sécurité, transférez les fichiers de langue uniquement via FTP dans le dossier /languages/ et utilisez la fonction de mise à niveau pour enregistrer ou mettre à jour.';
$MESSAGE['ADDON_MANUAL_FTP_WARNING']         = 'Avertissement : Les entrées existantes dans la base de données du module seront perdues. ';
$MESSAGE['ADDON_MANUAL_INSTALLATION']        = 'Lorsque les modules sont téléchargés via FTP (non recommandé), les fonctions d’installation du module <code>install</code>, <code>upgrade</code> ou <code>uninstall</code> ne seront pas exécutées automatiquement. Ces modules peuvent ne pas fonctionner correctement ou se désinstaller correctement.<br /><br />Vous pouvez exécuter les fonctions du module manuellement pour les modules téléchargés via FTP ci-dessous.';
$MESSAGE['ADDON_MANUAL_INSTALLATION_WARNING']= 'Avertissement : Les entrées existantes dans la base de données du module seront perdues. Utilisez cette option uniquement si vous rencontrez des problèmes avec les modules téléchargés via FTP.';
$MESSAGE['ADDON_MANUAL_RELOAD_WARNING']      = 'Avertissement : Les entrées existantes dans la base de données du module seront perdues. ';
$MESSAGE['ADDON_MODULES_RELOADED']           = 'Modules rechargés avec succès';
$MESSAGE['ADDON_OVERWRITE_NEWER_FILES']      = 'Écraser les fichiers plus récents';
$MESSAGE['ADDON_PRECHECK_FAILED']            = 'L’installation du module complémentaire a échoué. Votre système ne satisfait pas les exigences de ce module complémentaire. Pour que ce module complémentaire fonctionne sur votre système, veuillez corriger les problèmes résumés ci-dessous.';
$MESSAGE['ADDON_RELOAD']                     = 'Mettre à jour la base de données avec les informations des fichiers du module complémentaire (par exemple, après un téléchargement FTP).';
$MESSAGE['ADDON_TEMPLATES_RELOADED']         = 'Modèles rechargés avec succès';
$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES']   = 'Privilèges d’accès insuffisants';
$MESSAGE['FORGOT_PASS_ALREADY_RESET']        = 'Le mot de passe ne peut être réinitialisé qu’une fois par heure';
$MESSAGE['FORGOT_PASS_CANNOT_EMAIL']         = 'Impossible d’envoyer le mot de passe par e-mail, veuillez contacter l’administrateur système';
$MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND']      = 'L’adresse e-mail que vous avez saisie ne peut pas être trouvée dans la base de données';
$MESSAGE['FORGOT_PASS_NO_DATA']              = 'Veuillez saisir votre adresse e-mail ci-dessous';
$MESSAGE['FORGOT_PASS_PASSWORD_RESET']       = 'Votre mot de passe a été envoyé à votre adresse e-mail';
$MESSAGE['FRONTEND_SORRY_NO_ACTIVE_SECTIONS']= 'Désolé, aucun contenu actif à afficher';
$MESSAGE['FRONTEND_SORRY_NO_VIEWING_PERMISSIONS'] = 'Désolé, vous n’avez pas la permission de voir cette page';
$MESSAGE['GENERIC_ALREADY_INSTALLED']        = 'Déjà installé';
$MESSAGE['GENERIC_BAD_PERMISSIONS']          = 'Impossible d’écrire dans le répertoire cible';
$MESSAGE['GENERIC_BE_PATIENT']               = 'Soyez patient, s’il vous plaît.';
$MESSAGE['GENERIC_CANNOT_UNINSTALL']         = 'Impossible de désinstaller';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE']  = 'Impossible de désinstaller : le fichier sélectionné est en cours d’utilisation';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL'] = '<br /><br />{{type}} <b>{{type_name}}</b> n’a pas pu être désinstallé, car il est toujours utilisé sur {{pages}}.<br /><br />';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL_PAGES'] = 'cette page;ces pages';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_TEMPLATE'] = 'Impossible de désinstaller le modèle <b>{{name}}</b>, car c’est le modèle par défaut !';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_THEME'] = 'Impossible de désinstaller le modèle <b>{{name}}</b>, car c’est le thème d’administration par défaut !';
$MESSAGE['GENERIC_CANNOT_UNZIP']             = 'Impossible de décompresser le fichier';
$MESSAGE['GENERIC_CANNOT_UPLOAD']            = 'Impossible de télécharger le fichier';
$MESSAGE['GENERIC_COMPARE']                  = ' réussi';
$MESSAGE['GENERIC_ERROR_OPENING_FILE']       = 'Erreur lors de l’ouverture du fichier.';
$MESSAGE['GENERIC_FAILED_COMPARE']           = ' a échoué';
$MESSAGE['GENERIC_FILE_TYPE']                = 'Veuillez noter que le fichier que vous téléchargez doit être au format suivant :';
$MESSAGE['GENERIC_FILE_TYPES']               = 'Veuillez noter que le fichier que vous téléchargez doit être dans l’un des formats suivants :';
$MESSAGE['GENERIC_FILL_IN_ALL']              = 'Veuillez revenir en arrière et remplir tous les champs';
$MESSAGE['GENERIC_FORGOT_OPTIONS']           = 'Vous n’avez pas fait de sélection !';
$MESSAGE['GENERIC_INSTALLED']                = 'Installé avec succès';
$MESSAGE['GENERIC_INVALID']                  = 'Le fichier que vous avez téléchargé est invalide';
$MESSAGE['GENERIC_INVALID_ADDON_FILE']       = 'Fichier d’installation WebsiteBaker invalide. Veuillez vérifier le format *.zip.';
$MESSAGE['GENERIC_INVALID_LANGUAGE_FILE']    = 'Fichier de langue WebsiteBaker invalide. Veuillez vérifier le fichier texte.';
$MESSAGE['GENERIC_INVALID_MODULE_FILE']      = 'Fichier de module WebsiteBaker invalide. Veuillez vérifier le fichier texte.';
$MESSAGE['GENERIC_INVALID_TEMPLATE_FILE']    = 'Fichier de modèle WebsiteBaker invalide. Veuillez vérifier le fichier texte.';
$MESSAGE['GENERIC_IN_USE']                   = ' mais utilisé dans ';
$MESSAGE['GENERIC_MISSING_ARCHIVE_FILE']     = 'Fichier d’archive manquant !';
$MESSAGE['GENERIC_MODULE_VERSION_ERROR']     = 'Le module %s n’est pas installé correctement !';
$MESSAGE['GENERIC_NOT_COMPARE']              = ' non possible';
$MESSAGE['GENERIC_NOT_INSTALLED']            = 'Non installé';
$MESSAGE['GENERIC_NOT_UPGRADED']             = 'Mise à jour non possible';
$MESSAGE['GENERIC_PLEASE_BE_PATIENT']        = 'Veuillez patienter, cela pourrait prendre un certain temps.';
$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON']   = 'Veuillez revenir bientôt...';
$MESSAGE['GENERIC_SECURITY_ACCESS']          = 'Infraction de sécurité !! Accès refusé !';
$MESSAGE['GENERIC_SECURITY_OFFENSE']         = 'Infraction de sécurité !! Le stockage des données a été refusé !';
$MESSAGE['GENERIC_UNINSTALLED']              = 'Désinstallé avec succès';
$MESSAGE['GENERIC_UPGRADED']                 = 'Mis à niveau avec succès';
$MESSAGE['GENERIC_VERSION_COMPARE']          = 'Comparaison de versions';
$MESSAGE['GENERIC_VERSION_GT']               = 'Mise à niveau nécessaire !';
$MESSAGE['GENERIC_VERSION_LT']               = 'Rétrogradation';
$MESSAGE['GENERIC_WEBSITE_LOCKED']           = 'ce site est temporairement indisponible pour maintenance';
$MESSAGE['GENERIC_WEBSITE_UNDER_CONSTRUCTION'] = 'Site Web en construction';
$MESSAGE['GENERIC_WEBSITE_NO_PAGES']         = 'Ce site web pour cette langue (%s) est toujours en construction';
$MESSAGE['GROUPS_ADDED']                     = 'Groupe ajouté avec succès';
$MESSAGE['GROUPS_CONFIRM_DELETE']            = 'Êtes-vous sûr de vouloir supprimer le groupe sélectionné (et tous les utilisateurs qui en font partie) ?';
$MESSAGE['GROUPS_DELETED']                   = 'Groupe supprimé avec succès';
$MESSAGE['GROUPS_GROUP_NAME_BLANK']          = 'Le nom du groupe est vide';
$MESSAGE['GROUPS_GROUP_NAME_EXISTS']         = 'Le nom du groupe existe déjà';
$MESSAGE['GROUPS_NO_GROUPS_FOUND']           = 'Aucun groupe trouvé';
$MESSAGE['GROUPS_SAVED']                     = 'Groupe enregistré avec succès';
$MESSAGE['LOGIN_AUTHENTICATION_FAILED']      = 'Nom d’utilisateur ou mot de passe incorrect';
$MESSAGE['LOGIN_BOTH_BLANK']                 = 'Veuillez saisir votre nom d’utilisateur et votre mot de passe';
$MESSAGE['LOGIN_PASSWORD_BLANK']             = 'Veuillez saisir un mot de passe';
$MESSAGE['LOGIN_PASSWORD_TOO_LONG']          = 'Mot de passe fourni trop long';
$MESSAGE['LOGIN_PASSWORD_TOO_SHORT']         = 'Mot de passe fourni trop court';
$MESSAGE['LOGIN_USERNAME_BLANK']             = 'Veuillez saisir un nom d’utilisateur';
$MESSAGE['LOGIN_USERNAME_TOO_LONG']          = 'Nom d’utilisateur fourni trop long';
$MESSAGE['LOGIN_USERNAME_TOO_SHORT']         = 'Nom d’utilisateur fourni trop court';
$MESSAGE['MEDIA_BLANK_EXTENSION']            = 'Vous n’avez pas entré d’extension de fichier';
$MESSAGE['MEDIA_BLANK_NAME']                 = 'Vous n’avez pas entré un nouveau nom';
$MESSAGE['MEDIA_CANNOT_DELETE_DIR']          = 'Impossible de supprimer le dossier sélectionné';
$MESSAGE['MEDIA_CANNOT_DELETE_FILE']         = 'Impossible de supprimer le fichier sélectionné';
$MESSAGE['MEDIA_CANNOT_RENAME']              = 'Renommage échoué';
$MESSAGE['MEDIA_CONFIRM_DELETE']             = 'Êtes-vous sûr de vouloir supprimer le fichier ou le dossier suivant ?';
$MESSAGE['MEDIA_DELETED_DIR']                = 'Dossier supprimé avec succès';
$MESSAGE['MEDIA_DELETED_FILE']               = 'Fichier supprimé avec succès';
$MESSAGE['MEDIA_DIR_ACCESS_DENIED']          = 'Le répertoire spécifié n’existe pas ou n’est pas autorisé.';
$MESSAGE['MEDIA_DIR_DOES_NOT_EXIST']         = 'Le répertoire n’existe pas';
$MESSAGE['MEDIA_DIR_DOT_DOT_SLASH']          = 'Ne peut pas inclure ../ dans le nom du dossier';
$MESSAGE['MEDIA_DIR_EXISTS']                 = 'Un dossier correspondant au nom que vous avez saisi existe déjà';
$MESSAGE['MEDIA_DIR_MADE']                   = 'Dossier créé avec succès';
$MESSAGE['MEDIA_DIR_NOT_MADE']               = 'Impossible de créer le dossier';
$MESSAGE['MEDIA_FILE_EXISTS']                = 'Un fichier correspondant au nom que vous avez saisi existe déjà';
$MESSAGE['MEDIA_FILE_NOT_FOUND']             = 'Fichier non trouvé';
$MESSAGE['MEDIA_NAME_DOT_DOT_SLASH']         = 'Ne peut pas inclure ../ dans le nom';
$MESSAGE['MEDIA_NAME_INDEX_PHP']             = 'Impossible d’utiliser index.php comme nom';
$MESSAGE['MEDIA_NONE_FOUND']                 = 'Aucun média trouvé dans le dossier actuel';
$MESSAGE['MEDIA_NO_FILE_UPLOADED']           = 'Aucun fichier n’a été reçu';
$MESSAGE['MEDIA_RENAMED']                    = 'Renommage réussi';
$MESSAGE['MEDIA_SINGLE_UPLOADED']            = ' fichier a été téléchargé avec succès';
$MESSAGE['MEDIA_TARGET_DOT_DOT_SLASH']       = 'Ne peut pas avoir ../ dans le dossier cible';
$MESSAGE['MEDIA_UPLOADED']                   = ' fichiers ont été téléchargés avec succès';
$MESSAGE['MOD_FORM_EXCESS_SUBMISSIONS']      = 'Désolé, ce formulaire a été soumis trop de fois cette heure-ci. Veuillez réessayer à la prochaine heure.';
$MESSAGE['MOD_FORM_INCORRECT_CAPTCHA']       = 'Le numéro de vérification (également appelé Captcha) que vous avez saisi est incorrect. Si vous avez des problèmes pour lire le Captcha, veuillez envoyer un e-mail à : <a href="mailto:{{SERVER_EMAIL}}">{{SERVER_EMAIL}}</a>';
$MESSAGE['MOD_FORM_REQUIRED_FIELDS']         = 'Vous devez entrer les détails pour les champs suivants';
$MESSAGE['PAGES_ADDED']                      = 'Page ajoutée avec succès';
$MESSAGE['PAGES_ADDED_HEADING']              = 'Titre de page ajouté avec succès';
$MESSAGE['PAGES_BLANK_MENU_TITLE']           = 'Veuillez entrer un titre de menu';
$MESSAGE['PAGES_BLANK_PAGE_TITLE']           = 'Veuillez entrer un titre de page';
$MESSAGE['PAGES_CANNOT_CREATE_ACCESS_FILE']  = 'Erreur lors de la création du fichier d’accès dans le répertoire /pages (privilèges insuffisants)';
$MESSAGE['PAGES_CANNOT_DELETE_ACCESS_FILE']  = 'Erreur lors de la suppression du fichier d’accès dans le répertoire /pages (privilèges insuffisants)';
$MESSAGE['PAGES_CANNOT_REORDER']             = 'Erreur lors du réarrangement de la page';
$MESSAGE['PAGES_DELETED']                    = 'Page supprimée avec succès';
$MESSAGE['PAGES_DELETE_CONFIRM']             = 'Êtes-vous sûr de vouloir supprimer la page sélectionnée (et toutes ses sous-pages) ?';
$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']   = 'Vous n’avez pas la permission de modifier cette page';
$MESSAGE['PAGES_INTRO_LINK']                 = 'Cliquez ICI pour modifier la page d’introduction';
$MESSAGE['PAGES_INTRO_NOT_WRITABLE']         = 'Impossible d’écrire dans le fichier /pages/intro.php (privilèges insuffisants)';
$MESSAGE['PAGES_INTRO_SAVED']                = 'Page d’introduction enregistrée avec succès';
$MESSAGE['PAGES_LAST_MODIFIED']              = 'Dernière modification par';
$MESSAGE['PAGES_NOT_FOUND']                  = 'Page non trouvée';
$MESSAGE['PAGES_NOT_SAVED']                  = 'Erreur lors de l’enregistrement de la page';
$MESSAGE['PAGES_PAGE_EXISTS']                = 'Une page avec le même titre ou un titre similaire existe';
$MESSAGE['PAGES_REORDERED']                  = 'Page réorganisée avec succès';
$MESSAGE['PAGES_RESTORED']                   = 'Page restaurée avec succès';
$MESSAGE['PAGES_RETURN_TO_PAGES']            = 'Retour aux pages';
$MESSAGE['PAGES_SAVED']                      = 'Page enregistrée avec succès';
$MESSAGE['PAGES_SAVED_SETTINGS']             = 'Paramètres de page enregistrés avec succès';
$MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED']  = 'Propriétés de la section enregistrées avec succès';
$MESSAGE['PAGE_MODIFIED']                    = 'La page a été modifiée le %s par %s';
$MESSAGE['PREFERENCES_CURRENT_PASSWORD_INCORRECT'] = 'Le mot de passe (actuel) que vous avez saisi est incorrect';
$MESSAGE['PREFERENCES_DETAILS_SAVED']        = 'Détails enregistrés avec succès';
$MESSAGE['PREFERENCES_EMAIL_UPDATED']        = 'E-mail mis à jour avec succès';
$MESSAGE['PREFERENCES_INVALID_CHARS']        = 'Caractères de mot de passe invalides utilisés';
$MESSAGE['PREFERENCES_PASSWORD_CHANGED']     = 'Mot de passe changé avec succès';
$MESSAGE['RECORD_MODIFIED_FAILED']           = 'La modification de l’enregistrement a échoué.';
$MESSAGE['RECORD_MODIFIED_SAVED']            = 'L’enregistrement modifié a été mis à jour avec succès.';
$MESSAGE['RECORD_NEW_FAILED']                = 'L’ajout d’un nouvel enregistrement a échoué.';
$MESSAGE['RECORD_NEW_SAVED']                 = 'Le nouvel enregistrement a été ajouté avec succès.';
$MESSAGE['REORG_SUCCESS']                    = 'La réorganisation a été effectuée avec succès';
$MESSAGE['SETTINGS_MODE_SWITCH_WARNING']     = 'Veuillez noter : appuyer sur ce bouton réinitialise toutes les modifications non enregistrées';
$MESSAGE['SETTINGS_SAVED']                   = 'Options enregistrées avec succès !';
$MESSAGE['SETTINGS_UNABLE_OPEN_CONFIG']      = 'Impossible d’ouvrir le fichier de configuration';
$MESSAGE['SETTINGS_UNABLE_WRITE_CONFIG']     = 'Impossible d’écrire dans le fichier de configuration';
$MESSAGE['SETTINGS_WORLD_WRITEABLE_WARNING'] = 'Veuillez noter : cela est recommandé uniquement pour les environnements de test';
$MESSAGE['SIGNUP2_ADMIN_INFO']               = "\r\nUn nouvel utilisateur a été enregistré.\r\n\r\nNom d’utilisateur : {LOGIN_NAME}\r\n{DISPLAY_NAME} : {LOGIN_ID}\r\nE-mail : {LOGIN_EMAIL}\r\nDate d’inscription : {SIGNUP_DATE}\r\n----------------------------------------\r\nCe message a été généré automatiquement !\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_FORGOT']       = "\r\nBonjour {LOGIN_DISPLAY_NAME},\r\n\r\nCe courriel a été envoyé car la fonction « mot de passe oublié » a été appliquée à votre compte.\r\n\r\nVos nouvelles informations de connexion pour « {LOGIN_WEBSITE_TITLE} » sont :\r\n\r\nNom d’utilisateur : xxxxx\r\nMot de passe : {LOGIN_PASSWORD}\r\n\r\nVotre mot de passe a été réinitialisé à celui ci-dessus.\r\nCela signifie que votre ancien mot de passe ne fonctionnera plus !\r\nSi vous avez des questions ou des problèmes concernant vos nouvelles données de connexion,\r\nvous devez contacter l’équipe du site Web ou l’administrateur de « {LOGIN_WEBSITE_TITLE} ».\r\nN’oubliez pas de vider le cache de votre navigateur avant d’utiliser le nouveau pour éviter des échecs inattendus.\r\n\r\nCordialement\r\n------------------------------------\r\nCe message a été généré automatiquement\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_INFO']          = "\r\nBonjour {LOGIN_DISPLAY_NAME},\r\n\r\nBienvenue sur « {LOGIN_WEBSITE_TITLE} ».\r\n\r\nVos identifiants de connexion pour « {LOGIN_WEBSITE_TITLE} » sont :\r\nNom d’utilisateur : xxxxx\r\nMot de passe : {LOGIN_PASSWORD}\r\n\r\nCordialement\r\n\r\nMerci de :\r\nsi vous avez reçu ce message par erreur, veuillez le supprimer immédiatement !\r\n-------------------------------------\r\nCe message a été généré automatiquement !\r\n";
$MESSAGE['SIGNUP2_NEW_USER']                 = 'Un nouvel utilisateur a été enregistré';
$MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO']       = 'Vos identifiants de connexion...';
$MESSAGE['SIGNUP2_SUBJECT_NEW_USER']         = 'Merci de vous être inscrit';
$MESSAGE['SIGNUP_NO_EMAIL']                  = 'Vous devez saisir une adresse e-mail';
$MESSAGE['START_CURRENT_USER']               = 'Vous êtes actuellement connecté en tant que :';
$MESSAGE['START_INSTALL_DIR_EXISTS']         = 'Attention, le répertoire d’installation existe toujours !';
$MESSAGE['START_UPGRADE_SCRIPT_EXISTS']      = 'Veuillez supprimer le fichier {{file}} de votre espace web.';
$MESSAGE['START_WELCOME_MESSAGE']            = 'Bienvenue dans l’administration de WebsiteBaker';
$MESSAGE['TEMPLATES_CHANGE_TEMPLATE_NOTICE'] = 'Veuillez noter : pour changer le modèle, vous devez aller dans la section Paramètres';
$MESSAGE['THEME_ALREADY_EXISTS']             = 'Ce nouveau descripteur de thème existe déjà.';
$MESSAGE['THEME_COPY_CURRENT']               = 'Copier le thème actif actuel et l’enregistrer sous un nouveau nom.';
$MESSAGE['THEME_DESTINATION_READONLY']       = 'Aucun droit de créer un nouveau répertoire de thème !';
$MESSAGE['THEME_IMPORT_HTT']                 = 'Importer des modèles supplémentaires dans le thème actif actuel.<br />Utilisez ces modèles pour écraser le modèle par défaut correspondant.';
$MESSAGE['THEME_INVALID_SOURCE_DESTINATION'] = 'Descripteur invalide fourni pour le nouveau thème !';
$MESSAGE['UNKNOW_UPLOAD_ERROR']              = 'Erreur de téléchargement inconnue';
$MESSAGE['UPLOAD_ERR_CANT_WRITE']            = 'Échec de l’écriture du fichier sur le disque';
$MESSAGE['UPLOAD_ERR_EXTENSION']             = 'Le téléchargement du fichier a été arrêté par l’extension';
$MESSAGE['UPLOAD_ERR_FORM_SIZE']             = 'Le fichier téléchargé dépasse la directive MAX_FILE_SIZE spécifiée dans le formulaire HTML';
$MESSAGE['UPLOAD_ERR_INI_SIZE']              = 'Le fichier téléchargé dépasse la directive upload_max_filesize dans php.ini';
$MESSAGE['UPLOAD_ERR_NO_FILE']               = 'Aucun fichier n’a été téléchargé';
$MESSAGE['UPLOAD_ERR_NO_TMP_DIR']            = 'Dossier temporaire manquant';
$MESSAGE['UPLOAD_ERR_OK']                    = 'Les fichiers ont été téléchargés avec succès';
$MESSAGE['UPLOAD_ERR_PARTIAL']               = 'Le fichier téléchargé n’a été que partiellement téléchargé';
$MESSAGE['USERS_ADDED']                      = 'Utilisateur ajouté avec succès';
$MESSAGE['USERS_CANT_SELFDELETE']            = 'Fonction refusée, vous ne pouvez pas vous supprimer vous-même !';
$MESSAGE['USERS_CHANGING_PASSWORD']          = 'Veuillez noter : vous ne devez saisir des valeurs dans les champs ci-dessus que si vous souhaitez modifier le mot de passe de cet utilisateur';
$MESSAGE['USERS_CONFIRM_DELETE']             = 'Êtes-vous sûr de vouloir supprimer l’utilisateur sélectionné ?';
$MESSAGE['USERS_DELETED']                    = 'Utilisateur supprimé avec succès';
$MESSAGE['USERS_DISPLAYNAME_TAKEN']          = 'Le nom d’affichage spécifié est déjà utilisé.';
$MESSAGE['USERS_EMAIL_TAKEN']                = 'L’adresse e-mail que vous avez saisie est déjà utilisée';
$MESSAGE['USERS_INVALID_EMAIL']              = 'L’adresse e-mail que vous avez saisie est invalide';
$MESSAGE['USERS_NAME_INVALID_CHARS']         = 'Caractères invalides trouvés pour le nom d’utilisateur';
$MESSAGE['USERS_NO_GROUP']                   = 'Aucun groupe n’a été sélectionné';
$MESSAGE['USERS_PASSWORD_MISMATCH']          = 'Les mots de passe que vous avez saisis ne correspondent pas';
$MESSAGE['USERS_PASSWORD_TOO_SHORT']         = 'Le mot de passe que vous avez saisi était trop court';
$MESSAGE['USERS_SAVED']                      = 'Utilisateur enregistré avec succès';
$MESSAGE['USERS_USERNAME_TAKEN']             = 'Le nom d’utilisateur que vous avez saisi est déjà pris';
$MESSAGE['USERS_USERNAME_TOO_SHORT']         = 'Le nom d’utilisateur que vous avez saisi était trop court';
$OVERVIEW['ADMINTOOLS']                     = 'Accéder aux outils d’administration de WebsiteBaker...';
$OVERVIEW['GROUPS']                         = 'Gérer les groupes d’utilisateurs et leurs permissions système...';
$OVERVIEW['HELP']                           = 'Des questions ? Trouvez votre réponse...';
$OVERVIEW['LANGUAGES']                      = 'Gérer les langues de WebsiteBaker...';
$OVERVIEW['MEDIA']                          = 'Gérer les fichiers stockés dans le dossier média...';
$OVERVIEW['MODULES']                        = 'Gérer les modules de WebsiteBaker...';
$OVERVIEW['PAGES']                          = 'Gérer les pages de votre site web...';
$OVERVIEW['PREFERENCES']                    = 'Modifier les préférences telles que l’adresse e-mail, le mot de passe, etc... ';
$OVERVIEW['SETTINGS']                       = 'Modifie les paramètres de WebsiteBaker...';
$OVERVIEW['START']                          = 'Vue d’ensemble de l’administration';
$OVERVIEW['TEMPLATES']                      = 'Modifier l’apparence de votre site web avec des modèles...';
$OVERVIEW['USERS']                          = 'Gérer les utilisateurs qui peuvent se connecter à WebsiteBaker...';
$OVERVIEW['VIEW']                           = 'Visualiser et parcourir rapidement votre site web dans une nouvelle fenêtre...';
$TEXT['ACCOUNT_SIGNUP']                     = 'Création de compte';
$TEXT['ACTIONS']                            = 'Actions';
$TEXT['ACTIVE']                             = 'Actif';
$TEXT['ADD']                                = 'Ajouter';
$TEXT['ADDON']                              = 'Add-on';
$TEXT['ADD_SECTION']                        = 'Ajouter une section';
$TEXT['ADMIN']                              = 'Admin';
$TEXT['ADMINISTRATION']                     = 'Administration';
$TEXT['ADMINISTRATION_TOOL']                = 'Outil d’administration';
$TEXT['ADMINISTRATOR']                      = 'Administrateur';
$TEXT['ADMINISTRATORS']                     = 'Administrateurs';
$TEXT['ADVANCED']                           = 'Avancé';
$TEXT['ALLOWED_FILETYPES_ON_UPLOAD']        = 'Types de fichiers autorisés lors du téléchargement';
$TEXT['ALLOWED_VIEWERS']                    = 'Spectateurs autorisés';
$TEXT['ALLOW_MULTIPLE_SELECTIONS']          = 'Permettre des sélections multiples';
$TEXT['ALL_WORDS']                          = 'Tous les mots';
$TEXT['ANCHOR']                             = 'Ancre';
$TEXT['ANONYMOUS']                          = 'Anonyme';
$TEXT['ANY_WORDS']                          = 'N’importe quel mot';
$TEXT['APP_NAME']                           = 'Nom de l’application';
$TEXT['ARE_YOU_SURE']                       = 'Êtes-vous sûr ?';
$TEXT['AUTHOR']                             = 'Auteur';
$TEXT['BACK']                               = 'Retour';
$TEXT['BACKUP']                             = 'Sauvegarde';
$TEXT['BACKUP_ALL_TABLES']                  = 'Sauvegarder toutes les tables de la base de données';
$TEXT['BACKUP_DATABASE']                    = 'Sauvegarder la base de données';
$TEXT['BACKUP_MEDIA']                       = 'Sauvegarder les médias';
$TEXT['BACKUP_WB_SPECIFIC']                 = 'Sauvegarder uniquement les tables spécifiques à WB';
$TEXT['BASIC']                              = 'Basique';
$TEXT['BLOCK']                              = 'Bloquer';
$TEXT['BROWSE_UPLOAD_FILE']                 = 'Sélectionnez un fichier !';
$TEXT['CALENDAR']                           = 'Calendrier';
$TEXT['CANCEL']                             = 'Annuler';
$TEXT['CAN_DELETE_HIMSELF']                 = 'Peut se supprimer lui-même';
$TEXT['CAPTCHA_VERIFICATION']               = 'Vérification Captcha';
$TEXT['CAP_EDIT_CSS']                       = 'Modifier le CSS';
$TEXT['CHANGE']                             = 'Changer';
$TEXT['CHANGES']                            = 'Changements';
$TEXT['CHANGE_SETTINGS']                    = 'Changer les paramètres';
$TEXT['CHARSET']                            = 'Jeu de caractères';
$TEXT['CHECKBOX_GROUP']                     = 'Groupe de cases à cocher';
$TEXT['CLOSE']                              = 'Fermer';
$TEXT['CODE']                               = 'Code';
$TEXT['CODE_SNIPPET']                       = 'Extrait de code';
$TEXT['COLLAPSE']                           = 'Réduire';
$TEXT['COMMENT']                            = 'Commentaire';
$TEXT['COMMENTING']                         = 'Commenter';
$TEXT['COMMENTS']                           = 'Commentaires';
$TEXT['CONFIRM']                            = 'Confirmer';
$TEXT['CREATE_FOLDER']                      = 'Créer un dossier';
$TEXT['CURRENT']                            = 'Actuel';
$TEXT['CURRENT_FOLDER']                     = 'Dossier actuel';
$TEXT['CURRENT_PAGE']                       = 'Page actuelle';
$TEXT['CURRENT_PASSWORD']                   = 'Mot de passe actuel';
$TEXT['CUSTOM']                             = 'Personnalisé';
$TEXT['DATABASE']                           = 'Base de données';
$TEXT['DATE']                               = 'Date';
$TEXT['DATE_FORMAT']                        = 'Format de date';
$TEXT['DEFAULT']                            = 'Par défaut';
$TEXT['DEFAULT_CHARSET']                    = 'Jeu de caractères par défaut';
$TEXT['DEFAULT_TEXT']                       = 'Texte par défaut';
$TEXT['DELETE']                             = 'Supprimer';
$TEXT['DELETED']                            = 'Supprimé';
$TEXT['DELETE_DATE']                        = 'Date de suppression';
$TEXT['DELETE_ZIP']                         = 'Supprimer l’archive zip après décompression';
$TEXT['DESCRIPTION']                        = 'Description';
$TEXT['DESIGNED_FOR']                       = 'Conçu pour';
$TEXT['DEV_INFOS']                          = 'Informations développeur';
$TEXT['DIRECTORIES']                        = 'Répertoires';
$TEXT['DIRECTORY_MODE']                     = 'Mode répertoire';
$TEXT['DISABLED']                           = 'Désactivé';
$TEXT['DISPLAY_NAME']                       = 'Nom d’affichage';
$TEXT['EMAIL']                              = 'E-mail';
$TEXT['EMAIL_ADDRESS']                      = 'Adresse e-mail';
$TEXT['EMPTY_TRASH']                        = 'Vider la corbeille';
$TEXT['ENABLED']                            = 'Activé';
$TEXT['END']                                = 'Fin';
$TEXT['ERROR']                              = 'Erreur';
$TEXT['EXACT_MATCH']                        = 'Correspondance exacte';
$TEXT['EXECUTE']                            = 'Exécuter';
$TEXT['EXPAND']                             = 'Développer';
$TEXT['EXTENSION']                          = 'Extension';
$TEXT['FIELD']                              = 'Champ';
$TEXT['FILE']                               = 'Fichier';
$TEXT['FILES']                              = 'Fichiers';
$TEXT['FILESYSTEM_PERMISSIONS']             = 'Permissions du système de fichiers';
$TEXT['FILE_MODE']                          = 'Mode fichier';
$TEXT['FINISH_PUBLISHING']                  = 'Terminer la publication';
$TEXT['FOLDER']                             = 'Dossier';
$TEXT['FOLDERS']                            = 'Dossiers';
$TEXT['FOOTER']                             = 'Pied de page';
$TEXT['FORGOTTEN_DETAILS']                  = 'Détails oubliés ?';
$TEXT['FORGOT_DETAILS']                     = 'Détails oubliés ?';
$TEXT['FROM']                               = 'De';
$TEXT['FRONTEND']                           = 'Frontend';
$TEXT['FULL_NAME']                          = 'Nom complet';
$TEXT['FUNCTION']                           = 'Fonction';
$TEXT['GROUP']                              = 'Groupe';
$TEXT['GUEST']                              = 'Invité';
$TEXT['HEADER']                             = 'En-tête';
$TEXT['HEADING']                            = 'Titre';
$TEXT['HEADING_CSS_FILE']                   = 'Fichier de module actuel : ';
$TEXT['HEIGHT']                             = 'Hauteur';
$TEXT['HIDDEN']                             = 'Masqué';
$TEXT['HIDE']                               = 'Masquer';
$TEXT['HIDE_ADVANCED']                      = 'Masquer les options avancées';
$TEXT['HOME']                               = 'Accueil';
$TEXT['HOMEPAGE_REDIRECTION']               = 'Redirection de la page d’accueil';
$TEXT['HOME_FOLDER']                        = 'Dossier personnel';
$TEXT['HOME_FOLDERS']                       = 'Dossiers personnels';
$TEXT['HOST']                               = 'Hôte';
$TEXT['ICON']                               = 'Icône';
$TEXT['IMAGE']                              = 'Image';
$TEXT['INLINE']                             = 'En ligne';
$TEXT['INSTALL']                            = 'Installer';
$TEXT['INSTALLATION']                       = 'Installation';
$TEXT['INSTALLATION_PATH']                  = 'Chemin d’installation';
$TEXT['INSTALLATION_URL']                   = 'URL d’installation';
$TEXT['INSTALLED']                          = 'installé';
$TEXT['INTRO']                              = 'Intro';
$TEXT['INTRO_PAGE']                         = 'Page d’introduction';
$TEXT['INVALID_SIGNS']                      = 'doit commencer par une lettre ou contient des caractères invalides';
$TEXT['KEYWORDS']                           = 'Mots-clés';
$TEXT['LANGUAGE']                           = 'Langue';
$TEXT['LAST_UPDATED_BY']                    = 'Dernière mise à jour par';
$TEXT['LENGTH']                             = 'Longueur';
$TEXT['LEVEL']                              = 'Niveau';
$TEXT['LICENSE']                            = 'Licence';
$TEXT['LINK']                               = 'Lien';
$TEXT['LINUX_UNIX_BASED']                   = 'Basé sur Linux/Unix';
$TEXT['LIST_OPTIONS']                       = 'Options de la liste';
$TEXT['LOGGED_IN']                          = 'Connecté';
$TEXT['LOGIN']                              = 'Connexion';
$TEXT['LONG']                               = 'Long';
$TEXT['LONG_TEXT']                          = 'Texte long';
$TEXT['LOOP']                               = 'Boucle';
$TEXT['MAIN']                               = 'Principal';
$TEXT['USER_LOGIN_ON']                      = 'Autoriser la connexion utilisateur';
$TEXT['USER_LOGIN_OFF']                     = 'Empêcher la connexion utilisateur';
$TEXT['MAINTENANCE_OFF']                    = 'Maintenance désactivée';
$TEXT['MAINTENANCE_ON']                     = 'Maintenance activée';
$TEXT['MANAGE']                             = 'Gérer';
$TEXT['MANAGE_GROUPS']                      = 'Gérer les groupes';
$TEXT['MANAGE_USERS']                       = 'Gérer les utilisateurs';
$TEXT['MATCH']                              = 'Correspondance';
$TEXT['MATCHING']                           = 'Correspondant';
$TEXT['MAX_EXCERPT']                        = 'Nombre max. de lignes d’extrait';
$TEXT['MAX_SUBMISSIONS_PER_HOUR']           = 'Max. Soumissions par heure';
$TEXT['MEDIA_DIRECTORY']                    = 'Répertoire média';
$TEXT['MENU']                               = 'Menu';
$TEXT['MENU_ICON_0']                        = 'Icône de menu normale';
$TEXT['MENU_ICON_1']                        = 'Icône de menu au survol';
$TEXT['MENU_TITLE']                         = 'Titre du menu';
$TEXT['MESSAGE']                            = 'Message';
$TEXT['MODIFY']                             = 'Modifier';
$TEXT['MODIFY_CONTENT']                     = 'Modifier le contenu';
$TEXT['MODIFY_SETTINGS']                    = 'Modifier les paramètres';
$TEXT['MODULE_ORDER']                       = 'Ordre des modules pour la recherche';
$TEXT['MODULE_PERMISSIONS']                 = 'Permissions du module';
$TEXT['MORE']                               = 'Plus';
$TEXT['MOVE_DOWN']                          = 'Déplacer vers le bas';
$TEXT['MOVE_UP']                            = 'Déplacer vers le haut';
$TEXT['MULTILINGUAL']                       = 'MULTILINGUE';
$TEXT['MULTIPLE_MENUS']                     = 'Menus multiples';
$TEXT['MULTISELECT']                        = 'Sélection multiple';
$TEXT['NAME']                               = 'Nom';
$TEXT['NEED_CURRENT_PASSWORD']              = 'confirmer avec le mot de passe actuel';
$TEXT['NEED_TO_LOGIN']                      = 'Besoin de se connecter ?';
$TEXT['NEW_PASSWORD']                       = 'Nouveau mot de passe';
$TEXT['NEW_WINDOW']                         = 'Nouvelle fenêtre';
$TEXT['NEXT']                               = 'Suivant';
$TEXT['NEXT_PAGE']                          = 'Page suivante';
$TEXT['NO']                                 = 'Non';
$TEXT['NONE']                               = 'Aucun';
$TEXT['NONE_FOUND']                         = 'Aucun trouvé';
$TEXT['NOT_FOUND']                          = 'Non trouvé';
$TEXT['NOT_INSTALLED']                      = 'non installé';
$TEXT['NO_IMAGE_SELECTED']                  = 'aucune image sélectionnée';
$TEXT['NO_RESULTS']                         = 'Aucun résultat';
$TEXT['NO_SELECTION']                       = 'aucune sélection';
$TEXT['OF']                                 = 'de';
$TEXT['ON']                                 = 'activé';
$TEXT['OPEN']                               = 'Ouvrir';
$TEXT['OPTION']                             = 'Option';
$TEXT['OTHERS']                             = 'Autres';
$TEXT['OUT_OF']                             = 'Hors de';
$TEXT['OVERWRITE_EXISTING']                 = 'Écraser les existants';
$TEXT['PAGE']                               = 'Page';
$TEXT['PAGES_DIRECTORY']                    = 'Répertoire des pages';
$TEXT['PAGES_PERMISSION']                   = 'Permission des pages';
$TEXT['PAGES_PERMISSIONS']                  = 'Permissions des pages';
$TEXT['PAGE_EXTENSION']                     = 'Extension de page';
$TEXT['PAGE_ICON']                          = 'Icône de page';
$TEXT['PAGE_ICON_DIR']                      = 'Chemin pages/images de menu';
$TEXT['PAGE_LANGUAGES']                     = 'Langues de la page';
$TEXT['PAGE_LEVEL_LIMIT']                   = 'Limite de niveau de page';
$TEXT['PAGE_SPACER']                        = 'Espaceur de page';
$TEXT['PAGE_TITLE']                         = 'Titre de la page';
$TEXT['PAGE_TRASH']                         = 'Corbeille des pages';
$TEXT['PARENT']                             = 'Parent';
$TEXT['PASSWORD']                           = 'Mot de passe';
$TEXT['PATH']                               = 'Chemin';
$TEXT['PHP_ERROR_LEVEL']                    = 'Niveau de rapport d’erreurs PHP';
$TEXT['PLEASE_LOGIN']                       = 'Veuillez vous connecter';
$TEXT['PLEASE_SELECT']                      = 'Veuillez sélectionner';
$TEXT['POST']                               = 'Message';
$TEXT['POSTS_PER_PAGE']                     = 'Messages par page';
$TEXT['POST_FOOTER']                        = 'Pied de message';
$TEXT['POST_HEADER']                        = 'En-tête de message';
$TEXT['PREVIOUS']                           = 'Précédent';
$TEXT['PREVIOUS_PAGE']                      = 'Page précédente';
$TEXT['PRIVATE']                            = 'Privé';
$TEXT['PRIVATE_VIEWERS']                    = 'Spectateurs privés';
$TEXT['PROFILES_EDIT']                      = 'Modifier le profil';
$TEXT['PUBLIC']                             = 'Public';
$TEXT['PUBL_END_DATE']                      = 'Date de fin';
$TEXT['PUBL_START_DATE']                    = 'Date de début';
$TEXT['RADIO_BUTTON_GROUP']                 = 'Groupe de boutons radio';
$TEXT['READ']                               = 'Lire';
$TEXT['READ_MORE']                          = 'Lire la suite';
$TEXT['REDIRECT_AFTER']                     = 'Rediriger après';
$TEXT['REGISTERED']                         = 'Enregistré';
$TEXT['REGISTERED_VIEWERS']                 = 'Spectateurs enregistrés';
$TEXT['RELOAD']                             = 'Recharger';
$TEXT['REMEMBER_ME']                        = 'Se souvenir de moi';
$TEXT['RENAME']                             = 'Renommer';
$TEXT['RENAME_FILES_ON_UPLOAD']             = 'Pas de téléchargement pour ces types de fichiers';
$TEXT['REQUIRED']                           = 'Obligatoire';
$TEXT['REQUIREMENT']                        = 'Exigence';
$TEXT['RESET']                              = 'Réinitialiser';
$TEXT['RESIZE']                             = 'Redimensionner';
$TEXT['RESIZE_IMAGE_TO']                    = 'Redimensionner l’image à';
$TEXT['REFILL']                             = 'Réinitialiser les entrées';
$TEXT['RESTORE']                            = 'Réinitialiser les entrées';
$TEXT['RESTORE_DATABASE']                   = 'Restaurer la base de données';
$TEXT['RESTORE_MEDIA']                      = 'Restaurer les médias';
$TEXT['RESULTS']                            = 'Résultats';
$TEXT['RESULTS_FOOTER']                     = 'Pied de page des résultats';
$TEXT['RESULTS_FOR']                        = 'Résultats pour';
$TEXT['RESULTS_HEADER']                     = 'En-tête des résultats';
$TEXT['RESULTS_LOOP']                       = 'Boucle des résultats';
$TEXT['RETYPE_NEW_PASSWORD']                = 'Retaper le nouveau mot de passe';
$TEXT['RETYPE_PASSWORD']                    = 'Retaper le mot de passe';
$TEXT['SAME_WINDOW']                        = 'Même fenêtre';
$TEXT['SAVE']                               = 'Enregistrer';
$TEXT['SEARCH']                             = 'Rechercher';
$TEXT['SEARCHING']                          = 'Recherche';
$TEXT['SECTION']                            = 'Section';
$TEXT['SECTION_BLOCKS']                     = 'Blocs de section';
$TEXT['SEC_ANCHOR']                         = 'Texte d’ancrage de section';
$TEXT['SELECT_BOX']                         = 'Boîte de sélection';
$TEXT['SEND_DETAILS']                       = 'Envoyer les détails';
$TEXT['SEPARATE']                           = 'Séparé';
$TEXT['SEPERATOR']                          = 'Séparateur';
$TEXT['SERVER_EMAIL']                       = 'E-mail du serveur';
$TEXT['SERVER_OPERATING_SYSTEM']            = 'Système d’exploitation du serveur';
$TEXT['SESSION_IDENTIFIER']                 = 'Identifiant de session';
$TEXT['SETTINGS']                           = 'Paramètres';
$TEXT['SHORT']                              = 'Court';
$TEXT['SHORT_TEXT']                         = 'Texte court';
$TEXT['SHOW']                               = 'Afficher';
$TEXT['SHOW_ADVANCED']                      = 'Afficher les options avancées';
$TEXT['SIGNUP']                             = 'S’inscrire';
$TEXT['SIZE']                               = 'Taille';
$TEXT['SMART_LOGIN']                        = 'Connexion intelligente';
$TEXT['START']                              = 'Démarrer';
$TEXT['START_PUBLISHING']                   = 'Commencer la publication';
$TEXT['SUBJECT']                            = 'Sujet';
$TEXT['SUBMISSIONS']                        = 'Soumissions';
$TEXT['SUBMISSIONS_STORED_IN_DATABASE']     = 'Soumissions stockées dans la base de données';
$TEXT['SUBMISSION_ID']                      = 'ID de soumission';
$TEXT['SUBMITTED']                          = 'Soumis';
$TEXT['SUCCESS']                            = 'Succès';
$TEXT['SYSTEM_DEFAULT']                     = 'Système par défaut';
$TEXT['SYSTEM_PERMISSIONS']                 = 'Permissions système';
$TEXT['TABLE_PREFIX']                       = 'Préfixe de table';
$TEXT['TARGET']                             = 'Cible';
$TEXT['TARGET_FOLDER']                      = 'Dossier cible';
$TEXT['TEMPLATE']                           = 'Modèle';
$TEXT['TEMPLATE_PERMISSIONS']               = 'Permissions de modèle';
$TEXT['TEXT']                               = 'Texte';
$TEXT['TEXTAREA']                           = 'Zone de texte';
$TEXT['TEXTFIELD']                          = 'Champ de texte';
$TEXT['THEME']                              = 'Thème du backend';
$TEXT['THEME_COPY_CURRENT']                 = 'Copier le thème du backend.';
$TEXT['THEME_CURRENT']                      = 'thème actif actuel';
$TEXT['THEME_IMPORT_HTT']                   = 'Importer des modèles supplémentaires';
$TEXT['THEME_NEW_NAME']                     = 'Nom du nouveau thème';
$TEXT['THEME_NOMORE_HTT']                   = 'plus disponible';
$TEXT['THEME_SELECT_HTT']                   = 'sélectionner des modèles';
$TEXT['THEME_START_COPY']                   = 'copier';
$TEXT['THEME_START_IMPORT']                 = 'importer';
$TEXT['TIME']                               = 'Heure';
$TEXT['TIMEZONE']                           = 'Fuseau horaire';
$TEXT['TIME_FORMAT']                        = 'Format de l’heure';
$TEXT['TIME_LIMIT']                         = 'Temps max. pour collecter des extraits par module';
$TEXT['TITLE']                              = 'Titre';
$TEXT['TO']                                 = 'À';
$TEXT['TOP_FRAME']                          = 'Cadre supérieur';
$TEXT['TRASH_EMPTIED']                      = 'Corbeille vidée';
$TEXT['TXT_EDIT_CSS_FILE']                  = 'Modifiez les définitions CSS dans la zone de texte ci-dessous.';
$TEXT['TYPE']                               = 'Type';
$TEXT['UNDER_CONSTRUCTION']                 = 'En construction';
$TEXT['UNINSTALL']                          = 'Désinstaller';
$TEXT['UNKNOWN']                            = 'Inconnu';
$TEXT['UNLIMITED']                          = 'Illimité';
$TEXT['UNZIP_FILE']                         = 'Télécharger et décompresser une archive zip';
$TEXT['UP']                                 = 'Haut';
$TEXT['UPGRADE']                            = 'Mise à niveau';
$TEXT['UPLOAD_FILES']                       = 'Télécharger fichier(s)';
$TEXT['URL']                                = 'URL';
$TEXT['USER']                               = 'Utilisateur';
$TEXT['USERNAME']                           = 'Nom d’utilisateur';
$TEXT['USERS_ACTIVE']                       = 'L’utilisateur est actif';
$TEXT['USERS_CAN_SELFDELETE']               = 'L’utilisateur peut se supprimer lui-même';
$TEXT['USERS_CHANGE_SETTINGS']              = 'L’utilisateur peut modifier ses propres paramètres';
$TEXT['USERS_DELETED']                      = 'L’utilisateur est marqué comme supprimé';
$TEXT['USERS_FLAGS']                        = 'Drapeaux utilisateur';
$TEXT['USERS_PROFILE_ALLOWED']              = 'L’utilisateur peut créer un profil étendu';
$TEXT['VERIFICATION']                       = 'Vérification';
$TEXT['VERSION']                            = 'Version';
$TEXT['VIEW']                               = 'Voir';
$TEXT['VIEW_DELETED_PAGES']                 = 'Voir les pages supprimées';
$TEXT['VIEW_DETAILS']                       = 'Voir les détails';
$TEXT['VISIBILITY']                         = 'Visibilité';
$TEXT['WBMAILER_DEFAULT_SENDER_MAIL']       = 'Adresse "De" par défaut';
$TEXT['WBMAILER_DEFAULT_SENDER_NAME']       = 'Nom de l’expéditeur par défaut';
$TEXT['WBMAILER_DEFAULT_SETTINGS_NOTICE']   = 'Veuillez spécifier une adresse "DE" et un nom d’"EXPÉDITEUR" par défaut ci-dessous. Il est recommandé d’utiliser une adresse DE : comme : <strong>admin@votredomaine.com</strong>. Certains fournisseurs de messagerie (par exemple, <em>mail.com</em>) peuvent rejeter les courriels avec une adresse DE : comme <em>nom@mail.com</em> envoyés via un relais étranger pour éviter le spam.<br /><br />Les valeurs par défaut ne sont utilisées que si aucune autre valeur n’est spécifiée par WebsiteBaker. Si votre serveur prend en charge <abbr title="Protocole simple de transfert de courrier">SMTP</abbr>, vous voudrez peut-être utiliser cette option pour le courrier sortant.';
$TEXT['WBMAILER_FUNCTION']                  = 'Routine de courrier';
$TEXT['WBMAILER_NOTICE']                    = '<strong>Paramètres du Mailer SMTP :</strong><br />Les paramètres ci-dessous ne sont requis que si vous souhaitez envoyer du courrier via <abbr title="Protocole simple de transfert de courrier">SMTP</abbr>. Si vous ne connaissez pas votre hôte SMTP ou si vous n’êtes pas sûr des paramètres requis, restez simplement avec la routine de courrier par défaut : PHP MAIL.';
$TEXT['WBMAILER_PHP']                       = 'MAIL PHP';
$TEXT['WBMAILER_SMTP']                      = 'SMTP';
$TEXT['WBMAILER_SMTP_AUTH']                 = 'Authentification SMTP';
$TEXT['WBMAILER_SMTP_AUTH_NOTICE']          = 'activer uniquement si votre hôte SMTP nécessite une authentification';
$TEXT['WBMAILER_SMTP_HOST']                 = 'Hôte SMTP';
$TEXT['WBMAILER_SMTP_PASSWORD']             = 'Mot de passe SMTP';
$TEXT['WBMAILER_SMTP_USERNAME']             = 'Nom d’utilisateur SMTP';
$TEXT['WEBSITE']                            = 'Site Web';
$TEXT['WEBSITE_DESCRIPTION']                = 'Description des métadonnées';
$TEXT['WEBSITE_FOOTER']                     = 'Pied de page du site Web';
$TEXT['WEBSITE_HEADER']                     = 'En-tête du site Web';
$TEXT['WEBSITE_KEYWORDS']                   = 'Mots-clés des métadonnées';
$TEXT['WEBSITE_TITLE']                      = 'Titre des métadonnées';
$TEXT['WELCOME_BACK']                       = 'Bienvenue';
$TEXT['WIDTH']                              = 'Largeur';
$TEXT['WINDOW']                             = 'Fenêtre';
$TEXT['WINDOWS']                            = 'Windows';
$TEXT['WORLD_WRITEABLE_FILE_PERMISSIONS']   = 'Permissions de fichier inscriptibles par tous';
$TEXT['WRITE']                              = 'Écrire';
$TEXT['WYSIWYG_EDITOR']                     = 'Éditeur WYSIWYG';
$TEXT['WYSIWYG_STYLE']                      = 'Style WYSIWYG';
$TEXT['YES']                                = 'Oui';

$TEXT['NO_REVERT'] = 'Vous ne pouvez pas annuler cela !';
$TEXT['NO_DELETED'] = 'La suppression n’a pas été exécutée !';
$TEXT['PAGE_CODE'] = 'Code de page';