<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of \languages\DA
 * @package          CoreTranslation
 * @copyright        Manuela v.d.Decken <manuela@isteam.de>
 * @author          $Author: Uwe $
 * @license         GNU General Public License 2.0
 * @version         4.0.3
 * @revision        $Revision: 63 $
 * @since           $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @lastmodified    $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @deprecated      no
 * @description     CoreTranslation
 * @svn-id          $Header: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/languages/DA.php 63 2025-09-01 10:08:14Z Uwe $
 */

//declare(strict_types = 1);

//declare(encoding = 'UTF-8');

if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
// Define that this file is loaded
if (!defined('LANGUAGE_LOADED')) { define('LANGUAGE_LOADED', true); }

// Set the language information
$language_code = 'DA';
$language_name = 'Dansk';
$language_version = '4.0.3';
$language_platform = '2.11.0';
$language_author = 'Jacobi22';// All translations by Google AI
$language_license = 'GNU General Public License 2.0';

$HEADING['ADDON_PRECHECK_FAILED']            = 'Add-On krav er ikke opfyldt';
$HEADING['ADD_CHILD_PAGE']                   = 'Tilføj underside';
$HEADING['ADD_GROUP']                        = 'Tilføj gruppe';
$HEADING['ADD_GROUPS']                       = 'Tilføj grupper';
$HEADING['ADD_HEADING']                      = 'Tilføj overskrift';
$HEADING['ADD_PAGE']                         = 'Tilføj side';
$HEADING['ADD_USER']                         = 'Tilføj bruger';
$HEADING['ADMINISTRATION_TOOLS']             = 'Administrationsværktøjer';
$HEADING['BROWSE_MEDIA']                     = 'Gennemse medier';
$HEADING['CREATE_FOLDER']                    = 'Opret mappe';
$HEADING['DEFAULT_SETTINGS']                 = 'Standardindstillinger';
$HEADING['DELETED_PAGES']                    = 'Slettede sider';
$HEADING['FILESYSTEM_SETTINGS']              = 'Filysystemindstillinger';
$HEADING['GENERAL_SETTINGS']                 = 'Generelle indstillinger';
$HEADING['INSTALL_LANGUAGE']                 = 'Installer sprog';
$HEADING['INSTALL_MODULE']                   = 'Installer modul';
$HEADING['INSTALL_TEMPLATE']                 = 'Installer skabelon';
$HEADING['INVOKE_LANGUAGE_FILES']            = 'Udfør sprogfiler manuelt';
$HEADING['INVOKE_MODULE_FILES']              = 'Udfør modulfiler manuelt';
$HEADING['INVOKE_TEMPLATE_FILES']            = 'Udfør skabelonfiler manuelt';
$HEADING['LANGUAGE_DETAILS']                 = 'Sprogdetaljer';
$HEADING['MANAGE_SECTIONS']                  = 'Administrer sektioner';
$HEADING['MODIFY_ADVANCED_PAGE_SETTINGS']    = 'Rediger avancerede sideindstillinger';
$HEADING['MODIFY_DELETE_GROUP']              = 'Rediger/slet gruppe';
$HEADING['MODIFY_DELETE_PAGE']               = 'Rediger/slet side';
$HEADING['MODIFY_DELETE_USER']               = 'Rediger/slet bruger';
$HEADING['MODIFY_GROUP']                     = 'Rediger gruppe';
$HEADING['MODIFY_GROUPS']                    = 'Rediger grupper';
$HEADING['MODIFY_INTRO_PAGE']                = 'Rediger introtekst';
$HEADING['MODIFY_PAGE']                      = 'Rediger side';
$HEADING['MODIFY_PAGE_SETTINGS']             = 'Rediger sideindstillinger';
$HEADING['MODIFY_USER']                      = 'Rediger bruger';
$HEADING['MODULE_DETAILS']                   = 'Moduldetaljer';
$HEADING['MY_EMAIL']                         = 'Min e-mail';
$HEADING['MY_PASSWORD']                      = 'Min adgangskode';
$HEADING['MY_SETTINGS']                      = 'Mine indstillinger';
$HEADING['SEARCH_SETTINGS']                  = 'Søgeindstillinger';
$HEADING['SERVER_SETTINGS']                  = 'Serverindstillinger';
$HEADING['TEMPLATE_DETAILS']                 = 'Skabelondetaljer';
$HEADING['UNINSTALL_LANGUAGE']               = 'Afinstaller sprog';
$HEADING['UNINSTALL_MODULE']                 = 'Afinstaller modul';
$HEADING['UNINSTALL_TEMPLATE']               = 'Afinstaller skabelon';
$HEADING['UPGRADE_LANGUAGE']                 = 'Sprogregistrering/opgradering';
$HEADING['UPLOAD_FILES']                     = 'Upload fil(er)';
$HEADING['WBMAILER_SETTINGS']                = 'Mailindstillinger';
$MENU['ACCESS']                             = 'Brugeradministration';
$MENU['ADDON']                              = 'Add-on';
$MENU['ADDONS']                             = 'Add-ons';
$MENU['ADMINTOOLS']                         = 'Admin-værktøjer';
$MENU['BREADCRUMB']                         = 'Du er her: ';
$MENU['FORGOT']                             = 'Hent loginoplysninger';
$MENU['GROUP']                              = 'Gruppe';
$MENU['GROUPS']                             = 'Grupper';
$MENU['HELP']                               = 'Hjælp';
$MENU['LANGUAGES']                          = 'Sprog';
$MENU['LOGIN']                              = 'Login';
$MENU['LOGOUT']                             = 'Log ud';
$MENU['MEDIA']                              = 'Medier';
$MENU['MODULES']                            = 'Moduler';
$MENU['MY_PROFILE']                         = 'Min profil';
$MENU['PAGES']                              = 'Sider';
$MENU['PREFERENCES']                        = 'Indstillinger';
$MENU['REORG_TABLE']                        = 'Reorganiser tabeller';
$MENU['SETTINGS']                           = 'Indstillinger';
$MENU['START']                              = 'Start';
$MENU['TEMPLATES']                          = 'Skabeloner';
$MENU['USERS']                              = 'Brugere';
$MENU['VIEW']                               = 'Vis';
$MESSAGE['ADDON_ERROR_RELOAD']               = 'Fejl under opdatering af Add-On information.';
$MESSAGE['ADDON_LANGUAGES_RELOADED']         = 'Sprog genindlæst med succes';
$MESSAGE['ADDON_MANUAL_FTP_LANGUAGE']        = '<strong>BEMÆRK!</strong> Af sikkerhedsmæssige årsager, overfør kun sprogfiler via FTP til /languages/-mappen og brug opgraderingsfunktionen til at registrere eller opdatere.';
$MESSAGE['ADDON_MANUAL_FTP_WARNING']         = 'Advarsel: Eksisterende moduldatabaseposter vil gå tabt. ';
$MESSAGE['ADDON_MANUAL_INSTALLATION']        = 'Når moduler uploades via FTP (anbefales ikke), vil modulinverteringsfunktionerne <code>install</code>, <code>upgrade</code> eller <code>uninstall</code> ikke blive udført automatisk. Disse moduler fungerer muligvis ikke korrekt eller afinstalleres ikke korrekt.<br /><br />Du kan manuelt udføre modulfunktionerne for moduler uploadet via FTP herunder.';
$MESSAGE['ADDON_MANUAL_INSTALLATION_WARNING']= 'Advarsel: Eksisterende moduldatabaseposter vil gå tabt. Brug kun denne indstilling, hvis du oplever problemer med moduler uploadet via FTP.';
$MESSAGE['ADDON_MANUAL_RELOAD_WARNING']      = 'Advarsel: Eksisterende moduldatabaseposter vil gå tabt. ';
$MESSAGE['ADDON_MODULES_RELOADED']           = 'Moduler genindlæst med succes';
$MESSAGE['ADDON_OVERWRITE_NEWER_FILES']      = 'Overskriv nyere filer';
$MESSAGE['ADDON_PRECHECK_FAILED']            = 'Add-on installation mislykkedes. Dit system opfylder ikke kravene til dette Add-on. For at få dette Add-on til at fungere på dit system, bedes du rette de problemer, der er opsummeret nedenfor.';
$MESSAGE['ADDON_RELOAD']                     = 'Opdater database med information fra Add-on filer (f.eks. efter FTP upload).';
$MESSAGE['ADDON_TEMPLATES_RELOADED']         = 'Skabeloner genindlæst med succes';
$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES']   = 'Utilstrækkelige adgangsrettigheder';
$MESSAGE['FORGOT_PASS_ALREADY_RESET']        = 'Adgangskoden kan kun nulstilles en gang i timen';
$MESSAGE['FORGOT_PASS_CANNOT_EMAIL']         = 'Kan ikke sende adgangskode via e-mail, kontakt venligst systemadministratoren';
$MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND']      = 'Den e-mail, du indtastede, kan ikke findes i databasen';
$MESSAGE['FORGOT_PASS_NO_DATA']              = 'Indtast venligst din e-mailadresse nedenfor';
$MESSAGE['FORGOT_PASS_PASSWORD_RESET']       = 'Din adgangskode er blevet sendt til din e-mailadresse';
$MESSAGE['FRONTEND_SORRY_NO_ACTIVE_SECTIONS']= 'Beklager, intet aktivt indhold at vise';
$MESSAGE['FRONTEND_SORRY_NO_VIEWING_PERMISSIONS'] = 'Beklager, du har ikke tilladelse til at se denne side';
$MESSAGE['GENERIC_ALREADY_INSTALLED']        = 'Allerede installeret';
$MESSAGE['GENERIC_BAD_PERMISSIONS']          = 'Kan ikke skrive til destinationsmappen';
$MESSAGE['GENERIC_BE_PATIENT']               = 'Vær venligst tålmodig.';
$MESSAGE['GENERIC_CANNOT_UNINSTALL']         = 'Kan ikke afinstallere';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE']  = 'Kan ikke afinstallere: den valgte fil er i brug';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL'] = '<br /><br />{{type}} <b>{{type_name}}</b> kunne ikke afinstalleres, fordi den stadig er i brug på {{pages}}.<br /><br />';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL_PAGES'] = 'denne side;disse sider';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_TEMPLATE'] = 'Kan ikke afinstallere skabelonen <b>{{name}}</b>, fordi den er standardskabelonen!';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_THEME'] = 'Kan ikke afinstallere skabelonen <b>{{name}}</b>, fordi den er standard backend-temaet!';
$MESSAGE['GENERIC_CANNOT_UNZIP']             = 'Kan ikke pakke filen ud';
$MESSAGE['GENERIC_CANNOT_UPLOAD']            = 'Kan ikke uploade fil';
$MESSAGE['GENERIC_COMPARE']                  = ' succesfuld';
$MESSAGE['GENERIC_ERROR_OPENING_FILE']       = 'Fejl ved åbning af fil.';
$MESSAGE['GENERIC_FAILED_COMPARE']           = ' mislykkedes';
$MESSAGE['GENERIC_FILE_TYPE']                = 'Bemærk venligst, at filen du uploader, skal være af følgende format:';
$MESSAGE['GENERIC_FILE_TYPES']               = 'Bemærk venligst, at filen du uploader, skal være i et af følgende formater:';
$MESSAGE['GENERIC_FILL_IN_ALL']              = 'Gå venligst tilbage og udfyld alle felter';
$MESSAGE['GENERIC_FORGOT_OPTIONS']           = 'Du har ikke foretaget et valg!';
$MESSAGE['GENERIC_INSTALLED']                = 'Installeret med succes';
$MESSAGE['GENERIC_INVALID']                  = 'Den uploadede fil er ugyldig';
$MESSAGE['GENERIC_INVALID_ADDON_FILE']       = 'Ugyldig WebsiteBaker installationsfil. Kontroller venligst *.zip formatet.';
$MESSAGE['GENERIC_INVALID_LANGUAGE_FILE']    = 'Ugyldig WebsiteBaker sprogfil. Kontroller venligst tekstfilen.';
$MESSAGE['GENERIC_INVALID_MODULE_FILE']      = 'Ugyldig WebsiteBaker modulfild. Kontroller venligst tekstfilen.';
$MESSAGE['GENERIC_INVALID_TEMPLATE_FILE']    = 'Ugyldig WebsiteBaker skabelonfil. Kontroller venligst tekstfilen.';
$MESSAGE['GENERIC_IN_USE']                   = ' men brugt i ';
$MESSAGE['GENERIC_MISSING_ARCHIVE_FILE']     = 'Mangler arkivfil!';
$MESSAGE['GENERIC_MODULE_VERSION_ERROR']     = 'Modulet %s er ikke korrekt installeret!';
$MESSAGE['GENERIC_NOT_COMPARE']              = ' ikke muligt';
$MESSAGE['GENERIC_NOT_INSTALLED']            = 'Ikke installeret';
$MESSAGE['GENERIC_NOT_UPGRADED']             = 'Opdatering ikke mulig';
$MESSAGE['GENERIC_PLEASE_BE_PATIENT']        = 'Vær venligst tålmodig, dette kan tage lidt tid.';
$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON']   = 'Venligst tjek tilbage snart...';
$MESSAGE['GENERIC_SECURITY_ACCESS']          = 'Sikkerhedsbrud!! Adgang nægtet!';
$MESSAGE['GENERIC_SECURITY_OFFENSE']         = 'Sikkerhedsbrud!! Datalagring blev nægtet!';
$MESSAGE['GENERIC_UNINSTALLED']              = 'Afinstalleret med succes';
$MESSAGE['GENERIC_UPGRADED']                 = 'Opgraderet med succes';
$MESSAGE['GENERIC_VERSION_COMPARE']          = 'Versionssammenligning';
$MESSAGE['GENERIC_VERSION_GT']               = 'Opgradering nødvendig!';
$MESSAGE['GENERIC_VERSION_LT']               = 'Nedgradering';
$MESSAGE['GENERIC_WEBSITE_LOCKED']           = 'dette websted er midlertidigt nede for vedligeholdelse';
$MESSAGE['GENERIC_WEBSITE_UNDER_CONSTRUCTION'] = 'Websted under konstruktion';
$MESSAGE['GENERIC_WEBSITE_NO_PAGES']         = 'Dette websted for dette sprog (%s) er stadig under konstruktion';
$MESSAGE['GROUPS_ADDED']                     = 'Gruppe tilføjet med succes';
$MESSAGE['GROUPS_CONFIRM_DELETE']            = 'Er du sikker på, at du vil slette den valgte gruppe (og eventuelle brugere, der tilhører den)?';
$MESSAGE['GROUPS_DELETED']                   = 'Gruppe slettet med succes';
$MESSAGE['GROUPS_GROUP_NAME_BLANK']          = 'Gruppenavn er tomt';
$MESSAGE['GROUPS_GROUP_NAME_EXISTS']         = 'Gruppenavnet eksisterer allerede';
$MESSAGE['GROUPS_NO_GROUPS_FOUND']           = 'Ingen grupper fundet';
$MESSAGE['GROUPS_SAVED']                     = 'Gruppe gemt med succes';
$MESSAGE['LOGIN_AUTHENTICATION_FAILED']      = 'Login-navn eller adgangskode forkert';
$MESSAGE['LOGIN_BOTH_BLANK']                 = 'Indtast venligst dit login-navn og adgangskode';
$MESSAGE['LOGIN_PASSWORD_BLANK']             = 'Indtast venligst en adgangskode';
$MESSAGE['LOGIN_PASSWORD_TOO_LONG']          = 'Angivet adgangskode er for lang';
$MESSAGE['LOGIN_PASSWORD_TOO_SHORT']         = 'Angivet adgangskode er for kort';
$MESSAGE['LOGIN_USERNAME_BLANK']             = 'Indtast venligst et login-navn';
$MESSAGE['LOGIN_USERNAME_TOO_LONG']          = 'Angivet login-navn er for langt';
$MESSAGE['LOGIN_USERNAME_TOO_SHORT']         = 'Angivet login-navn er for kort';
$MESSAGE['MEDIA_BLANK_EXTENSION']            = 'Du har ikke angivet en filendelse';
$MESSAGE['MEDIA_BLANK_NAME']                 = 'Du har ikke angivet et nyt navn';
$MESSAGE['MEDIA_CANNOT_DELETE_DIR']          = 'Kan ikke slette den valgte mappe';
$MESSAGE['MEDIA_CANNOT_DELETE_FILE']         = 'Kan ikke slette den valgte fil';
$MESSAGE['MEDIA_CANNOT_RENAME']              = 'Omdøbning mislykkedes';
$MESSAGE['MEDIA_CONFIRM_DELETE']             = 'Er du sikker på, at du vil slette følgende fil eller mappe?';
$MESSAGE['MEDIA_DELETED_DIR']                = 'Mappe slettet med succes';
$MESSAGE['MEDIA_DELETED_FILE']               = 'Fil slettet med succes';
$MESSAGE['MEDIA_DIR_ACCESS_DENIED']          = 'Den angivne mappe eksisterer ikke eller er ikke tilladt.';
$MESSAGE['MEDIA_DIR_DOES_NOT_EXIST']         = 'Mappe eksisterer ikke';
$MESSAGE['MEDIA_DIR_DOT_DOT_SLASH']          = 'Kan ikke inkludere ../ i mappenavnet';
$MESSAGE['MEDIA_DIR_EXISTS']                 = 'En mappe med det navn, du indtastede, eksisterer allerede';
$MESSAGE['MEDIA_DIR_MADE']                   = 'Mappe oprettet med succes';
$MESSAGE['MEDIA_DIR_NOT_MADE']               = 'Kan ikke oprette mappe';
$MESSAGE['MEDIA_FILE_EXISTS']                = 'En fil med det navn, du indtastede, eksisterer allerede';
$MESSAGE['MEDIA_FILE_NOT_FOUND']             = 'Fil ikke fundet';
$MESSAGE['MEDIA_NAME_DOT_DOT_SLASH']         = 'Kan ikke inkludere ../ i navnet';
$MESSAGE['MEDIA_NAME_INDEX_PHP']             = 'Kan ikke bruge index.php som navn';
$MESSAGE['MEDIA_NONE_FOUND']                 = 'Ingen medier fundet i den aktuelle mappe';
$MESSAGE['MEDIA_NO_FILE_UPLOADED']           = 'Ingen fil blev modtaget';
$MESSAGE['MEDIA_RENAMED']                    = 'Omdøbning vellykket';
$MESSAGE['MEDIA_SINGLE_UPLOADED']            = ' fil blev uploadet med succes';
$MESSAGE['MEDIA_TARGET_DOT_DOT_SLASH']       = 'Må ikke have ../ i destinationsmappen';
$MESSAGE['MEDIA_UPLOADED']                   = ' filer blev uploadet med succes';
$MESSAGE['MOD_FORM_EXCESS_SUBMISSIONS']      = 'Beklager, denne formular er blevet indsendt for mange gange i denne time. Prøv venligst igen i den næste time.';
$MESSAGE['MOD_FORM_INCORRECT_CAPTCHA']       = 'Verifikationsnummeret (også kendt som Captcha), du indtastede, er forkert. Hvis du har problemer med at læse Captcha, bedes du sende en e-mail til: <a href="mailto:{{SERVER_EMAIL}}">{{SERVER_EMAIL}}</a>';
$MESSAGE['MOD_FORM_REQUIRED_FIELDS']         = 'Du skal indtaste detaljer for følgende felter';
$MESSAGE['PAGES_ADDED']                      = 'Side tilføjet med succes';
$MESSAGE['PAGES_ADDED_HEADING']              = 'Sidetitel tilføjet med succes';
$MESSAGE['PAGES_BLANK_MENU_TITLE']           = 'Indtast venligst en menutitel';
$MESSAGE['PAGES_BLANK_PAGE_TITLE']           = 'Indtast venligst en sidetitel';
$MESSAGE['PAGES_CANNOT_CREATE_ACCESS_FILE']  = 'Fejl ved oprettelse af adgangsfil i /pages-mappen (utilstrækkelige privilegier)';
$MESSAGE['PAGES_CANNOT_DELETE_ACCESS_FILE']  = 'Fejl ved sletning af adgangsfil i /pages-mappen (utilstrækkelige privilegier)';
$MESSAGE['PAGES_CANNOT_REORDER']             = 'Fejl ved genbestilling af side';
$MESSAGE['PAGES_DELETED']                    = 'Side slettet med succes';
$MESSAGE['PAGES_DELETE_CONFIRM']             = 'Er du sikker på, at du vil slette den valgte side (og alle dens undersider)';
$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']   = 'Du har ikke tilladelse til at redigere denne side';
$MESSAGE['PAGES_INTRO_LINK']                 = 'Klik HER for at redigere introtekst';
$MESSAGE['PAGES_INTRO_NOT_WRITABLE']         = 'Kan ikke skrive til fil /pages/intro.php (utilstrækkelige privilegier)';
$MESSAGE['PAGES_INTRO_SAVED']                = 'Introtekst gemt med succes';
$MESSAGE['PAGES_LAST_MODIFIED']              = 'Sidste ændring af';
$MESSAGE['PAGES_NOT_FOUND']                  = 'Side ikke fundet';
$MESSAGE['PAGES_NOT_SAVED']                  = 'Fejl ved gemning af side';
$MESSAGE['PAGES_PAGE_EXISTS']                = 'En side med samme eller lignende titel eksisterer';
$MESSAGE['PAGES_REORDERED']                  = 'Side genbestilt med succes';
$MESSAGE['PAGES_RESTORED']                   = 'Side gendannet med succes';
$MESSAGE['PAGES_RETURN_TO_PAGES']            = 'Tilbage til sider';
$MESSAGE['PAGES_SAVED']                      = 'Side gemt med succes';
$MESSAGE['PAGES_SAVED_SETTINGS']             = 'Sideindstillinger gemt med succes';
$MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED']  = 'Sektionsegenskaber gemt med succes';
$MESSAGE['PAGE_MODIFIED']                    = 'Siden blev ændret den %s af %s';
$MESSAGE['PREFERENCES_CURRENT_PASSWORD_INCORRECT'] = 'Den (nuværende) adgangskode, du indtastede, er forkert';
$MESSAGE['PREFERENCES_DETAILS_SAVED']        = 'Detaljer gemt med succes';
$MESSAGE['PREFERENCES_EMAIL_UPDATED']        = 'E-mail opdateret med succes';
$MESSAGE['PREFERENCES_INVALID_CHARS']        = 'Ugyldige adgangskodekarakterer anvendt';
$MESSAGE['PREFERENCES_PASSWORD_CHANGED']     = 'Adgangskode ændret med succes';
$MESSAGE['RECORD_MODIFIED_FAILED']           = 'Postændring mislykkedes.';
$MESSAGE['RECORD_MODIFIED_SAVED']            = 'Den ændrede post blev opdateret med succes.';
$MESSAGE['RECORD_NEW_FAILED']                = 'Tilføjelse af en ny post mislykkedes.';
$MESSAGE['RECORD_NEW_SAVED']                 = 'Ny post blev tilføjet med succes.';
$MESSAGE['REORG_SUCCESS']                    = 'Reorganisering blev udført med succes';
$MESSAGE['SETTINGS_MODE_SWITCH_WARNING']     = 'Bemærk venligst: Ved at trykke på denne knap nulstilles alle ikke-gemte ændringer';
$MESSAGE['SETTINGS_SAVED']                   = 'Indstillinger blev gemt med succes!';
$MESSAGE['SETTINGS_UNABLE_OPEN_CONFIG']      = 'Kan ikke åbne konfigurationsfilen';
$MESSAGE['SETTINGS_UNABLE_WRITE_CONFIG']     = 'Kan ikke skrive til konfigurationsfilen';
$MESSAGE['SETTINGS_WORLD_WRITEABLE_WARNING'] = 'Bemærk venligst: dette anbefales kun til testmiljøer';
$MESSAGE['SIGNUP2_ADMIN_INFO']               = "\r\nEn ny bruger blev registreret.\r\n\r\nLogin-navn: {LOGIN_NAME}\r\n{DISPLAY_NAME}: {LOGIN_ID}\r\nE-mail: {LOGIN_EMAIL}\r\nRegistreringsdato: {SIGNUP_DATE}\r\n----------------------------------------\r\nDenne besked blev automatisk genereret!\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_FORGOT']       = "\r\nHej {LOGIN_DISPLAY_NAME},\r\n\r\nDenne mail blev sendt, fordi funktionen 'glemt adgangskode' er blevet anvendt på din konto.\r\n\r\nDine nye '{LOGIN_WEBSITE_TITLE}' login-oplysninger er:\r\n\r\nLogin-navn: xxxxx\r\nAdgangskode: {LOGIN_PASSWORD}\r\n\r\nDin adgangskode er blevet nulstillet til den ovenfor nævnte.\r\nDette betyder, at din gamle adgangskode ikke længere vil fungere!\r\nHvis du har spørgsmål eller problemer vedrørende dine nye login-data\r\nskal du kontakte webstedsteamet eller administratoren af '{LOGIN_WEBSITE_TITLE}'.\r\nHusk venligst at rydde din browsercache, før du bruger den nye, for at undgå uventede fejl.\r\n\r\nMed venlig hilsen\r\n------------------------------------\r\nDenne besked blev automatisk genereret\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_INFO']          = "\r\nHej {LOGIN_DISPLAY_NAME},\r\n\r\nVelkommen til '{LOGIN_WEBSITE_TITLE}'.\r\n\r\nDine '{LOGIN_WEBSITE_TITLE}' login-oplysninger er:\r\nLogin-navn: xxxxx\r\nAdgangskode: {LOGIN_PASSWORD}\r\n\r\nMed venlig hilsen\r\n\r\nVenligst:\r\nhvis du har modtaget denne besked ved en fejl, bedes du slette den med det samme!\r\n-------------------------------------\r\nDenne besked blev automatisk genereret!\r\n";
$MESSAGE['SIGNUP2_NEW_USER']                 = 'En ny bruger er blevet registreret';
$MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO']       = 'Dine login-oplysninger...';
$MESSAGE['SIGNUP2_SUBJECT_NEW_USER']         = 'Tak for din registrering';
$MESSAGE['SIGNUP_NO_EMAIL']                  = 'Du skal indtaste en e-mailadresse';
$MESSAGE['START_CURRENT_USER']               = 'Du er i øjeblikket logget ind som:';
$MESSAGE['START_INSTALL_DIR_EXISTS']         = 'Advarsel, installationsmappe eksisterer stadig!';
$MESSAGE['START_UPGRADE_SCRIPT_EXISTS']      = 'Slet venligst filen {{file}} fra dit webspace.';
$MESSAGE['START_WELCOME_MESSAGE']            = 'Velkommen til WebsiteBaker Administration';
$MESSAGE['TEMPLATES_CHANGE_TEMPLATE_NOTICE'] = 'Bemærk venligst: for at ændre skabelonen skal du gå til sektionen Indstillinger';
$MESSAGE['THEME_ALREADY_EXISTS']             = 'Dette nye temadeskriptor eksisterer allerede.';
$MESSAGE['THEME_COPY_CURRENT']               = 'Kopier det nuværende aktive tema og gem det med et nyt navn.';
$MESSAGE['THEME_DESTINATION_READONLY']       = 'Ingen rettigheder til at oprette ny temamappe!';
$MESSAGE['THEME_IMPORT_HTT']                 = 'Importer yderligere skabeloner til det nuværende aktive tema.<br />Brug disse skabeloner til at overskrive den tilsvarende standard skabelon.';
$MESSAGE['THEME_INVALID_SOURCE_DESTINATION'] = 'Ugyldig deskriptor for det nye tema angivet!';
$MESSAGE['UNKNOW_UPLOAD_ERROR']              = 'Ukendt upload-fejl';
$MESSAGE['UPLOAD_ERR_CANT_WRITE']            = 'Kunne ikke skrive fil til disk';
$MESSAGE['UPLOAD_ERR_EXTENSION']             = 'Filoverførsel stoppet af udvidelse';
$MESSAGE['UPLOAD_ERR_FORM_SIZE']             = 'Den uploadede fil overskrider MAX_FILE_SIZE-direktivet, der blev specificeret i HTML-formularen';
$MESSAGE['UPLOAD_ERR_INI_SIZE']              = 'Den uploadede fil overskrider upload_max_filesize-direktivet i php.ini';
$MESSAGE['UPLOAD_ERR_NO_FILE']               = 'Ingen fil blev uploadet';
$MESSAGE['UPLOAD_ERR_NO_TMP_DIR']            = 'Mangler en midlertidig mappe';
$MESSAGE['UPLOAD_ERR_OK']                    = 'Filen blev uploadet med succes';
$MESSAGE['UPLOAD_ERR_PARTIAL']               = 'Den uploadede fil blev kun delvist uploadet';
$MESSAGE['USERS_ADDED']                      = 'Bruger tilføjet med succes';
$MESSAGE['USERS_CANT_SELFDELETE']            = 'Funktion afvist, du kan ikke slette dig selv!';
$MESSAGE['USERS_CHANGING_PASSWORD']          = 'Bemærk venligst: Du skal kun indtaste værdier i de ovenstående felter, hvis du ønsker at ændre adgangskoden for denne bruger';
$MESSAGE['USERS_CONFIRM_DELETE']             = 'Er du sikker på, at du vil slette den valgte bruger?';
$MESSAGE['USERS_DELETED']                    = 'Bruger slettet med succes';
$MESSAGE['USERS_DISPLAYNAME_TAKEN']          = 'Det angivne visningsnavn er allerede i brug.';
$MESSAGE['USERS_EMAIL_TAKEN']                = 'Den e-mail, du indtastede, er allerede i brug';
$MESSAGE['USERS_INVALID_EMAIL']              = 'Den e-mailadresse, du indtastede, er ugyldig';
$MESSAGE['USERS_NAME_INVALID_CHARS']         = 'Ugyldige tegn for login-navn fundet';
$MESSAGE['USERS_NO_GROUP']                   = 'Ingen gruppe blev valgt';
$MESSAGE['USERS_PASSWORD_MISMATCH']          = 'De indtastede adgangskoder stemmer ikke overens';
$MESSAGE['USERS_PASSWORD_TOO_SHORT']         = 'Den indtastede adgangskode var for kort';
$MESSAGE['USERS_SAVED']                      = 'Bruger gemt med succes';
$MESSAGE['USERS_USERNAME_TAKEN']             = 'Det login-navn, du indtastede, er allerede i brug';
$MESSAGE['USERS_USERNAME_TOO_SHORT']         = 'Det login-navn, du indtastede, var for kort';
$OVERVIEW['ADMINTOOLS']                     = 'Få adgang til WebsiteBakers administrationsværktøjer...';
$OVERVIEW['GROUPS']                         = 'Administrer brugergrupper og deres systemtilladelser...';
$OVERVIEW['HELP']                           = 'Har du spørgsmål? Find dit svar...';
$OVERVIEW['LANGUAGES']                      = 'Administrer WebsiteBakers sprog...';
$OVERVIEW['MEDIA']                          = 'Administrer filer, der er gemt i medie-mappen...';
$OVERVIEW['MODULES']                        = 'Administrer WebsiteBakers moduler...';
$OVERVIEW['PAGES']                          = 'Administrer dine websteders sider...';
$OVERVIEW['PREFERENCES']                    = 'Skift indstillinger som e-mailadresse, adgangskode osv... ';
$OVERVIEW['SETTINGS']                       = 'Ændrer indstillinger for WebsiteBaker...';
$OVERVIEW['START']                          = 'Administrations-oversigt';
$OVERVIEW['TEMPLATES']                      = 'Skift udseendet på dit websted med skabeloner...';
$OVERVIEW['USERS']                          = 'Administrer brugere, der kan logge ind på WebsiteBaker...';
$OVERVIEW['VIEW']                           = 'Vis og gennemse hurtigt dit websted i et nyt vindue...';
$TEXT['ACCOUNT_SIGNUP']                     = 'Kontooprettelse';
$TEXT['ACTIONS']                            = 'Handlinger';
$TEXT['ACTIVE']                             = 'Aktiv';
$TEXT['ADD']                                = 'Tilføj';
$TEXT['ADDON']                              = 'Add-On';
$TEXT['ADD_SECTION']                        = 'Tilføj sektion';
$TEXT['ADMIN']                              = 'Admin';
$TEXT['ADMINISTRATION']                     = 'Administration';
$TEXT['ADMINISTRATION_TOOL']                = 'Administrationsværktøj';
$TEXT['ADMINISTRATOR']                      = 'Administrator';
$TEXT['ADMINISTRATORS']                     = 'Administratorer';
$TEXT['ADVANCED']                           = 'Avanceret';
$TEXT['ALLOWED_FILETYPES_ON_UPLOAD']        = 'Tilladte filtyper ved upload';
$TEXT['ALLOWED_VIEWERS']                    = 'Tilladte seere';
$TEXT['ALLOW_MULTIPLE_SELECTIONS']          = 'Tillad flere valg';
$TEXT['ALL_WORDS']                          = 'Alle ord';
$TEXT['ANCHOR']                             = 'Anker';
$TEXT['ANONYMOUS']                          = 'Anonym';
$TEXT['ANY_WORDS']                          = 'Alle ord';
$TEXT['APP_NAME']                           = 'Applikationsnavn';
$TEXT['ARE_YOU_SURE']                       = 'Er du sikker?';
$TEXT['AUTHOR']                             = 'Forfatter';
$TEXT['BACK']                               = 'Tilbage';
$TEXT['BACKUP']                             = 'Sikkerhedskopi';
$TEXT['BACKUP_ALL_TABLES']                  = 'Sikkerhedskopiér alle tabeller i databasen';
$TEXT['BACKUP_DATABASE']                    = 'Sikkerhedskopiér database';
$TEXT['BACKUP_MEDIA']                       = 'Sikkerhedskopiér medier';
$TEXT['BACKUP_WB_SPECIFIC']                 = 'Sikkerhedskopiér kun WB-specifikke tabeller';
$TEXT['BASIC']                              = 'Grundlæggende';
$TEXT['BLOCK']                              = 'Blok';
$TEXT['BROWSE_UPLOAD_FILE']                 = 'Vælg en fil!';
$TEXT['CALENDAR']                           = 'Kalender';
$TEXT['CANCEL']                             = 'Annuller';
$TEXT['CAN_DELETE_HIMSELF']                 = 'Kan slette sig selv';
$TEXT['CAPTCHA_VERIFICATION']               = 'Captcha-verifikation';
$TEXT['CAP_EDIT_CSS']                       = 'Rediger CSS';
$TEXT['CHANGE']                             = 'Skift';
$TEXT['CHANGES']                            = 'Ændringer';
$TEXT['CHANGE_SETTINGS']                    = 'Skift indstillinger';
$TEXT['CHARSET']                            = 'Tegnsæt';
$TEXT['CHECKBOX_GROUP']                     = 'Afkrydsningsboks-gruppe';
$TEXT['CLOSE']                              = 'Luk';
$TEXT['CODE']                               = 'Kode';
$TEXT['CODE_SNIPPET']                       = 'Kode-snippet';
$TEXT['COLLAPSE']                           = 'Skjul';
$TEXT['COMMENT']                            = 'Kommentar';
$TEXT['COMMENTING']                         = 'Kommentering';
$TEXT['COMMENTS']                           = 'Kommentarer';
$TEXT['CONFIRM']                            = 'Bekræft';
$TEXT['CREATE_FOLDER']                      = 'Opret mappe';
$TEXT['CURRENT']                            = 'Nuværende';
$TEXT['CURRENT_FOLDER']                     = 'Nuværende mappe';
$TEXT['CURRENT_PAGE']                       = 'Nuværende side';
$TEXT['CURRENT_PASSWORD']                   = 'Nuværende adgangskode';
$TEXT['CUSTOM']                             = 'Brugerdefineret';
$TEXT['DATABASE']                           = 'Database';
$TEXT['DATE']                               = 'Dato';
$TEXT['DATE_FORMAT']                        = 'Datoformat';
$TEXT['DEFAULT']                            = 'Standard';
$TEXT['DEFAULT_CHARSET']                    = 'Standard tegnsæt';
$TEXT['DEFAULT_TEXT']                       = 'Standard tekst';
$TEXT['DELETE']                             = 'Slet';
$TEXT['DELETED']                            = 'Slettet';
$TEXT['DELETE_DATE']                        = 'Slet dato';
$TEXT['DELETE_ZIP']                         = 'Slet zip-arkiv efter udpakning';
$TEXT['DESCRIPTION']                        = 'Beskrivelse';
$TEXT['DESIGNED_FOR']                       = 'Designet til';
$TEXT['DEV_INFOS']                          = 'Udviklerinformationer';
$TEXT['DIRECTORIES']                        = 'Mapper';
$TEXT['DIRECTORY_MODE']                     = 'Mappe-tilstand';
$TEXT['DISABLED']                           = 'Deaktiveret';
$TEXT['DISPLAY_NAME']                       = 'Visningsnavn';
$TEXT['EMAIL']                              = 'E-mail';
$TEXT['EMAIL_ADDRESS']                      = 'E-mailadresse';
$TEXT['EMPTY_TRASH']                        = 'Tøm papirkurv';
$TEXT['ENABLED']                            = 'Aktiveret';
$TEXT['END']                                = 'Slut';
$TEXT['ERROR']                              = 'Fejl';
$TEXT['EXACT_MATCH']                        = 'Nøjagtigt match';
$TEXT['EXECUTE']                            = 'Udfør';
$TEXT['EXPAND']                             = 'Udvid';
$TEXT['EXTENSION']                          = 'Filendelse';
$TEXT['FIELD']                              = 'Felt';
$TEXT['FILE']                               = 'Fil';
$TEXT['FILES']                              = 'Filer';
$TEXT['FILESYSTEM_PERMISSIONS']             = 'Filysystemtilladelser';
$TEXT['FILE_MODE']                          = 'Fil-tilstand';
$TEXT['FINISH_PUBLISHING']                  = 'Afslut udgivelse';
$TEXT['FOLDER']                             = 'Mappe';
$TEXT['FOLDERS']                            = 'Mapper';
$TEXT['FOOTER']                             = 'Sidefod';
$TEXT['FORGOTTEN_DETAILS']                  = 'Glemt dine oplysninger?';
$TEXT['FORGOT_DETAILS']                     = 'Glemt oplysninger?';
$TEXT['FROM']                               = 'Fra';
$TEXT['FRONTEND']                           = 'Frontend';
$TEXT['FULL_NAME']                          = 'Fulde navn';
$TEXT['FUNCTION']                           = 'Funktion';
$TEXT['GROUP']                              = 'Gruppe';
$TEXT['GUEST']                              = 'Gæst';
$TEXT['HEADER']                             = 'Sidehoved';
$TEXT['HEADING']                            = 'Overskrift';
$TEXT['HEADING_CSS_FILE']                   = 'Aktuel modulfild: ';
$TEXT['HEIGHT']                             = 'Højde';
$TEXT['HIDDEN']                             = 'Skjult';
$TEXT['HIDE']                               = 'Skjul';
$TEXT['HIDE_ADVANCED']                      = 'Skjul avancerede indstillinger';
$TEXT['HOME']                               = 'Hjem';
$TEXT['HOMEPAGE_REDIRECTION']               = 'Startsideomdirigering';
$TEXT['HOME_FOLDER']                        = 'Personlig mappe';
$TEXT['HOME_FOLDERS']                       = 'Personlige mapper';
$TEXT['HOST']                               = 'Vært';
$TEXT['ICON']                               = 'Ikon';
$TEXT['IMAGE']                              = 'Billede';
$TEXT['INLINE']                             = 'Inline';
$TEXT['INSTALL']                            = 'Installer';
$TEXT['INSTALLATION']                       = 'Installation';
$TEXT['INSTALLATION_PATH']                  = 'Installationssti';
$TEXT['INSTALLATION_URL']                   = 'Installations-URL';
$TEXT['INSTALLED']                          = 'installeret';
$TEXT['INTRO']                              = 'Intro';
$TEXT['INTRO_PAGE']                         = 'Introtekst';
$TEXT['INVALID_SIGNS']                      = 'skal starte med et bogstav eller indeholder ugyldige tegn';
$TEXT['KEYWORDS']                           = 'Nøgleord';
$TEXT['LANGUAGE']                           = 'Sprog';
$TEXT['LAST_UPDATED_BY']                    = 'Sidst opdateret af';
$TEXT['LENGTH']                             = 'Længde';
$TEXT['LEVEL']                              = 'Niveau';
$TEXT['LICENSE']                            = 'Licens';
$TEXT['LINK']                               = 'Link';
$TEXT['LINUX_UNIX_BASED']                   = 'Linux/Unix baseret';
$TEXT['LIST_OPTIONS']                       = 'Listeindstillinger';
$TEXT['LOGGED_IN']                          = 'Logget ind';
$TEXT['LOGIN']                              = 'Login';
$TEXT['LONG']                               = 'Lang';
$TEXT['LONG_TEXT']                          = 'Lang tekst';
$TEXT['LOOP']                               = 'Løkke';
$TEXT['MAIN']                               = 'Hoved';
$TEXT['USER_LOGIN_ON']                      = 'Tillad bruger login';
$TEXT['USER_LOGIN_OFF']                     = 'Forhindr bruger login';
$TEXT['MAINTENANCE_OFF']                    = 'Vedligeholdelse slået fra';
$TEXT['MAINTENANCE_ON']                     = 'Vedligeholdelse slået til';
$TEXT['MANAGE']                             = 'Administrer';
$TEXT['MANAGE_GROUPS']                      = 'Administrer grupper';
$TEXT['MANAGE_USERS']                       = 'Administrer brugere';
$TEXT['MATCH']                              = 'Match';
$TEXT['MATCHING']                           = 'Matchende';
$TEXT['MAX_EXCERPT']                        = 'Max. linjer i uddrag';
$TEXT['MAX_SUBMISSIONS_PER_HOUR']           = 'Max. indsendelser pr. time';
$TEXT['MEDIA_DIRECTORY']                    = 'Mediemappe';
$TEXT['MENU']                               = 'Menu';
$TEXT['MENU_ICON_0']                        = 'Menu-ikon normal';
$TEXT['MENU_ICON_1']                        = 'Menu-ikon ved hover';
$TEXT['MENU_TITLE']                         = 'Menutitel';
$TEXT['MESSAGE']                            = 'Besked';
$TEXT['MODIFY']                             = 'Rediger';
$TEXT['MODIFY_CONTENT']                     = 'Rediger indhold';
$TEXT['MODIFY_SETTINGS']                    = 'Rediger indstillinger';
$TEXT['MODULE_ORDER']                       = 'Modul-rækkefølge for søgning';
$TEXT['MODULE_PERMISSIONS']                 = 'Modultilladelser';
$TEXT['MORE']                               = 'Mere';
$TEXT['MOVE_DOWN']                          = 'Flyt ned';
$TEXT['MOVE_UP']                            = 'Flyt op';
$TEXT['MULTILINGUAL']                       = 'FLERSPROGET';
$TEXT['MULTIPLE_MENUS']                     = 'Flere menuer';
$TEXT['MULTISELECT']                        = 'Multivælg';
$TEXT['NAME']                               = 'Navn';
$TEXT['NEED_CURRENT_PASSWORD']              = 'bekræft med nuværende adgangskode';
$TEXT['NEED_TO_LOGIN']                      = 'Skal logge ind?';
$TEXT['NEW_PASSWORD']                       = 'Ny adgangskode';
$TEXT['NEW_WINDOW']                         = 'Nyt vindue';
$TEXT['NEXT']                               = 'Næste';
$TEXT['NEXT_PAGE']                          = 'Næste side';
$TEXT['NO']                                 = 'Nej';
$TEXT['NONE']                               = 'Ingen';
$TEXT['NONE_FOUND']                         = 'Ingen fundet';
$TEXT['NOT_FOUND']                          = 'Ikke fundet';
$TEXT['NOT_INSTALLED']                      = 'ikke installeret';
$TEXT['NO_IMAGE_SELECTED']                  = 'intet billede valgt';
$TEXT['NO_RESULTS']                         = 'Ingen resultater';
$TEXT['NO_SELECTION']                       = 'intet valg';
$TEXT['OF']                                 = 'af';
$TEXT['ON']                                 = 'til';
$TEXT['OPEN']                               = 'Åbn';
$TEXT['OPTION']                             = 'Valgmulighed';
$TEXT['OTHERS']                             = 'Andre';
$TEXT['OUT_OF']                             = 'Ud af';
$TEXT['OVERWRITE_EXISTING']                 = 'Overskriv eksisterende';
$TEXT['PAGE']                               = 'Side';
$TEXT['PAGES_DIRECTORY']                    = 'Sidemappe';
$TEXT['PAGES_PERMISSION']                   = 'Sidetilladelse';
$TEXT['PAGES_PERMISSIONS']                  = 'Sidetilladelser';
$TEXT['PAGE_EXTENSION']                     = 'Sideudvidelse';
$TEXT['PAGE_ICON']                          = 'Sidebillede';
$TEXT['PAGE_ICON_DIR']                      = 'Sti sider/menubilleder';
$TEXT['PAGE_LANGUAGES']                     = 'Sidesprog';
$TEXT['PAGE_LEVEL_LIMIT']                   = 'Sideniveaugrænse';
$TEXT['PAGE_SPACER']                        = 'Sidemellemrum';
$TEXT['PAGE_TITLE']                         = 'Sidetitel';
$TEXT['PAGE_TRASH']                         = 'Sidepapirkurv';
$TEXT['PARENT']                             = 'Forælder';
$TEXT['PASSWORD']                           = 'Adgangskode';
$TEXT['PATH']                               = 'Sti';
$TEXT['PHP_ERROR_LEVEL']                    = 'PHP fejlrapporteringsniveau';
$TEXT['PLEASE_LOGIN']                       = 'Log venligst ind';
$TEXT['PLEASE_SELECT']                      = 'Vælg venligst';
$TEXT['POST']                               = 'Indlæg';
$TEXT['POSTS_PER_PAGE']                     = 'Indlæg pr. side';
$TEXT['POST_FOOTER']                        = 'Indlægsfod';
$TEXT['POST_HEADER']                        = 'Indlægsoverskrift';
$TEXT['PREVIOUS']                           = 'Forrige';
$TEXT['PREVIOUS_PAGE']                      = 'Forrige side';
$TEXT['PRIVATE']                            = 'Privat';
$TEXT['PRIVATE_VIEWERS']                    = 'Private seere';
$TEXT['PROFILES_EDIT']                      = 'Skift profil';
$TEXT['PUBLIC']                             = 'Offentlig';
$TEXT['PUBL_END_DATE']                      = 'Slutdato';
$TEXT['PUBL_START_DATE']                    = 'Startdato';
$TEXT['RADIO_BUTTON_GROUP']                 = 'Radioknapgruppe';
$TEXT['READ']                               = 'Læs';
$TEXT['READ_MORE']                          = 'Læs mere';
$TEXT['REDIRECT_AFTER']                     = 'Omdiriger efter';
$TEXT['REGISTERED']                         = 'Registreret';
$TEXT['REGISTERED_VIEWERS']                 = 'Registrerede seere';
$TEXT['RELOAD']                             = 'Genindlæs';
$TEXT['REMEMBER_ME']                        = 'Husk mig';
$TEXT['RENAME']                             = 'Omdøb';
$TEXT['RENAME_FILES_ON_UPLOAD']             = 'Ingen upload for disse filtyper';
$TEXT['REQUIRED']                           = 'Påkrævet';
$TEXT['REQUIREMENT']                        = 'Krav';
$TEXT['RESET']                              = 'Nulstil';
$TEXT['RESIZE']                             = 'Tilpas størrelse';
$TEXT['RESIZE_IMAGE_TO']                    = 'Tilpas billedstørrelse til';
$TEXT['REFILL']                             = 'Nulstil input';
$TEXT['RESTORE']                            = 'Nulstil input';
$TEXT['RESTORE_DATABASE']                   = 'Gendan database';
$TEXT['RESTORE_MEDIA']                      = 'Gendan medier';
$TEXT['RESULTS']                            = 'Resultater';
$TEXT['RESULTS_FOOTER']                     = 'Resultatfod';
$TEXT['RESULTS_FOR']                        = 'Resultater for';
$TEXT['RESULTS_HEADER']                     = 'Resultatoverskrift';
$TEXT['RESULTS_LOOP']                       = 'Resultatløkke';
$TEXT['RETYPE_NEW_PASSWORD']                = 'Gentag ny adgangskode';
$TEXT['RETYPE_PASSWORD']                    = 'Gentag adgangskode';
$TEXT['SAME_WINDOW']                        = 'Samme vindue';
$TEXT['SAVE']                               = 'Gem';
$TEXT['SEARCH']                             = 'Søg';
$TEXT['SEARCHING']                          = 'Søger';
$TEXT['SECTION']                            = 'Sektion';
$TEXT['SECTION_BLOCKS']                     = 'Sektionsblokke';
$TEXT['SEC_ANCHOR']                         = 'Sektions-ankertekst';
$TEXT['SELECT_BOX']                         = 'Vælg boks';
$TEXT['SEND_DETAILS']                       = 'Send detaljer';
$TEXT['SEPARATE']                           = 'Separat';
$TEXT['SEPERATOR']                          = 'Separator';
$TEXT['SERVER_EMAIL']                       = 'Server-e-mail';
$TEXT['SERVER_OPERATING_SYSTEM']            = 'Serveroperativsystem';
$TEXT['SESSION_IDENTIFIER']                 = 'Sessionsidentifikator';
$TEXT['SETTINGS']                           = 'Indstillinger';
$TEXT['SHORT']                              = 'Kort';
$TEXT['SHORT_TEXT']                         = 'Kort tekst';
$TEXT['SHOW']                               = 'Vis';
$TEXT['SHOW_ADVANCED']                      = 'Vis avancerede indstillinger';
$TEXT['SIGNUP']                             = 'Tilmeld';
$TEXT['SIZE']                               = 'Størrelse';
$TEXT['SMART_LOGIN']                        = 'Smart login';
$TEXT['START']                              = 'Start';
$TEXT['START_PUBLISHING']                   = 'Start publicering';
$TEXT['SUBJECT']                            = 'Emne';
$TEXT['SUBMISSIONS']                        = 'Indsendelser';
$TEXT['SUBMISSIONS_STORED_IN_DATABASE']     = 'Indsendelser gemt i database';
$TEXT['SUBMISSION_ID']                      = 'Indsendelses-ID';
$TEXT['SUBMITTED']                          = 'Indsendt';
$TEXT['SUCCESS']                            = 'Succes';
$TEXT['SYSTEM_DEFAULT']                     = 'Systemstandard';
$TEXT['SYSTEM_PERMISSIONS']                 = 'Systemtilladelser';
$TEXT['TABLE_PREFIX']                       = 'Tabelpræfiks';
$TEXT['TARGET']                             = 'Mål';
$TEXT['TARGET_FOLDER']                      = 'Målmappe';
$TEXT['TEMPLATE']                           = 'Skabelon';
$TEXT['TEMPLATE_PERMISSIONS']               = 'Skabelontilladelser';
$TEXT['TEXT']                               = 'Tekst';
$TEXT['TEXTAREA']                           = 'Tekstområde';
$TEXT['TEXTFIELD']                          = 'Tekstfelt';
$TEXT['THEME']                              = 'Backend-tema';
$TEXT['THEME_COPY_CURRENT']                 = 'Kopiér backend-tema.';
$TEXT['THEME_CURRENT']                      = 'aktuelt aktivt tema';
$TEXT['THEME_IMPORT_HTT']                   = 'Importer yderligere skabeloner';
$TEXT['THEME_NEW_NAME']                     = 'Navn på det nye tema';
$TEXT['THEME_NOMORE_HTT']                   = 'ikke mere tilgængelig';
$TEXT['THEME_SELECT_HTT']                   = 'vælg skabeloner';
$TEXT['THEME_START_COPY']                   = 'kopiér';
$TEXT['THEME_START_IMPORT']                 = 'importér';
$TEXT['TIME']                               = 'Tid';
$TEXT['TIMEZONE']                           = 'Tidszone';
$TEXT['TIME_FORMAT']                        = 'Tidsformat';
$TEXT['TIME_LIMIT']                         = 'Max. tid til at indsamle uddrag pr. modul';
$TEXT['TITLE']                              = 'Titel';
$TEXT['TO']                                 = 'Til';
$TEXT['TOP_FRAME']                          = 'Topramme';
$TEXT['TRASH_EMPTIED']                      = 'Papirkurv tømt';
$TEXT['TXT_EDIT_CSS_FILE']                  = 'Rediger CSS-definitionerne i tekstfeltet nedenfor.';
$TEXT['TYPE']                               = 'Type';
$TEXT['UNDER_CONSTRUCTION']                 = 'Under konstruktion';
$TEXT['UNINSTALL']                          = 'Afinstaller';
$TEXT['UNKNOWN']                            = 'Ukendt';
$TEXT['UNLIMITED']                          = 'Ubegrænset';
$TEXT['UNZIP_FILE']                         = 'Upload og udpak et zip-arkiv';
$TEXT['UP']                                 = 'Op';
$TEXT['UPGRADE']                            = 'Opgrader';
$TEXT['UPLOAD_FILES']                       = 'Upload fil(er)';
$TEXT['URL']                                = 'URL';
$TEXT['USER']                               = 'Bruger';
$TEXT['USERNAME']                           = 'Login-navn';
$TEXT['USERS_ACTIVE']                       = 'Bruger er aktiv';
$TEXT['USERS_CAN_SELFDELETE']               = 'Bruger kan slette sig selv';
$TEXT['USERS_CHANGE_SETTINGS']              = 'Bruger kan ændre egne indstillinger';
$TEXT['USERS_DELETED']                      = 'Bruger er markeret som slettet';
$TEXT['USERS_FLAGS']                        = 'Bruger-flags';
$TEXT['USERS_PROFILE_ALLOWED']              = 'Bruger kan oprette udvidet profil';
$TEXT['VERIFICATION']                       = 'Verifikation';
$TEXT['VERSION']                            = 'Version';
$TEXT['VIEW']                               = 'Vis';
$TEXT['VIEW_DELETED_PAGES']                 = 'Vis slettede sider';
$TEXT['VIEW_DETAILS']                       = 'Vis detaljer';
$TEXT['VISIBILITY']                         = 'Synlighed';
$TEXT['WBMAILER_DEFAULT_SENDER_MAIL']       = 'Standard "Fra" adresse';
$TEXT['WBMAILER_DEFAULT_SENDER_NAME']       = 'Standard afsender navn';
$TEXT['WBMAILER_DEFAULT_SETTINGS_NOTICE']   = 'Angiv venligst en standard "FRA" adresse og "AFSENDERN" navn nedenfor. Det anbefales at bruge en FRA-adresse som: <strong>admin@ditdomæne.com</strong>. Nogle mailudbydere (f.eks. <em>mail.com</em>) kan afvise mail med en FRA-adresse som <em>navn@mail.com</em> sendt via et udenlandsk relæ for at undgå spam.<br /><br />Standardværdierne bruges kun, hvis ingen andre værdier er angivet af WebsiteBaker. Hvis din server understøtter <abbr title="Simple mail transfer protocol">SMTP</abbr>, ønsker du måske at bruge denne mulighed for udgående mail.';
$TEXT['WBMAILER_FUNCTION']                  = 'Mail-rutine';
$TEXT['WBMAILER_NOTICE']                    = '<strong>SMTP Mailer-indstillinger:</strong><br />Indstillingerne nedenfor er kun påkrævet, hvis du vil sende mail via <abbr title="Simple mail transfer protocol">SMTP</abbr>. Hvis du ikke kender din SMTP-vært, eller du er usikker på de påkrævede indstillinger, skal du blot blive ved standard mail-rutinen: PHP MAIL.';
$TEXT['WBMAILER_PHP']                       = 'PHP MAIL';
$TEXT['WBMAILER_SMTP']                      = 'SMTP';
$TEXT['WBMAILER_SMTP_AUTH']                 = 'SMTP-godkendelse';
$TEXT['WBMAILER_SMTP_AUTH_NOTICE']          = 'aktiver kun, hvis din SMTP-vært kræver godkendelse';
$TEXT['WBMAILER_SMTP_HOST']                 = 'SMTP-vært';
$TEXT['WBMAILER_SMTP_PASSWORD']             = 'SMTP-adgangskode';
$TEXT['WBMAILER_SMTP_USERNAME']             = 'SMTP-brugernavn';
$TEXT['WEBSITE']                            = 'Websted';
$TEXT['WEBSITE_DESCRIPTION']                = 'Metadata beskrivelse';
$TEXT['WEBSITE_FOOTER']                     = 'Webstedets sidefod';
$TEXT['WEBSITE_HEADER']                     = 'Webstedets sidehoved';
$TEXT['WEBSITE_KEYWORDS']                   = 'Metadata nøgleord';
$TEXT['WEBSITE_TITLE']                      = 'Metadata titel';
$TEXT['WELCOME_BACK']                       = 'Velkommen tilbage';
$TEXT['WIDTH']                              = 'Bredde';
$TEXT['WINDOW']                             = 'Vindue';
$TEXT['WINDOWS']                            = 'Windows';
$TEXT['WORLD_WRITEABLE_FILE_PERMISSIONS']   = 'Verdensskrivbare filtilladelser';
$TEXT['WRITE']                              = 'Skriv';
$TEXT['WYSIWYG_EDITOR']                     = 'WYSIWYG-editor';
$TEXT['WYSIWYG_STYLE']                      = 'WYSIWYG-stil';
$TEXT['YES']                                = 'Ja';

$TEXT['NO_REVERT'] = 'Dette kan du ikke fortryde!';
$TEXT['NO_DELETED'] = 'Sletning blev ikke udført!';
$TEXT['PAGE_CODE'] = 'Sidekode';