<?php
/**
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @category        core
 * @package         test
 * @subpackage      test
 * @author          Dietmar Wöllbrink
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.3
 * @requirements    PHP 5.4 and higher
 * @version         $Id: setHiddenFrontendFile.php 4 2025-08-08 07:53:04Z Uwe $
 * @filesource      $HeadURL: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/framework/helpers/setHiddenFrontendFile.php $
 * @lastmodified    $Date: 2025-08-08 09:53:04 +0200 (Fr, 08 Aug 2025) $
 *
 */

declare(strict_types=1);

use bin\{WbAdaptor,SecureTokens,Sanitize,Requester};
use bin\helpers\{PreCheck};
use App\Utils\Helpers;

// BEGIN this part helps to prevent direct access
    $sAddonPath   = rtrim(str_replace('\\','/',(__DIR__)),'/').'/';
    $sModulesPath = \dirname($sAddonPath).'/'; //
    $sModuleName  = basename($sModulesPath);
    $sAddonName   = basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = preg_replace ($sPattern, "$1", $sModulesPath, 1 );
//  trigger_error(\sprintf('%s', $sAppPath),E_USER_NOTICE);
    if (! defined('SYSTEM_RUN') && is_readable($sAppPath.'config.php')) {
        require($sAppPath.'config.php');
    }
// END this part helps to prevent direct access

    // initialize json_respond array  (will be sent back)
    $aJsonRespond = [];
    $aJsonRespond['content'] = '';
    $aJsonRespond['message'] = 'Creating Frontend hidden file operation failed';
    $aJsonRespond['success'] = false;
    try {
    // check autentification
        $admin  = new admin('admintools', 'admintools_advanced',false);
        $oReg   = WbAdaptor::getInstance();
        $oDb    = $oReg->getDatabase();
        $oTrans = $oReg->getTranslate();
        $sAddonHiddenFile = $oReg->AppPath.'account/.setFrontend.inc';

        if (!$admin->is_authenticated() || !$admin->ami_group_member('1')) {
            $sMessage .= \sprintf('%s', json_encode($aJsonRespond['message']));
            throw new FrontendException($sMessage);
        }

        if (!$admin->is_authenticated()  || !$admin->ami_group_member('1')) {
            $sMessage .= \sprintf('%s', json_encode($aJsonRespond));
            throw new FrontendException($sMessage);
        }

        if (\is_readable($sAddonHiddenFile)){
            $aJsonRespond['message'] = sprintf('Frontend hidden file was successfully readable');
// If the script is still running, set success to true
            $aJsonRespond['success'] = true;
        } elseif (false !==($iFile = Helpers::setFrontendHiddenFile($oReg->AppPath.'account'))){
        $aJsonRespond['message'] = sprintf('%d bytes Frontend hidden file was successfully added',$iFile);
// If the script is still running, set success to true
        $aJsonRespond['success'] = true;
        }

    } catch (FrontendException $ex) {
        $sMessage .= \sprintf("<b>create Frontend hidden file failed::</b>%s",$ex->getMessage());
        $aJsonRespond['success'] = false;
    }
    //\trigger_error(\sprintf('%s',json_encode($aJsonRespond)),E_USER_NOTICE);
// and echo the json_respond to the ajax function

    exit(json_encode($aJsonRespond));

    class FrontendException extends \AppException {}
