<?php
/**
 *
 * @category        admin
 * @package         media
 * @author          WebsiteBaker Project
 * @copyright       Ryan Djurovich
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.10.1
 * @requirements    PHP 5.3.6 and higher
 * @version         $Id: setparameter.php 4 2025-08-08 07:53:04Z Uwe $
 * @filesource      $HeadURL: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/admin/media/setparameter.php $
 * @lastmodified    $Date: 2025-08-08 09:53:04 +0200 (Fr, 08 Aug 2025) $
 *
 */

use bin\{WbAdaptor,SecureTokens,Sanitize};
use vendor\phplib\Template;

    ini_set('upload_max_filesize', '400M');
    ini_set('post_max_size', '440M');
    ini_set('memory_limit', '512M');
//    ini_set('zlib.output_compression',1);
//    ini_set('zlib.output_compression_level',9);

if (!defined( 'SYSTEM_RUN' )){ require( dirname(__DIR__,2).'/config.php' ); }

    $admin = new \admin('Media', 'media', false);

    $oReg = WbAdaptor::getInstance();
    $oDb      = $oReg->getDatabase();
    $oTrans   = $oReg->getTranslate();
    $oRequest = $oReg->getRequester();
    $oApp     = $oReg->getApplication();
    $isAuth   = $oApp->is_authenticated();

    $sCallingScript = $oRequest->getServerVar('SCRIPT_NAME');
    $globalStarted = \preg_match('/upgrade\-script\.php$/', $sCallingScript);
    if ($globalStarted) {
        return;
    }

// check if theme language file exists for the language set by the user (e.g. DE, EN)
    $sDomain = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);

    $iMaxInputVars = \ini_get('max_input_vars');

    $aInputs = $oApp->getRequestVars();
    $sOldPath = str_replace('\\','/',\getcwd()).'/';

    $ErrMsg  = '';
    $aDirs  = directory_list($oReg->AppPath.$oReg->MediaDir);
    \array_unshift($aDirs, $oReg->AppPath.$oReg->MediaDir);
    $aDirs = \array_unique ($aDirs);

//Save post vars to the parameters file
    if (isset($aInputs['save']) || isset($aInputs['clear']))
    {
        if (!$admin->checkFTAN())
        {
            $admin->print_error(''.$oTrans->MESSAGE_GENERIC_SECURITY_ACCESS,'browse.php',false);
        }

        $pathsettings = [];
        if (DEFAULT_THEME !== 'DefaulTheme') {
            $cfg =[
                'media_width'         => (defined('MEDIA_WIDTH') ? MEDIA_WIDTH : '0'),
                'media_height'        => (defined('MEDIA_HEIGHT') ? MEDIA_HEIGHT : '0'),
                'media_compress'      => (defined('MEDIA_COMPRESS') ? MEDIA_COMPRESS : '85'),
                'mediasettings'       => (defined('MEDIASETTINGS') ? MEDIASETTINGS : ''),
            ];
            foreach($cfg as $key=>$value) {
                db_update_key_value('settings', $key, $value);
            }
        }

        foreach($aDirs as $item) {
            $name = \str_replace('\\','/',$item);
            $sTmp = \str_replace($oReg->AppPath, '', $name);
            $r    = trim(\str_replace(['/',' ','.'],'_',$sTmp),'_');
            $w = $h = 0;
            if (isset($aInputs['save'])){
                $w    = (int)$oRequest->getParam($r.'-w');
                $h    = (int)$oRequest->getParam($r.'-h');
            }
            if (isset($aInputs['save']) && ($w !=0) || ($h !=0)){
              $pathsettings[$r]['width'] =$w;
              $pathsettings[$r]['height']=$h;
            }
        }  // end foreach
        if (($admin->ami_group_member('1'))){
            $pathsettings['global']['admin_only']  = ($admin->get_post('admin_only') ?? 0);
        }
        else
        {
            $pathsettings['global']['admin_only']  = ($admin->get_post('admin_only') ?? 1);
        }

        $pathsettings['global']['show_thumbs'] = ($admin->get_post('show_thumbs') ?? 0);
        $pathsettings['global']['resize_up']   = ($admin->get_post('resize_up') ?? 0);
        $fieldSerialized = \serialize($pathsettings);

        $sSqlSet  = 'UPDATE `'.$database->TablePrefix.'settings` SET '
                  . '`value` = \''.($fieldSerialized). '\' '
                  . 'WHERE `name`=\'mediasettings\'';
        if ($database->query ($sSqlSet)){
            \header ("Location: browse.php");
            exit();
        } else {
          \trigger_error(sprintf('[%03d] %s',__LINE__,$database->get_error()));
        }
    } // save end

    $iInputs = \sizeof($aDirs)*2;
    if (!\function_exists('__unserialize')){require(__DIR__.'/parameters.php');}
    $width          = $database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_width\' ');
    $height         = $database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_height\' ');
    $jpegQuality    = $database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_compress\' ');

    $aOptions = ['options' => ['filter' => FILTER_VALIDATE_BOOL, 'flags' => FILTER_NULL_ON_FAILURE]];
    $resizeUp = $oReg->Request->getParam('resize_up', $aOptions);

    $aUploadOptions = [
        'resizeUp'              => ($resizeUp ?? false),
        'jpegQuality'           => $jpegQuality,
        'correctPermissions'    => true,
        'preserveAlpha'         => true,
        'alphaMaskColor'        => [255, 255, 255],
        'preserveTransparency'  => true,
        'transparencyMaskColor' => [0, 0, 0]
    ];
    $sMediaSettings = $database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'mediasettings\' ');
    $pathsettings = __unserialize($sMediaSettings);
    $admin_only   = (bool)($pathsettings['global']['admin_only'] ?? ($oApp->ami_group_member('1')));
    if ((($oApp->get_permission('media_settings') === true) && ($admin_only===true)) || ($oApp->ami_group_member('1') === true)){
/*
print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
print_r( [(int)$admin_only,(int)$oApp->ami_group_member('1')] ); print '</pre>'; \flush (); //  sleep(10); die();
*/
    }
    else
    {
       //echo "Sorry, settings not available";
        $admin->print_error('[147] '.$oTrans->MESSAGE_SETTINGS_UNABLE_OPEN_CONFIG,'browse.php',false);
       // exit();
    }
// Read data to display
    $caller = "setparameter";

// Setup template object, parse vars to it, then parse it
// Create new template object
    $template = new Template(\dirname($admin->correct_theme_source('setparameter.htt')));
    $template->set_file('page', 'setparameter.htt');
    $template->set_block('page', 'main_block', 'main');
    $template->set_block('main_block', 'table_tfoot_block', 'table_tfoot');
    $template->set_block('main_block', 'table_message_block', 'table_message');
    $template->set_block('main_block', 'table_save_block', 'table_save');

    if ($iInputs > $iMaxInputVars){
        $ErrMsg = \sprintf('PHP configuration "max_input_vars" (see php.ini) must be increased from %d to %d (or greater). Saving the optionen would fail and was disabled',$iMaxInputVars, $iInputs);
//      \trigger_error($ErrMsg, E_USER_WARNING);
        $template->parse('table_message', 'table_message_block', true);
        $template->set_block('table_save_block', '');
        $template->set_block('table_tfoot_block', '');
    } else {
        $template->set_block('table_message_block', '');
        $template->parse('table_save', 'table_save_block', true);
        $template->parse('table_tfoot', 'table_tfoot_block', true);
    }

    $admin_only  = (bool)($pathsettings['global']['admin_only'] ?? ($oApp->ami_group_member('1')));

    if ((($oApp->get_permission('media_settings') === true) && ($admin_only===true))  || ($oApp->ami_group_member('1') === true)){
        $show_thumbs = ($pathsettings['global']['show_thumbs'] ?? 0);
        $resize_up   = ($pathsettings['global']['resize_up'] ?? 0);
    }
    else
    {
        //$template->set_var('DISPLAY_ADMIN', 'hide');
        $show_thumbs = (0);
        $admin_only  = ($oApp->ami_group_member('1') === true);
        $resize_up   = (0);
    }

    $aAdminFlags = [
          'TEXT_HEADER' => $oTrans->TEXT_TEXT_HEADER,
          'MESSAGE' => $ErrMsg,
          'SAVE_TEXT' => $oTrans->TEXT_SAVE,
          'CLEAR_TEXT' => $oTrans->TEXT_CLEAR,
          'BACK' => $oTrans->TEXT_BACK,
          'FTAN' => $admin->getFTAN(),
          'NO_SHOW_THUMBS' => $oTrans->TEXT_NO_SHOW_THUMBS,
          'NO_SHOW_THUMBS_CHECKED' => ($show_thumbs ? 'checked' :''),
          'ADMIN_ONLY' => $oTrans->TEXT_ADMIN_ONLY,
          'ADMIN_ONLY_CHECKED' => ($admin_only ? 'checked' :''),
          'RESIZE_UP' => $oTrans->TEXT_RESIZE_UP,
          'RESIZE_UP_CHECKED' => ($resize_up ? 'checked' :'' ),
    ];

    $template->set_var($aAdminFlags);

    $row_bg_color = '';
    $id=0;
    $template->set_block('main_block', 'list_block', 'list');
    foreach($aDirs as $item) {
        $name = \str_replace('\\','/',$item);
        $relative = trim(\str_replace($oReg->AppPath, '', $name),'/');
        //$relative = ltrim(str_replace('\\','/',str_replace($oReg->AppPath, '', $name)),'/');
//        $relative = str_replace(MEDIA_DIRECTORY,'',$relative);
        $safepath = trim(str_replace(['/',' ','.'],'_',$relative),'_');

        $cur_width = $cur_height = 0;
        if (isset($pathsettings[$safepath]['width'])){ $cur_width = $pathsettings[$safepath]['width'];}
        if (isset($pathsettings[$safepath]['height'])){ $cur_height = $pathsettings[$safepath]['height'];}
        $cur_width = ($cur_width ? (int)$cur_width : '-');
        $cur_height = ($cur_height ? (int)$cur_height : '-');
        $id++;
        $sRealPath  = str_replace($oReg->AppPath,'',$relative);
        $sPathName  = ((\mb_strlen($sRealPath) > 40) ? \mb_substr($sRealPath, 0, 39).'…' : $sRealPath);
        $sPathName  = \preg_replace('/^(.{5,40})\s(.*)$/su', '\1…', \str_replace('"', '', $sPathName));

        $row_bg_color = (($row_bg_color == 'DEDEDE') ? 'EEEEEE' : 'DEDEDE');
        $aDimension = [
                        'ADMIN_URL' => ADMIN_URL,
                        'PATH_NAME' => $sRealPath,
                        'TRIM_PATH_NAME' => $sPathName,
                        'WIDTH' => $TEXT['WIDTH'],
                        'HEIGHT' => $TEXT['HEIGHT'],
                        'FIELD_NAME_W' => $safepath.'-w',
                        'FIELD_NAME_H' => $safepath.'-h',
                        'CUR_WIDTH' => $cur_width,
                        'CUR_HEIGHT' => $cur_height,
                        'SETTINGS' => $TEXT['SETTINGS'],
                        'ROW_BG_COLOR' => $row_bg_color,
                        'THEME_URL' => THEME_URL,
                        'FILE_ID' => $id,
        ];
        $template->set_var($aDimension);
        $template->parse('list', 'list_block', true);
    }

    $template->parse('main', 'main_block', false);
    $template->pparse('output', 'page');


//$sFullPathl = \rtrim(\str_replace('\\', '/', $sFullPath), '/').'/';
//$sRelPath = \rtrim(\preg_replace('!^.*/'.oReg->MediaDir.'(.*?)[^/]*$!', '$1', $sFullPath), '/');
