<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of admin/addons/reload.php
 *
 * @package      Core
 * @copyright    Manuela v.d.Decken <manuela@isteam.de>
 * @author       Manuela v.d.Decken <manuela@isteam.de>
 * @license      GNU General Public License 2.0
 * @version      2.0.1
 * @revision     $Id: reload.php 4 2025-08-08 07:53:04Z Uwe $
 * @since        File available since 04.10.2017
 * @deprecated   no
 * @description  xxx
 */
declare(strict_types = 1);
//declare(encoding = 'UTF-8');

//namespace ;

use bin\{WbAdaptor,SecureTokens};
use bin\helpers\{PreCheck,csvHelper,StopWatch};

/**
 * check if user has permissions to access this file
 */
// include WB configuration file and WB admin class
    if (!\defined( 'SYSTEM_RUN')){require( \dirname(__DIR__,2)).'/config.php';}

    try {

// check user permissions for admintools (redirect users with wrong permissions)
        $admin = new admin('Admintools', 'admintools', false, false);
        if ($admin->get_permission('admintools') === false){ die(\header('Location: ../../index.php'));}
        $aRequestVars  = [];
// get POST or GET requests, never both at once
        $aVars = $oReg->Request->getParamNames();
        foreach ($aVars as $sName) {
            $aRequestVars[$sName] = $oReg->Request->getParam($sName);
        }
        $sBacklinkUrl = $oReg->AcpUrl.'addons/index.php?advanced';
        $bGetOldSecureToken = (SecureTokens::checkFTAN());
        $oRequest = $oReg->getRequester();
        $sDomain = $admin->getDirNamespace(__DIR__);
        $oTrans  = $oReg->getTranslate();
        $oTrans->enableAddon($sDomain);

/**
 * check if there is anything to do
 */
        $post_check = ['reload_languages', 'reload_modules', 'reload_templates'];
        foreach ($post_check as $index => $key) {
            if (!isset($aRequestVars[$key])){ unset($post_check[$index]);}
        }
        if (\count($post_check) === 0) {
          die(\header('Location: index.php?advanced'));
        }

// check if the referer URL if available
        $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] :
                  (isset($HTTP_SERVER_VARS['HTTP_REFERER']) ? $HTTP_SERVER_VARS['HTTP_REFERER'] : '');
        //$referer = '';
// if referer is set, check if script was invoked from "admin/modules/index.php"
        $required_url = $oReg->AcpUrl . 'addons/index.php';
        if (!empty($referer) && (!(\strpos($referer, $required_url) !== false || \strpos($referer, $required_url) !== false))){
    //        die(\header('Location: ../../index.php'));
            $aMessage = \sprintf($oTrans->MESSAGE_GENERIC_INVOKE_REFERER, $oReg->AcpDir);
            throw new \Exception ($aMessage);
        }
// create Admin object with admin header
        $admin = new admin('Addons', '', false, false);
// check FTAN
        if (!$bGetOldSecureToken){
            $aMessage = \sprintf($oTrans->MESSAGE_GENERIC_SECURITY_ACCESS);
            throw new \Exception ($aMessage);
        }
// truncate and rebuild addon table
        if (\count($post_check)===3){
            if (!$database->query('TRUNCATE `'.$oReg->TablePrefix.'addons`')){
                $aMessage = \sprintf('%[d] %s',__LINE__,$database->get_error());
                throw new \Exception ($aMessage);
            }
        } else {
    /**
     * delete no existing addons in table
     */
            $sql  = 'SELECT * FROM `'.$oReg->TablePrefix.'addons` '
                  . 'ORDER BY `type`, `directory` ';
            if ($oAddons = $database->query($sql)) {
                while ($aAddon = $oAddons->fetchAssoc( )) {
                    $delAddon = 'DELETE  FROM `'.$oReg->TablePrefix.'addons` WHERE `addon_id`='.(int)$aAddon['addon_id'];
                    $sAddonFile = $oReg->AppPath.''.$aAddon['type'].'s/'.$aAddon['directory'];
                    switch ($aAddon['type']):
                        case 'language':
                            if (!\file_exists($sAddonFile.'.php')) {
                                $oDelResult = $database->query($delAddon);
                            }
                            break;
                        default:
                            if (!\file_exists($sAddonFile)) {
                                $oDelResult = $database->query($delAddon);
                            }
                        break;
                    endswitch;
                }
            }
        }

    /**
     *
     * Reload all specified Addons
     */
        $msg = [];
        $table = $oReg->TablePrefix . 'addons';

        foreach ($post_check as $key) {
            switch ($key) {
                case 'reload_languages':
                    $aAddonList = \glob($oReg->AppPath.'languages/*.php' );
                    foreach( $aAddonList as $sAddonFile ) {
                        if (\is_readable( $sAddonFile )) {
                            load_language( $sAddonFile );
                        }
                    }
                    // add success message
                    $msg[] = $MESSAGE['ADDON_LANGUAGES_RELOADED'];
                    unset($aAddonList);
                    break;
                case 'reload_modules':
                    $aAddonList = \glob($oReg->AppPath.'modules/*', GLOB_ONLYDIR);
                    foreach( $aAddonList as $sAddonFile ) {
                        if (\is_readable($sAddonFile)) {
                            load_module($sAddonFile);
                        }
                    }
                    // add success message
                    $msg[] = $MESSAGE['ADDON_MODULES_RELOADED'];
                    unset($aAddonList);
                    break;
                case 'reload_templates':
                    $aAddonList = \glob($oReg->AppPath.'templates/*', GLOB_ONLYDIR );
                    foreach( $aAddonList as $sAddonFile ) {
                        if (\is_readable($sAddonFile)) {
                            load_template($sAddonFile);
                        }
                    }
                    // add success message
                    $msg[] = $MESSAGE['ADDON_TEMPLATES_RELOADED'];
                    unset($aAddonList);
                    break;
            }
        }
// disable addon languages
        $oTrans->disableAddon();

    // output success message
        $admin->print_header();
        $admin->print_success(\implode('<br />', $msg), $sBacklinkUrl);
    }catch (\Exception $ex) {
        $admin->print_header();
        $sErrMsg = PreCheck::xnl2br(sprintf('[%d] %s', $ex->getLine(), $ex->getMessage()));
        $admin->print_error ($sErrMsg, $sBacklinkUrl);
        exit;
    }

    $admin->print_footer();
    // end of script ------------------------------------------------------------------------
