<?php 

//Generate app_key
$supportedCiphers = [
'aes-128-cbc' => ['size' => 16, 'aead' => false],
'aes-256-cbc' => ['size' => 32, 'aead' => false],
'aes-128-gcm' => ['size' => 16, 'aead' => true],
'aes-256-gcm' => ['size' => 32, 'aead' => true],
];

function generateKey($cipher = 'aes-128-cbc')
{
    return random_bytes($supportedCiphers[strtolower($cipher)]['size'] ?? 32);
}

$app_key = 'base64:' . base64_encode(generateKey());

echo '<app_key>'.$app_key.'</app_key>';

@unlink('app_key.php');

?>