<?php

declare(strict_types=0);

/**
 * vim:set softtabstop=4 shiftwidth=4 expandtab:
 *
 * LICENSE: GNU Affero General Public License, version 3 (AGPL-3.0-or-later)
 * Copyright Ampache.org, 2001-2024
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

use Ampache\Config\AmpConfig;
use Ampache\Repository\Model\PrivateMsg;
use Ampache\Module\Api\Ajax;
use Ampache\Module\Util\Ui;

/** @var Ampache\Repository\Model\Browse $browse */
/** @var list<int> $object_ids */

$thcount  = 5;
$web_path = AmpConfig::get_web_path(); ?>
<script>
    function getSelectionArray()
    {
        var checked = []
        $("input[name='pvmsg_select[]']:checked").each(function () {
            checked.push(parseInt($(this).val(), 10));
        });
        return checked.join(",");
    }
</script>
<div id="information_actions">
    <ul>
        <li><a href="<?php echo $web_path; ?>/pvmsg.php?action=show_add_message"><?php echo Ui::get_material_symbol('mail', T_('Compose')); ?> <?php echo T_('Compose a New Message'); ?></a></li>
        <li><a href="javascript:NavigateTo('<?php echo $web_path; ?>/pvmsg.php?action=set_is_read&read=1&msgs=' + getSelectionArray());"><?php echo T_('Mark as Read'); ?></a></li>
        <li><a href="javascript:NavigateTo('<?php echo $web_path; ?>/pvmsg.php?action=set_is_read&read=0&msgs=' + getSelectionArray());"><?php echo T_('Mark as Unread'); ?></a></li>
        <li><a href="javascript:NavigateTo('<?php echo $web_path; ?>/pvmsg.php?action=delete&msgs=' + getSelectionArray());"><?php echo Ui::get_material_symbol('close', T_('Delete')); ?> <?php echo T_('Delete'); ?></a></li>
    </ul>
</div>
<?php if ($browse->is_show_header()) {
    require Ui::find_template('list_header.inc.php');
} ?>
<table class="tabledata striped-rows <?php echo $browse->get_css_class(); ?>" data-objecttype="label">
    <thead>
        <tr class="th-top">
            <th class="cel_select essential persist"></th>
            <th class="cel_subject essential persist"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=subject', T_('Subject'), 'pvmsg_sort_subject'); ?></th>
            <th class="cel_from_user essential"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=from_user', T_('Sender'), 'pvmsg_sort_from_user'); ?></th>
            <th class="cel_to_user essential"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=to_user', T_('Recipient'), 'pvmsg_sort_to_user'); ?></th>
            <th class="cel_creation_date essential"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=creation_date', T_('Date'), 'pvmsg_sort_creation_date'); ?></th>
            <th class="cel_action essential"><?php echo T_('Action'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php
        /* Foreach through every label that has been passed to us */
        foreach ($object_ids as $pvmg_id) {
            $libitem = new PrivateMsg($pvmg_id);
            if ($libitem->isNew()) {
                continue;
            } ?>
        <tr id="label_<?php echo $libitem->getId(); ?>" class="<?php echo (!$libitem->isRead()) ? "unread" : ""; ?>">
            <?php require Ui::find_template('show_pvmsg_row.inc.php'); ?>
        </tr>
        <?php
        } ?>
        <?php if (!count($object_ids)) { ?>
        <tr>
            <td colspan="<?php echo $thcount; ?>"><span class="nodata"><?php echo T_('No message found'); ?></span></td>
        </tr>
        <?php } ?>
    </tbody>
    <tfoot>
        <tr class="th-bottom">
            <th class="cel_select essential persist"></th>
            <th class="cel_subject essential persist"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=subject', T_('Subject'), 'pvmsg_sort_subject'); ?></th>
            <th class="cel_from_user essential"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=from_user', T_('Sender'), 'pvmsg_sort_from_user'); ?></th>
            <th class="cel_to_user essential"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=to_user', T_('Recipient'), 'pvmsg_sort_to_user'); ?></th>
            <th class="cel_creation_date essential"><?php echo Ajax::text('?page=browse&action=set_sort&browse_id=' . $browse->id . '&type=pvmsg&sort=creation_date', T_('Date'), 'pvmsg_sort_creation_date'); ?></th>
            <th class="cel_action essential"><?php echo T_('Action'); ?></th>
        </tr>
    </tfoot>
</table>

<?php show_table_render(); ?>
<?php if ($browse->is_show_header()) {
    require Ui::find_template('list_header.inc.php');
} ?>
