<?php

declare(strict_types=1);

/**
 * vim:set softtabstop=4 shiftwidth=4 expandtab:
 *
 * LICENSE: GNU Affero General Public License, version 3 (AGPL-3.0-or-later)
 * Copyright Ampache.org, 2001-2024
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Ampache\Module\System;

use Ampache\Module\System\Plugin\PluginRetriever;
use Ampache\Module\System\Plugin\PluginRetrieverInterface;
use Psr\Log\LoggerInterface;

use function DI\autowire;

return [
    LoggerInterface::class => autowire(LegacyLogger::class),
    SessionInterface::class => autowire(Session::class),
    InstallationHelperInterface::class => autowire(InstallationHelper::class),
    PreferencesFromRequestUpdaterInterface::class => autowire(PreferencesFromRequestUpdater::class),
    Update\UpdateHelperInterface::class => autowire(Update\UpdateHelper::class),
    Update\UpdaterInterface::class => autowire(Update\Updater::class)
        ->constructorParameter(
            'updateRunner',
            autowire(Update\UpdateRunner::class)
        ),
    PluginRetrieverInterface::class => autowire(PluginRetriever::class),
];
