<?php
/**
 * PaymentDetailsShipmentCharge
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Rating
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Rate
 *
 * The Rating API is used when rating or shopping a shipment. # Reference - <a href=\"https://developer.ups.com/api/reference/rating/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/rating/appendix\" target=\"_blank\" rel=\"noopener\">Appendix</a> - <a href=\"https://developer.ups.com/api/reference/rating/error-codes\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/rating/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/rating/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-ac21ef26-eecf-4841-b0b2-737d615b6809?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-ac21ef26-eecf-4841-b0b2-737d615b6809%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub\" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Rating\Rating;

use \ArrayAccess;
use \UPS\Rating\ObjectSerializer;

/**
 * PaymentDetailsShipmentCharge Class Doc Comment
 *
 * @category Class
 * @description Shipment charge container.  If Duty and Tax charges are applicable to a shipment and a payer is not specified, the default payer of Duty and Tax charges is Bill to Receiver. There will be no default payer of Duty and Tax charges for DDU and DDP service.
 * @package  UPS\Rating
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PaymentDetailsShipmentCharge implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'PaymentDetails_ShipmentCharge';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'type' => 'string',
        'bill_shipper' => '\UPS\Rating\Rating\ShipmentChargeBillShipper',
        'bill_receiver' => '\UPS\Rating\Rating\ShipmentChargeBillReceiver',
        'bill_third_party' => '\UPS\Rating\Rating\ShipmentChargeBillThirdParty',
        'consignee_billed_indicator' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'type' => null,
        'bill_shipper' => null,
        'bill_receiver' => null,
        'bill_third_party' => null,
        'consignee_billed_indicator' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'Type',
        'bill_shipper' => 'BillShipper',
        'bill_receiver' => 'BillReceiver',
        'bill_third_party' => 'BillThirdParty',
        'consignee_billed_indicator' => 'ConsigneeBilledIndicator'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'bill_shipper' => 'setBillShipper',
        'bill_receiver' => 'setBillReceiver',
        'bill_third_party' => 'setBillThirdParty',
        'consignee_billed_indicator' => 'setConsigneeBilledIndicator'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'bill_shipper' => 'getBillShipper',
        'bill_receiver' => 'getBillReceiver',
        'bill_third_party' => 'getBillThirdParty',
        'consignee_billed_indicator' => 'getConsigneeBilledIndicator'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['bill_shipper'] = isset($data['bill_shipper']) ? $data['bill_shipper'] : null;
        $this->container['bill_receiver'] = isset($data['bill_receiver']) ? $data['bill_receiver'] : null;
        $this->container['bill_third_party'] = isset($data['bill_third_party']) ? $data['bill_third_party'] : null;
        $this->container['consignee_billed_indicator'] = isset($data['consignee_billed_indicator']) ? $data['consignee_billed_indicator'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type Values are 01 = Transportation, 02 = Duties and Taxes
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets bill_shipper
     *
     * @return \UPS\Rating\Rating\ShipmentChargeBillShipper
     */
    public function getBillShipper()
    {
        return $this->container['bill_shipper'];
    }

    /**
     * Sets bill_shipper
     *
     * @param \UPS\Rating\Rating\ShipmentChargeBillShipper $bill_shipper bill_shipper
     *
     * @return $this
     */
    public function setBillShipper($bill_shipper)
    {
        $this->container['bill_shipper'] = $bill_shipper;

        return $this;
    }

    /**
     * Gets bill_receiver
     *
     * @return \UPS\Rating\Rating\ShipmentChargeBillReceiver
     */
    public function getBillReceiver()
    {
        return $this->container['bill_receiver'];
    }

    /**
     * Sets bill_receiver
     *
     * @param \UPS\Rating\Rating\ShipmentChargeBillReceiver $bill_receiver bill_receiver
     *
     * @return $this
     */
    public function setBillReceiver($bill_receiver)
    {
        $this->container['bill_receiver'] = $bill_receiver;

        return $this;
    }

    /**
     * Gets bill_third_party
     *
     * @return \UPS\Rating\Rating\ShipmentChargeBillThirdParty
     */
    public function getBillThirdParty()
    {
        return $this->container['bill_third_party'];
    }

    /**
     * Sets bill_third_party
     *
     * @param \UPS\Rating\Rating\ShipmentChargeBillThirdParty $bill_third_party bill_third_party
     *
     * @return $this
     */
    public function setBillThirdParty($bill_third_party)
    {
        $this->container['bill_third_party'] = $bill_third_party;

        return $this;
    }

    /**
     * Gets consignee_billed_indicator
     *
     * @return string
     */
    public function getConsigneeBilledIndicator()
    {
        return $this->container['consignee_billed_indicator'];
    }

    /**
     * Sets consignee_billed_indicator
     *
     * @param string $consignee_billed_indicator Consignee Billing payment option indicator. The presence indicates consignee billing option is selected. The absence indicates one of the other payment options is selected.  Empty Tag. This element or its sibling element, BillShipper, BillReceiver or BillThirdParty, must be present but no more than one can be present. This billing option is valid for a shipment charge type of Transportation only. Only applies to US/PR and PR/US shipment origins and destination.
     *
     * @return $this
     */
    public function setConsigneeBilledIndicator($consignee_billed_indicator)
    {
        $this->container['consignee_billed_indicator'] = $consignee_billed_indicator;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
