<?php
/**
 * ShipmentWorldEase
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentWorldEase Class Doc Comment
 *
 * @category Class
 * @description WorldEase is a contract service offering in the UPS shipping that decreases brokerage fees by consolidating loose packages into one shipment for customs clearance.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentWorldEase implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Shipment_WorldEase';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'destination_country_code' => 'string',
        'destination_postal_code' => 'string',
        'gccn' => 'string',
        'master_eu_consolidation_indicator' => 'string',
        'master_has_doc_box' => 'string',
        'master_shipment_chg_type' => 'string',
        'vendor_collect_id_number_exempt_indicator' => 'string',
        'port_of_entry' => '\UPS\Shipping\Shipping\ShipmentWorldEasePortOfEntry'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'destination_country_code' => null,
        'destination_postal_code' => null,
        'gccn' => null,
        'master_eu_consolidation_indicator' => null,
        'master_has_doc_box' => null,
        'master_shipment_chg_type' => null,
        'vendor_collect_id_number_exempt_indicator' => null,
        'port_of_entry' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'destination_country_code' => 'DestinationCountryCode',
        'destination_postal_code' => 'DestinationPostalCode',
        'gccn' => 'GCCN',
        'master_eu_consolidation_indicator' => 'MasterEUConsolidationIndicator',
        'master_has_doc_box' => 'MasterHasDocBox',
        'master_shipment_chg_type' => 'MasterShipmentChgType',
        'vendor_collect_id_number_exempt_indicator' => 'VendorCollectIDNumberExemptIndicator',
        'port_of_entry' => 'PortOfEntry'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'destination_country_code' => 'setDestinationCountryCode',
        'destination_postal_code' => 'setDestinationPostalCode',
        'gccn' => 'setGccn',
        'master_eu_consolidation_indicator' => 'setMasterEuConsolidationIndicator',
        'master_has_doc_box' => 'setMasterHasDocBox',
        'master_shipment_chg_type' => 'setMasterShipmentChgType',
        'vendor_collect_id_number_exempt_indicator' => 'setVendorCollectIdNumberExemptIndicator',
        'port_of_entry' => 'setPortOfEntry'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'destination_country_code' => 'getDestinationCountryCode',
        'destination_postal_code' => 'getDestinationPostalCode',
        'gccn' => 'getGccn',
        'master_eu_consolidation_indicator' => 'getMasterEuConsolidationIndicator',
        'master_has_doc_box' => 'getMasterHasDocBox',
        'master_shipment_chg_type' => 'getMasterShipmentChgType',
        'vendor_collect_id_number_exempt_indicator' => 'getVendorCollectIdNumberExemptIndicator',
        'port_of_entry' => 'getPortOfEntry'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    const MASTER_SHIPMENT_CHG_TYPE_CAF = 'CAF';
    const MASTER_SHIPMENT_CHG_TYPE_COL = 'COL';
    const MASTER_SHIPMENT_CHG_TYPE_DDP = 'DDP';
    const MASTER_SHIPMENT_CHG_TYPE_FOB = 'FOB';
    const MASTER_SHIPMENT_CHG_TYPE_PRE = 'PRE';
    const MASTER_SHIPMENT_CHG_TYPE_SDT = 'SDT';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMasterShipmentChgTypeAllowableValues()
    {
        return [
            self::MASTER_SHIPMENT_CHG_TYPE_CAF,
            self::MASTER_SHIPMENT_CHG_TYPE_COL,
            self::MASTER_SHIPMENT_CHG_TYPE_DDP,
            self::MASTER_SHIPMENT_CHG_TYPE_FOB,
            self::MASTER_SHIPMENT_CHG_TYPE_PRE,
            self::MASTER_SHIPMENT_CHG_TYPE_SDT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['destination_country_code'] = isset($data['destination_country_code']) ? $data['destination_country_code'] : null;
        $this->container['destination_postal_code'] = isset($data['destination_postal_code']) ? $data['destination_postal_code'] : null;
        $this->container['gccn'] = isset($data['gccn']) ? $data['gccn'] : null;
        $this->container['master_eu_consolidation_indicator'] = isset($data['master_eu_consolidation_indicator']) ? $data['master_eu_consolidation_indicator'] : null;
        $this->container['master_has_doc_box'] = isset($data['master_has_doc_box']) ? $data['master_has_doc_box'] : null;
        $this->container['master_shipment_chg_type'] = isset($data['master_shipment_chg_type']) ? $data['master_shipment_chg_type'] : null;
        $this->container['vendor_collect_id_number_exempt_indicator'] = isset($data['vendor_collect_id_number_exempt_indicator']) ? $data['vendor_collect_id_number_exempt_indicator'] : null;
        $this->container['port_of_entry'] = isset($data['port_of_entry']) ? $data['port_of_entry'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['destination_country_code'] === null) {
            $invalidProperties[] = "'destination_country_code' can't be null";
        }
        if ($this->container['master_shipment_chg_type'] === null) {
            $invalidProperties[] = "'master_shipment_chg_type' can't be null";
        }
        $allowedValues = $this->getMasterShipmentChgTypeAllowableValues();
        if (!is_null($this->container['master_shipment_chg_type']) && !in_array($this->container['master_shipment_chg_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'master_shipment_chg_type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['port_of_entry'] === null) {
            $invalidProperties[] = "'port_of_entry' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets destination_country_code
     *
     * @return string
     */
    public function getDestinationCountryCode()
    {
        return $this->container['destination_country_code'];
    }

    /**
     * Sets destination_country_code
     *
     * @param string $destination_country_code The final destination country code.
     *
     * @return $this
     */
    public function setDestinationCountryCode($destination_country_code)
    {
        $this->container['destination_country_code'] = $destination_country_code;

        return $this;
    }

    /**
     * Gets destination_postal_code
     *
     * @return string
     */
    public function getDestinationPostalCode()
    {
        return $this->container['destination_postal_code'];
    }

    /**
     * Sets destination_postal_code
     *
     * @param string $destination_postal_code The final destination postal code.
     *
     * @return $this
     */
    public function setDestinationPostalCode($destination_postal_code)
    {
        $this->container['destination_postal_code'] = $destination_postal_code;

        return $this;
    }

    /**
     * Gets gccn
     *
     * @return string
     */
    public function getGccn()
    {
        return $this->container['gccn'];
    }

    /**
     * Sets gccn
     *
     * @param string $gccn The Global Consolidation Clearance Number(GCCN) generated for the master shipment. This is required for child shipment.
     *
     * @return $this
     */
    public function setGccn($gccn)
    {
        $this->container['gccn'] = $gccn;

        return $this;
    }

    /**
     * Gets master_eu_consolidation_indicator
     *
     * @return string
     */
    public function getMasterEuConsolidationIndicator()
    {
        return $this->container['master_eu_consolidation_indicator'];
    }

    /**
     * Sets master_eu_consolidation_indicator
     *
     * @param string $master_eu_consolidation_indicator 1 indicates a Master Consolidation request for the European Union.
     *
     * @return $this
     */
    public function setMasterEuConsolidationIndicator($master_eu_consolidation_indicator)
    {
        $this->container['master_eu_consolidation_indicator'] = $master_eu_consolidation_indicator;

        return $this;
    }

    /**
     * Gets master_has_doc_box
     *
     * @return string
     */
    public function getMasterHasDocBox()
    {
        return $this->container['master_has_doc_box'];
    }

    /**
     * Sets master_has_doc_box
     *
     * @param string $master_has_doc_box This field is a flag to indicate if the request is a master shipment. This is required for Master shipment only. If MasterHasDocBox is \"0\" then request is considered a master shipment.
     *
     * @return $this
     */
    public function setMasterHasDocBox($master_has_doc_box)
    {
        $this->container['master_has_doc_box'] = $master_has_doc_box;

        return $this;
    }

    /**
     * Gets master_shipment_chg_type
     *
     * @return string
     */
    public function getMasterShipmentChgType()
    {
        return $this->container['master_shipment_chg_type'];
    }

    /**
     * Sets master_shipment_chg_type
     *
     * @param string $master_shipment_chg_type Code that indicates how shipping charges will be paid.  | Code  | Name                | Description:                                                              | | :--:  | :--                 | :--                                                                       | | CAF   | Cost And Freight    | Shipper pays to point of import, conignee pays balance.                   | | COL   | Freight Collect     | Consignee (with valid UPS account) pays all shipping charges              | | DDP   | Delivered Duty Paid | Shipper pays shipping and duty, consignee pays the Value Added Tax (VAT)  | | FOB   | Free On Board       | Shipper pays to point to export, consignee pays balance                   | | PRE   | Prepaid             | Shipper pays all shipping charges                                         | | SDT   | Free Domicile       | Child Shipper pays for shipping, duities and taxes                        |
     *
     * @return $this
     */
    public function setMasterShipmentChgType($master_shipment_chg_type)
    {
        $allowedValues = $this->getMasterShipmentChgTypeAllowableValues();
        if (!in_array($master_shipment_chg_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'master_shipment_chg_type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['master_shipment_chg_type'] = $master_shipment_chg_type;

        return $this;
    }

    /**
     * Gets vendor_collect_id_number_exempt_indicator
     *
     * @return string
     */
    public function getVendorCollectIdNumberExemptIndicator()
    {
        return $this->container['vendor_collect_id_number_exempt_indicator'];
    }

    /**
     * Sets vendor_collect_id_number_exempt_indicator
     *
     * @param string $vendor_collect_id_number_exempt_indicator This field indicates if VendorCollectIDTypeCode and VendorCollectIDNumber should be exempt from validation. \"0\" indicates VendorCollectIDTypeCode and VendorCollectIDNumber fields are required.
     *
     * @return $this
     */
    public function setVendorCollectIdNumberExemptIndicator($vendor_collect_id_number_exempt_indicator)
    {
        $this->container['vendor_collect_id_number_exempt_indicator'] = $vendor_collect_id_number_exempt_indicator;

        return $this;
    }

    /**
     * Gets port_of_entry
     *
     * @return \UPS\Shipping\Shipping\ShipmentWorldEasePortOfEntry
     */
    public function getPortOfEntry()
    {
        return $this->container['port_of_entry'];
    }

    /**
     * Sets port_of_entry
     *
     * @param \UPS\Shipping\Shipping\ShipmentWorldEasePortOfEntry $port_of_entry port_of_entry
     *
     * @return $this
     */
    public function setPortOfEntry($port_of_entry)
    {
        $this->container['port_of_entry'] = $port_of_entry;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
