<?php
namespace Avalara;
use GuzzleHttp\Client;

define('AVATAX_SDK_VERSION', '25.9.0');

/*****************************************************************************
 *                                                                           *
 *      This file is automatically generated by the AvaTax SDK process.      *
 *                  Edits to this file will be overwritten.                  *
 *                                                                           *
 *****************************************************************************/
 
/*****************************************************************************
 *                              Enumerated constants                         *
 *****************************************************************************/

 /**
 * Lists of acceptable values for the enumerated data type TransactionAddressType
 */
class TransactionAddressType
{
    const C_SHIPFROM = "ShipFrom";
    const C_SHIPTO = "ShipTo";
    const C_POINTOFORDERACCEPTANCE = "PointOfOrderAcceptance";
    const C_POINTOFORDERORIGIN = "PointOfOrderOrigin";
    const C_SINGLELOCATION = "SingleLocation";
}


/**
 * Swagger Name: AvaTaxClient
 * Casing to use for validation result
 */
class TextCase
{
    /**
     * Default (casing determined by address standardization setting in Avalara)
     */
    const C_DEFAULT = 0;

    /**
     * Upper case
     */
    const C_UPPER = 1;

    /**
     * Mixed Case
     */
    const C_MIXED = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Represents the different types of transactions that AvaTax can process.
 */
class DocumentType
{
    /**
     * Represents an estimate, or a sales order, or a quote.
     *  
     *  This document type is used before a sale has occurred to estimate the final amount of tax to be paid when the
     *  sale is completed.
     *  
     *  For a sales order, the `companyCode` of the transaction refers to the seller and the `customerVendorCode` refers to the buyer.
     *  
     *  This is a temporary document type and is not saved in tax history.
     */
    const C_SALESORDER = 0;

    /**
     * Represents a sale that has been finalized.
     *  
     *  This document type is used to record a final transaction and calculate the final tax amount with all necessary information.
     *  
     *  For a sales invoice, the `companyCode` of the transaction refers to the seller and the `customerVendorCode` refers to the buyer.
     *  
     *  This is a permanent document and is recorded in AvaTax.
     */
    const C_SALESINVOICE = 1;

    /**
     * Represents an estimate, or a purchase order, or a quote.
     *  
     *  This document type is used before a sale has occurred to estimate the final amount of tax to be paid when the
     *  sale is completed.
     *  
     *  For a purchase order, the `companyCode` of the transaction refers to the buyer and the `customerVendorCode` refers to the seller.
     *  
     *  This is a temporary document type and is not saved in tax history.
     */
    const C_PURCHASEORDER = 2;

    /**
     * Represents a sale that has been finalized.
     *  
     *  This document type is used to record a final transaction and calculate the final tax amount with all necessary information.
     *  
     *  For a purchase invoice, the `companyCode` of the transaction refers to the buyer and the `customerVendorCode` refers to the seller.
     *  
     *  This is a permanent document and is recorded in AvaTax.
     */
    const C_PURCHASEINVOICE = 3;

    /**
     * Represents an estimate of tax to be refunded if a refund or return is processed.
     *  
     *  This document type is used before a customer chooses to request a refund for a previous sale, and it
     *  estimates the final amount of tax to be refunded when the refund is completed.
     *  
     *  For a return order, the `companyCode` of the transaction refers to the seller who is giving the refund
     *  and the `customerVendorCode` refers to the buyer who is requesting the refund.
     *  
     *  This is a temporary document type and is not saved in tax history.
     */
    const C_RETURNORDER = 4;

    /**
     * Represents an refund that has been finalized.
     *  
     *  This document type is used when a customer chooses to request a refund for a previous sale, and it
     *  records the final amount of tax that has been refunded when the refund is completed.
     *  
     *  For a return invoice, the `companyCode` of the transaction refers to the seller who is giving the refund
     *  and the `customerVendorCode` refers to the buyer who is requesting the refund.
     *  
     *  This is a permanent document and is recorded in AvaTax.
     *  
     *  Please note that many jurisdictions around the United States have special rules about how to report refunds
     *  on a sales tax filing, and some refund transactions may be unable to file immediately due to credit netting
     *  rules.
     */
    const C_RETURNINVOICE = 5;

    /**
     * Represents a proposed movement of inventory from one jurisdiction to another.
     *  
     *  This document type is used when physical goods are shipped from one jurisdiction to another, and it
     *  may cause updates in the tax liability for various jurisdictions.
     *  
     *  For an inventory transfer invoice, the `companyCode` of the transaction refers to the owner of the inventory
     *  that will be moved from one location to another.
     *  
     *  This is a temporary document type and is not saved in tax history.
     */
    const C_INVENTORYTRANSFERORDER = 6;

    /**
     * Represents a movement of inventory from one jurisdiction to another that has been finalized.
     *  
     *  This document type is used when physical goods are shipped from one jurisdiction to another, and it
     *  may cause updates in the tax liability for various jurisdictions.
     *  
     *  For an inventory transfer invoice, the `companyCode` of the transaction refers to the owner of the inventory
     *  that will be moved from one location to another.
     *  
     *  This is a permanent document and is recorded in AvaTax.
     */
    const C_INVENTORYTRANSFERINVOICE = 7;

    /**
     * Represents a VAT "Reverse Charge" mechanism transaction as defined in the European Union.
     *  
     *  A Reverse Charge transaction moves the responsibility for VAT reporting from the seller to the buyer, and
     *  is intended to allow simplification of commerce and reduce the reporting requirements for sellers that deliver
     *  goods and services into the single market.
     *  
     *  This is a temporary document type and is not saved in tax history.
     */
    const C_REVERSECHARGEORDER = 8;

    /**
     * Represents a VAT "Reverse Charge" mechanism transaction as defined in the European Union.
     *  
     *  A Reverse Charge transaction moves the responsibility for VAT reporting from the seller to the buyer, and
     *  is intended to allow simplification of commerce and reduce the reporting requirements for sellers that deliver
     *  goods and services into the single market.
     *  
     *  This is a permanent document and is recorded in AvaTax.
     */
    const C_REVERSECHARGEINVOICE = 9;

    /**
     * Represents a VAT "Customs Invoice". 
     *  
     *  The user will enter this DocType with a TaxOverride when the VAT and ImportDuty are calculated by Customs at the border, 
     *  and then these documents are entered later into AvaTax in order to create the balancing entries for VAT and Import Duty.
     *  
     *  This is a permanent document and is recorded in AvaTax.
     */
    const C_CUSTOMSINVOICE = 10;

    /**
     * Represents a VAT "Customs Order".
     *  
     *  The user will enter this DocType with a TaxOverride when the VAT and ImportDuty are calculated by Customs at the border, 
     *  and then these documents are entered later into AvaTax in order to create the balancing entries for VAT and Import Duty.
     *  
     *  This is a temporary document type and is not saved in tax history.
     */
    const C_CUSTOMSORDER = 11;

    /**
     * Represents a proposed movement of inventory from one jurisdiction to another.
     *  
     *  This document type is used when physical goods are shipped from one jurisdiction to another, and it
     *  may cause updates in the tax liability for various jurisdictions.
     *  
     *  For an inventory transfer invoice, the `companyCode` of the transaction refers to the owner of the inventory
     *  that will be moved from one location to another.
     *  
     *  This is a permanent document and is recorded in AvaTax.
     */
    const C_INVENTORYTRANSFEROUTBOUNDINVOICE = 12;

    /**
     * Represents a proposed movement of inventory from one jurisdiction to another.
     *  
     *  This document type is used when physical goods are shipped from one jurisdiction to another, and it
     *  may cause updates in the tax liability for various jurisdictions.
     *  
     *  For an inventory transfer invoice, the `companyCode` of the transaction refers to the owner of the inventory
     *  that will be moved from one location to another.
     *  
     *  This is a temporary document type and is not saved in tax history.
     */
    const C_INVENTORYTRANSFEROUTBOUNDORDER = 13;

    /**
     * Not a real document type.
     *  
     *  This value is used when querying for documents. You can specify the type `Any` in some cases to permit the
     *  system to find any document matching other criteria.
     */
    const C_ANY = -1;

}

/**
 * Swagger Name: AvaTaxClient
 * Type of certificate preview to download
 */
class CertificatePreviewType
{
    /**
     * Download a full printable PDF
     */
    const C_PDF = 1;

    /**
     * Download a single page of the certificate in JPG format
     */
    const C_JPEG = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Type of file request
 */
class PointOfSaleFileType
{
    /**
     * File is in Javascript Object Notation format
     */
    const C_JSON = 0;

    /**
     * File is in Comma Separated Values format
     */
    const C_CSV = 1;

    /**
     * File is in Extended Markup Language format
     */
    const C_XML = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class PointOfSalePartnerId
{    const C_DMA = 1;
    const C_AX7 = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class UserDefinedFieldType
{
    /**
     * Represents document level user defined type.
     */
    const C_DOCUMENT = 1;

    /**
     * Represents line level user defined type.
     */
    const C_LINE = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class POABusinessUnit
{    const C_RETURNS = 0;
    const C_LODGING = 1;
    const C_TELECOM = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class POASubscriptionType
{    const C_MRS = 0;
    const C_AVACOMMS = 1;
    const C_AVAHOSPITALITY = 2;
    const C_AVALODGING = 3;
    const C_MRSCOMPLIANCEMANAGER = 4;
    const C_AMRA = 5;
    const C_MRSPREMIUM = 6;
    const C_MRSPREMIER = 7;

}

/**
 * Swagger Name: AvaTaxClient
 * Defines how a stack rate is determined for a specific country and region.
 */
class StackAggregationOption
{
    /**
     * No aggregation.
     *  The component rate is used for the stack rate.
     */
    const C_NOSTACKAGGREGATION = 0;

    /**
     * Rates are aggregated across all jurisdiction types.
     */
    const C_FULLSTACKAGGREGATION = 1;

    /**
     * State and county rates are aggregated.
     */
    const C_AGGREGATESTATEANDCOUNTY = 2;

    /**
     * City and county rates are aggregated.
     */
    const C_AGGREGATECITYANDCOUNTY = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * AP Config Tolerance Type
 */
class ApConfigToleranceType
{
    /**
     * RealTime
     */
    const C_REALTIME = 0;

    /**
     * Batch
     */
    const C_BATCH = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * Status of an Avalara account
 */
class AccountStatusId
{
    /**
     * This account is not currently active.
     */
    const C_INACTIVE = 0;

    /**
     * This account is active and in use.
     */
    const C_ACTIVE = 1;

    /**
     * This account is flagged as a test account and may be temporary.
     */
    const C_TEST = 2;

    /**
     * The account is new and is currently in the onboarding process.
     *  
     *  An account is considered new until the account administrator has reviewed and accepted
     *  [Avalara's terms and conditions](https://www.avalara.com/us/en/legal/terms.html).
     */
    const C_NEW = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Status of an Avalara account
 */
class AccountTypeId
{
    /**
     * Regular AvaTax account.
     */
    const C_REGULAR = 1;

    /**
     * Firm account.
     */
    const C_FIRM = 2;

    /**
     * Client account created by firm.
     */
    const C_FIRMCLIENT = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * The address resolution quality of an address validation result
 */
class ResolutionQuality
{
    /**
     * Location was not geocoded
     */
    const C_NOTCODED = 0;

    /**
     * Location was already geocoded on the request
     */
    const C_EXTERNAL = 1;

    /**
     * Avalara-defined country centroid
     */
    const C_COUNTRYCENTROID = 2;

    /**
     * Avalara-defined state / province centroid
     */
    const C_REGIONCENTROID = 3;

    /**
     * Geocoded at a level more coarse than a PostalCentroid1
     */
    const C_PARTIALCENTROID = 4;

    /**
     * Largest postal code (zip5 in US, left three in CA, etc
     */
    const C_POSTALCENTROIDGOOD = 5;

    /**
     * Better postal code (zip7 in US)
     */
    const C_POSTALCENTROIDBETTER = 6;

    /**
     * Best postal code (zip9 in US, complete postal code elsewhere)
     */
    const C_POSTALCENTROIDBEST = 7;

    /**
     * Nearest intersection
     */
    const C_INTERSECTION = 8;

    /**
     * Interpolated to rooftop
     */
    const C_INTERPOLATED = 9;

    /**
     * Assumed to be rooftop level, non-interpolated
     */
    const C_ROOFTOP = 10;

    /**
     * Pulled from a static list of geocodes for specific jurisdictions
     */
    const C_CONSTANT = 11;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates the type of adjustment that was performed on a transaction
 */
class AdjustmentReason
{
    /**
     * The transaction has not been adjusted
     */
    const C_NOTADJUSTED = 0;

    /**
     * A sourcing issue existed which caused the transaction to be adjusted
     */
    const C_SOURCINGISSUE = 1;

    /**
     * Transaction was adjusted to reconcile it with a general ledger
     */
    const C_RECONCILEDWITHGENERALLEDGER = 2;

    /**
     * Transaction was adjusted after an exemption certificate was applied
     */
    const C_EXEMPTCERTAPPLIED = 3;

    /**
     * Transaction was adjusted when the price of an item changed
     */
    const C_PRICEADJUSTED = 4;

    /**
     * Transaction was adjusted due to a product return
     */
    const C_PRODUCTRETURNED = 5;

    /**
     * Transaction was adjusted due to a product exchange
     */
    const C_PRODUCTEXCHANGED = 6;

    /**
     * Transaction was adjusted due to bad or uncollectable debt
     */
    const C_BADDEBT = 7;

    /**
     * Transaction was adjusted for another reason not specified
     */
    const C_OTHER = 8;

    /**
     * Offline
     */
    const C_OFFLINE = 9;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class BulkImportStatus
{    const C_NONE = 0;
    const C_SUCCESS = 1;
    const C_CREATED = 2;
    const C_UPDATED = 4;
    const C_NOTIMPORTED = 8;
    const C_IGNORED = 16;
    const C_ERROR = 32;
    const C_VALIDATIONFAILED = 64;
    const C_PARTIALSUCCESS = 128;
    const C_INVALID = 256;

}

/**
 * Swagger Name: AvaTaxClient
 * Represents a error code message
 */
class ErrorCodeId
{
    /**
     * Server has a configuration or setup problem
     */
    const C_SERVERCONFIGURATION = 1;

    /**
     * User doesn't have rights to this account or company
     */
    const C_ACCOUNTINVALIDEXCEPTION = 2;
    const C_COMPANYINVALIDEXCEPTION = 3;

    /**
     * Use this error message when the user is trying to fetch a single object and the object either does not exist or cannot be seen by the current user.
     */
    const C_ENTITYNOTFOUNDERROR = 4;
    const C_VALUEREQUIREDERROR = 5;
    const C_RANGEERROR = 6;
    const C_RANGECOMPAREERROR = 7;
    const C_RANGESETERROR = 8;
    const C_TAXPAYERNUMBERREQUIRED = 9;
    const C_ENTITYLIMITEXCEEDED = 10;
    const C_COMMONPASSWORD = 11;
    const C_WEAKPASSWORD = 12;
    const C_STRINGLENGTHERROR = 13;
    const C_MAXSTRINGLENGTHERROR = 14;
    const C_EMAILVALIDATIONERROR = 15;
    const C_EMAILMISSINGERROR = 16;
    const C_INVALIDQUERYFIELD = 17;
    const C_INVALIDQUERYVALUE = 18;
    const C_SYNTAXERROR = 19;
    const C_TOOMANYPARAMETERSERROR = 20;
    const C_UNTERMINATEDVALUEERROR = 21;
    const C_DELETEUSERSELFERROR = 22;
    const C_OLDPASSWORDINVALID = 23;
    const C_CANNOTCHANGEPASSWORD = 24;
    const C_READONLY = 25;
    const C_DATEFORMATERROR = 26;
    const C_NODEFAULTCOMPANY = 27;
    const C_ACCOUNTTYPENOTSUPPORTED = 28;
    const C_INVALIDAUTHENTICATIONTYPE = 29;
    const C_AUTHENTICATIONEXCEPTION = 30;
    const C_AUTHORIZATIONEXCEPTION = 31;
    const C_VALIDATIONEXCEPTION = 32;
    const C_INACTIVEUSERERROR = 33;
    const C_AUTHENTICATIONINCOMPLETE = 34;
    const C_BASICAUTHINCORRECT = 35;
    const C_IDENTITYSERVERERROR = 36;
    const C_BEARERTOKENINVALID = 37;
    const C_MODELREQUIREDEXCEPTION = 38;
    const C_ACCOUNTEXPIREDEXCEPTION = 39;
    const C_BEARERTOKENNOTSUPPORTED = 41;
    const C_INVALIDSECURITYROLE = 42;
    const C_INVALIDREGISTRARACTION = 43;
    const C_REMOTESERVERERROR = 44;
    const C_NOFILTERCRITERIAEXCEPTION = 45;
    const C_OPENCLAUSEEXCEPTION = 46;
    const C_JSONFORMATERROR = 47;
    const C_INVALIDDECIMALVALUE = 48;
    const C_PERMISSIONREQUIRED = 49;
    const C_UNHANDLEDEXCEPTION = 50;
    const C_INACTIVEACCOUNT = 51;
    const C_LINKAGENOTALLOWED = 52;
    const C_LINKAGESTATUSUPDATENOTSUPPORTED = 53;
    const C_REPORTINGCOMPANYMUSTHAVECONTACTSERROR = 60;
    const C_COMPANYPROFILENOTSET = 61;
    const C_CANNOTASSIGNUSERTOCOMPANY = 62;
    const C_MUSTASSIGNUSERTOCOMPANY = 63;
    const C_INVALIDTAXTYPEMAPPING = 64;
    const C_MODELSTATEINVALID = 70;
    const C_DATERANGEERROR = 80;
    const C_INVALIDDATERANGEERROR = 81;
    const C_RULEMUSTHAVETAXCODE = 82;
    const C_RULETYPERESTRICTED = 83;
    const C_ALLJURISRULELIMITS = 84;
    const C_INVALIDCOMPANYLOCATIONSETTING = 85;
    const C_INVALIDADJUSTMENTTYPE = 99;
    const C_DELETEINFORMATION = 100;
    const C_DISABLEAUTHENTICATIONFORSAMLBASEDACCOUNTS = 101;
    const C_DISABLERESETPASSWORDFORSAMLBASEDACCOUNTS = 102;
    const C_OUTOFRANGE = 118;
    const C_UNSPECIFIEDTIMEZONE = 119;
    const C_CANNOTCREATEDELETEDOBJECTS = 120;
    const C_CANNOTMODIFYDELETEDOBJECTS = 121;
    const C_RETURNNAMENOTFOUND = 122;
    const C_INVALIDADDRESSTYPEANDCATEGORY = 123;
    const C_DEFAULTCOMPANYLOCATION = 124;
    const C_INVALIDCOUNTRY = 125;
    const C_INVALIDCOUNTRYREGION = 126;
    const C_BRAZILVALIDATIONERROR = 127;
    const C_BRAZILEXEMPTVALIDATIONERROR = 128;
    const C_BRAZILPISCOFINSERROR = 129;
    const C_JURISDICTIONNOTFOUNDERROR = 130;
    const C_MEDICALEXCISEERROR = 131;
    const C_RATEDEPENDSTAXABILITYERROR = 132;
    const C_INVALIDRATETYPECODE = 134;
    const C_RATETYPENOTSUPPORTED = 135;
    const C_CANNOTUPDATENESTEDOBJECTS = 136;
    const C_UPCCODEINVALIDCHARS = 137;
    const C_UPCCODEINVALIDLENGTH = 138;
    const C_INCORRECTPATHERROR = 139;
    const C_INVALIDJURISDICTIONTYPE = 140;
    const C_MUSTCONFIRMRESETLICENSEKEY = 141;
    const C_DUPLICATECOMPANYCODE = 142;
    const C_TINFORMATERROR = 143;
    const C_DUPLICATENEXUSERROR = 144;
    const C_UNKNOWNNEXUSERROR = 145;
    const C_PARENTNEXUSNOTFOUND = 146;
    const C_INVALIDTAXCODETYPE = 147;
    const C_CANNOTACTIVATECOMPANY = 148;
    const C_DUPLICATEENTITYPROPERTY = 149;
    const C_REPORTINGENTITYERROR = 150;
    const C_INVALIDRETURNOPERATIONERROR = 151;
    const C_CANNOTDELETECOMPANY = 152;
    const C_COUNTRYOVERRIDESNOTAVAILABLE = 153;
    const C_JURISDICTIONOVERRIDEMISMATCH = 154;
    const C_DUPLICATESYSTEMTAXCODE = 155;
    const C_SSTOVERRIDESNOTAVAILABLE = 156;
    const C_NEXUSDATEMISMATCH = 157;
    const C_NEXUSPARENTDATEMISMATCH = 159;
    const C_BEARERTOKENPARSEUSERIDERROR = 160;
    const C_RETRIEVEUSERERROR = 161;
    const C_INVALIDCONFIGURATIONSETTING = 162;
    const C_INVALIDCONFIGURATIONVALUE = 163;
    const C_INVALIDENUMVALUE = 164;
    const C_TAXCODEASSOCIATEDTAXRULE = 165;
    const C_CANNOTSWITCHACCOUNTID = 166;
    const C_REQUESTINCOMPLETE = 167;
    const C_ACCOUNTNOTNEW = 168;
    const C_PASSWORDLENGTHINVALID = 169;
    const C_INVALIDPAGEKEY = 170;
    const C_INVALIDECMSOVERRIDECODE = 171;
    const C_ACCOUNTDOESNOTEXIST = 172;
    const C_INVALIDTAXTYPE = 173;
    const C_INCORRECTFIELDVALUE = 174;
    const C_LEADINGORTRAILINGEXCEPTION = 175;
    const C_NOTENOUGHADDRESSESINFO = 176;
    const C_REPORTNOTINITIATED = 177;
    const C_FAILEDTOBUILDREPORT = 178;
    const C_REPORTNOTFINISHED = 179;
    const C_FAILEDTODOWNLOADREPORT = 181;
    const C_MALFORMEDFILTEREXCEPTION = 182;
    const C_EXPECTEDCONJUNCTIONERROR = 183;
    const C_CRITERIANOTSUPPORTEDERROR = 184;
    const C_COMPANYACCOUNTANDPARENTACCOUNTMISMATCH = 185;
    const C_INVALIDFILECONTENTTYPE = 186;
    const C_REQUESTTOOLARGE = 187;
    const C_ECMSDISABLED = 188;
    const C_UNKNOWNCONJUNCTIONERROR = 189;
    const C_NOLINESDISCOUNTED = 190;
    const C_FAILEDTODELETE = 191;
    const C_CIRCULARCOMPANYHIERARCHIES = 192;
    const C_DUPLICATEENTRY = 193;
    const C_DUPLICATEFIELDNAMEINORDERBY = 194;
    const C_CANNOTADJUSTDOCUMENTTYPE = 195;
    const C_USERNOACCESS = 196;
    const C_INVALIDENTRY = 197;
    const C_TRANSACTIONALREADYCANCELLED = 198;
    const C_QUERYPARAMETEROUTOFRANGE = 199;

    /**
     * Batch errors
     *  New batch error codes continue at 2501
     */
    const C_BATCHSALESAUDITMUSTBEZIPPEDERROR = 200;
    const C_BATCHZIPMUSTCONTAINONEFILEERROR = 201;
    const C_BATCHINVALIDFILETYPEERROR = 202;
    const C_BATCHCANNOTSAVEBATCHFILE = 203;
    const C_BATCHCANNOTGETBATCHFILE = 204;
    const C_BATCHCANNOTDELETEBATCHFILE = 205;
    const C_BATCHMUSTCONTAINONEFILE = 206;
    const C_MISSINGBATCHFILECONTENT = 207;
    const C_BATCHCANNOTBEDELETEDWHILEPROCESSING = 208;

    /**
     * BizTech error
     */
    const C_INTERNALSERVERERROR = 209;

    /**
     * Point Of Sale API exceptions
     */
    const C_POINTOFSALEFILESIZE = 250;
    const C_POINTOFSALESETUP = 251;
    const C_INVALIDINPUTDATE = 252;

    /**
     * Errors in Soap V1 Passthrough / GetTax calls
     */
    const C_GETTAXERROR = 300;
    const C_ADDRESSCONFLICTEXCEPTION = 301;
    const C_DOCUMENTCODECONFLICT = 303;
    const C_MISSINGADDRESS = 304;
    const C_INVALIDPARAMETERVALUE = 306;
    const C_FETCHLIMIT = 308;
    const C_INVALIDADDRESS = 309;
    const C_ADDRESSLOCATIONNOTFOUND = 310;
    const C_MISSINGLINE = 311;
    const C_INVALIDADDRESSTEXTCASE = 312;
    const C_DOCUMENTNOTCOMMITTED = 313;
    const C_LINEFETCHLIMITEXCEEDED = 314;
    const C_INVALIDDOCUMENTTYPESTOFETCH = 315;
    const C_TIMEOUTREQUESTED = 316;
    const C_INVALIDPOSTALCODE = 317;

    /**
     * Subscription error codes
     */
    const C_INVALIDSUBSCRIPTIONDESCRIPTION = 318;
    const C_INVALIDSUBSCRIPTIONTYPEID = 319;

    /**
     * Represents a malformed document fetch command
     */
    const C_CANNOTCHANGEFILINGSTATUS = 401;

    /**
     * Represents a FEIN in incorrect format.
     */
    const C_FEINFORMATERROR = 402;

    /**
     * Represents a SQL server timeout error / deadlock error
     */
    const C_SERVERUNREACHABLE = 500;

    /**
     * Partner API error codes
     */
    const C_SUBSCRIPTIONREQUIRED = 600;
    const C_ACCOUNTEXISTS = 601;
    const C_INVITATIONONLY = 602;
    const C_ACCOUNTNOTWHITELISTED = 603;
    const C_FREETRIALNOTAVAILABLE = 606;
    const C_ACCOUNTEXISTSDIFFERENTEMAIL = 607;
    const C_AVALARAIDENTITYAPIERROR = 608;
    const C_INVALIDIPADDRESS = 609;
    const C_OFFERCODEALREADYAPPLIED = 610;
    const C_ACCOUNTALREADYEXISTS = 611;
    const C_LICENSEKEYNAMEALREADYEXISTSFORACCOUNT = 612;
    const C_USERALREADYEXISTS = 613;
    const C_USERNOTFOUND = 614;
    const C_USERMANAGEMENTEXCEPTION = 615;

    /**
     * Refund API error codes
     */
    const C_REFUNDTYPEANDPERCENTAGEMISMATCH = 701;
    const C_INVALIDDOCUMENTTYPEFORREFUND = 702;
    const C_REFUNDTYPEANDLINEMISMATCH = 703;
    const C_REFUNDLINESREQUIRED = 704;
    const C_INVALIDREFUNDTYPE = 705;
    const C_REFUNDPERCENTAGEFORTAXONLY = 706;
    const C_LINENOOUTOFRANGE = 707;
    const C_REFUNDPERCENTAGEOUTOFRANGE = 708;
    const C_REFUNDPERCENTAGEMISSING = 709;

    /**
     * Free API error codes
     */
    const C_MUSTUSECREATETRANSACTION = 800;
    const C_MUSTACCEPTTERMSANDCONDITIONS = 801;

    /**
     * Filing Calendar Error Codes
     */
    const C_FILINGCALENDARCANNOTBEDELETED = 900;
    const C_INVALIDEFFECTIVEDATE = 901;
    const C_NONOUTLETFORM = 902;
    const C_OVERLAPPINGFILINGCALENDAR = 903;
    const C_FILINGCALENDARCANNOTBEEDITED = 904;

    /**
     * Create or update transaction error codes
     */
    const C_CANNOTMODIFYLOCKEDTRANSACTION = 1100;
    const C_LINEALREADYEXISTS = 1101;
    const C_LINEDOESNOTEXIST = 1102;
    const C_LINESNOTSPECIFIED = 1103;
    const C_LINEDETAILSDOESNOTEXIST = 1104;
    const C_CANNOTCREATETRANSACTIONWITHDELETEDDATASOURCE = 1105;
    const C_SHIPTOREGIONREQUIREDWITHDATASOURCE = 1106;

    /**
     * Exempt cert error codes
     */
    const C_INVALIDBUSINESSTYPE = 1200;
    const C_CANNOTMODIFYEXEMPTCERT = 1201;
    const C_CERTIFICATESERROR = 1203;
    const C_MISSINGREQUIREDFIELDS = 1204;
    const C_CERTIFICATESNOTSETUP = 1205;
    const C_CONFLICTINGEXPOSUREZONE = 1208;
    const C_MISSINGFIELDTOCREATEEXPOSUREZONE = 1209;
    const C_MISSINGEXEMPTREASON = 1210;
    const C_INVALIDEXEMPTREASON = 1211;
    const C_INVALIDEXEMPTIONOPERATION = 1212;
    const C_CONFLICTINGFIELDS = 1213;
    const C_INVALIDPDFORIMAGEFILE = 1214;
    const C_INVALIDCOVERLETTERTITLE = 1215;
    const C_ACCOUNTNOTPROVISIONED = 1216;
    const C_INVALIDREQUESTCONTENTTYPE = 1217;
    const C_EXEMPTIONPAGINATIONLIMITS = 1218;
    const C_EXEMPTIONSORTLIMITS = 1219;
    const C_CUSTOMERCANTBEBOTHSHIPTOANDBILLTO = 1220;
    const C_BILLTOCUSTOMEREXPECTED = 1221;
    const C_SHIPTOCUSTOMEREXPECTED = 1222;
    const C_ECMSSSTCERTSREQUIRED = 1223;

    /**
     * Multi document error codes
     */
    const C_TRANSACTIONNOTCANCELLED = 1300;
    const C_TOOMANYTRANSACTIONS = 1301;
    const C_ONLYTAXDATEOVERRIDEISALLOWED = 1302;
    const C_TRANSACTIONALREADYEXISTS = 1303;
    const C_MULTIDOCUMENTTRANSACTIONALREADYEXISTS = 1304;
    const C_DATEMISMATCH = 1305;
    const C_INVALIDDOCUMENTSTATUSFORVERIFY = 1306;
    const C_TOTALAMOUNTMISMATCH = 1307;
    const C_TOTALTAXMISMATCH = 1308;
    const C_INVALIDDOCUMENTTYPE = 1310;
    const C_MULTIDOCUMENTPARTIALLYLOCKED = 1312;
    const C_TRANSACTIONISCOMMITTED = 1313;
    const C_INVALIDDOCUMENTSTATUS = 1314;

    /**
     * Communications Tax error codes
     */
    const C_COMMSCONFIGCLIENTIDMISSING = 1400;
    const C_COMMSCONFIGCLIENTIDBADVALUE = 1401;

    /**
     * Account Activate error codes
     */
    const C_ACCOUNTINNEWSTATUSEXCEPTION = 1404;

    /**
     * Worksheet Exception
     */
    const C_WORKSHEETEXCEPTION = 1405;
    const C_INVALIDACCOUNTOVERRIDE = 1406;
    const C_ACCOUNTOVERRIDENOTAUTHORIZED = 1407;
    const C_FIELDNOTQUERYABLEERROR = 1408;
    const C_USERNAMEREQUIRED = 1409;
    const C_INVALIDAUDITMESSAGE = 1410;
    const C_FIELDNOTORDERABLEERROR = 1411;

    /**
     * Nexus validation error codes
     */
    const C_CANNOTDELETEPARENTBEFORECHILDNEXUS = 1500;
    const C_NEXUSCHILDDATEMISMATCH = 1501;

    /**
     * Remote validation Error
     */
    const C_REMOTEVALIDATIONERROR = 1502;
    const C_CANNOTMODIFYSSTNEXUS = 1503;
    const C_INVALIDLOCALNEXUSTYPEID = 1504;

    /**
     * Advanced rule errors
     */
    const C_ADVANCEDRULEREQUESTRULEERROR = 1602;
    const C_ADVANCEDRULERESPONSERULEERROR = 1603;
    const C_ADVANCEDRULEERROR = 1605;

    /**
     * Miscellaneous
     */
    const C_TAXRULEREQUIRESNEXUS = 1701;
    const C_UPCCODENOTUNIQUE = 1702;
    const C_TAXCODEASSOCIATEDWITHITEMCODENOTFOUND = 1704;
    const C_DUPLICATESYSTEMFORITEM = 1705;
    const C_CANNOTDISMISSGLOBALNOTIFICATION = 1706;
    const C_CANNOTUPDATEACCOUNTTYPEID = 1713;
    const C_TAXPAYERNUMBERISREQUIRED = 1714;
    const C_REQUESTLIMITEXCEEDED = 1715;
    const C_CONCURRENTREQUESTLIMITEXCEEDED = 1716;
    const C_INVALIDDOCUMENTTYPEFORINSPECT = 1717;
    const C_SERVICENOTREADY = 1718;
    const C_UPDATELOCATIONREMITTANCEMISMATCHTYPEANDCATEGORY = 1719;
    const C_UPDATELOCATIONREMITTANCECHECKEXISTINGEFFECTIVEDATEERROR = 1720;
    const C_UPDATELOCATIONREMITTANCECHECKEXISTINGENDDATEERROR = 1721;
    const C_ERRORCOUNTLIMITEXCEEDEDERROR = 1722;
    const C_RATELIMITEXCEEDEDERROR = 1723;
    const C_TAXCODEANDTAXCODEIDMISSING = 1724;
    const C_NEXUSALREADYEXISTS = 1725;
    const C_INVALIDADDRESSTYPEANDMARKETPLACEOUSIDEUSAFLAG = 1726;
    const C_INVALIDSETTINGSET = 1727;
    const C_INVALIDSETTINGNAME = 1728;
    const C_INVALIDSETTINGVALUE = 1729;
    const C_TOOMANYUSERDEFINEDFIELDS = 1730;
    const C_DUPLICATEUSERDEFINEDFIELDSFOUND = 1731;
    const C_INVALIDNAMEFORUSERDEFINEDFIELD = 1732;
    const C_INVALIDRESTRICTIONTYPE = 1733;
    const C_INVALIDPARAMETER = 1734;
    const C_INVALIDSYSTEMCODE = 1735;
    const C_NOITEMSFORCLASSIFICATION = 1736;
    const C_INVALIDFILENAME = 1737;
    const C_NOCLASSIFICATIONFORSAMEHSCODE = 1738;
    const C_INVALIDVALUEERROR = 1739;
    const C_ITEMDUALWRITEPARAMETERVALUEMISMATCHERROR = 1740;
    const C_DUPLICATEITEMIDSINTAXCODECLASSIFICATIONREQUEST = 1741;
    const C_TOOMANYITEMIDSINTAXCODECLASSIFICATIONREQUEST = 1742;
    const C_INVALIDPRODUCTCODELENGTH = 1743;
    const C_INVALIDPRODUCTCODEFORMAT = 1744;
    const C_INVALIDCOUNTRYASSIGNMENT = 1745;

    /**
     * SendSales API errors
     */
    const C_UNSUPPORTEDFILEFORMAT = 1800;
    const C_UNSUPPORTEDOUTPUTFILETYPE = 1801;

    /**
     * TaxProfile API errors
     */
    const C_TAXPROFILENOTPROVIDED = 1900;
    const C_INVALIDTAXPROFILE = 1901;
    const C_COMPANYTAXPROFILEENTRYREQUIRED = 1902;
    const C_ERRORREADINGTAXPROFILEENTRY = 1903;

    /**
     * AuditAccount API errors
     */
    const C_TRACEDATANOTAVAILABLE = 2000;

    /**
     * Item and Nexus parameter errors
     */
    const C_INVALIDPARAMETERUNITMEASUREMENTTYPE = 2100;
    const C_PARAMETERUNITREQUIRED = 2101;
    const C_INVALIDPARAMETERVALUEDATATYPE = 2102;
    const C_INVALIDPARAMETERATTRIBUTETYPE = 2103;
    const C_SUBSCRIPTIONREQUIREDFORPARAMETER = 2104;

    /**
     * Accounting Firm errors
     */
    const C_INVALIDACCOUNTTYPE = 2105;
    const C_INVALIDFIRMSUBSCRIPTIONS = 2106;

    /**
     * Certify Company Errors
     */
    const C_GENERICTAXCODEFORITEM = 2200;
    const C_CANNOTCERTIFYCOMPANY = 2201;
    const C_NOVOIDEDDOCUMENTS = 2202;
    const C_INADEQUATECOMMITTEDDOCUMENTS = 2203;
    const C_DOCUMENTCODEISGUID = 2204;
    const C_CUSTOMERVENDORCODEISGUID = 2205;
    const C_INADEQUATEDOCUMENTLINECOUNT = 2206;
    const C_SAMEDOCUMENTDESCRIPTION = 2207;
    const C_NOEXEMPTIONNOORCUSTOMERUSAGETYPE = 2208;
    const C_INADEQUATEUNIQUEADDRESSES = 2209;
    const C_ITEMCODESAREALLSAME = 2210;
    const C_TAXCODESAREALLSAME = 2211;
    const C_LOCATIONCODENOTUSED = 2212;
    const C_REPEATEDLINESINDOCUMENT = 2213;
    const C_TAXDATEOVERRIDEANDNEGATIVELINEAMOUNT = 2214;
    const C_ALLUSDCURRENCYCODES = 2215;
    const C_NOVATBUYERID = 2216;
    const C_ALLUSCOUNTRYCODES = 2217;
    const C_NODOCUMENTSTOTEST = 2218;
    const C_NOSHIPPINGCHARGE = 2219;

    /**
     * Company Controller Related Errors
     */
    const C_FAILEDTOUPDATECOMPANYLOCATION = 2314;
    const C_COMPANYLOCATIONDATERANGEOVERLAP = 2315;

    /**
     * Generic validation errors
     */
    const C_FIELDLENGTHERROR = 2400;
    const C_INPUTCONTAINSBLACKLISTEDCHARACTERS = 2401;
    const C_CANNOTCREATENESTEDOBJECTS = 2402;
    const C_INVALIDUSERNAME = 2403;

    /**
     * User's SubjectId not updated by DB query
     */
    const C_USERSUBJECTIDNOTUPDATED = 2500;

    /**
     * Batch errors
     *  For other batch errors, see: 200 - 208 above
     */
    const C_BATCHTRANSACTIONTYPEERROR = 2501;
    const C_BATCHTRANSACTIONLINELIMITEXCEEDED = 2502;
    const C_BATCHCOMPANYIDANDCOMPANYCODEMISMATCH = 2503;
    const C_BATCHCANNOTBECANCELLEDSTATUSERROR = 2504;
    const C_BATCHCANNOTBECANCELLEDFORMATERROR = 2505;
    const C_BATCHTYPENOTSUPPORTED = 2506;

    /**
     * Parameter related errors
     */
    const C_INVALIDPARAMETERDATATYPE = 2600;

    /**
     * Tags related error
     */
    const C_TAGDOESNOTEXIST = 2620;

    /**
     * Object deleted message
     */
    const C_OBJECTDELETED = 2660;
    const C_ASSOCIATEDOBJECTSDELETED = 2661;

    /**
     * Additional report related errors
     */
    const C_CANNOTDOWNLOADREPORT = 2700;

    /**
     * AVT-10699 - Multi-tax custom Tax Rules (Phase 1)
     */
    const C_INVALIDUNITOFBASIS = 2800;
    const C_NOTAPPLICABLEUNITOFBASIS = 2801;
    const C_INVALIDRATETYPETAXTYPEMAPPING = 2802;
    const C_INVALIDTAXTYPEGROUP = 2803;
    const C_INVALIDTAXSUBTYPE = 2804;
    const C_INVALIDPRODUCTTYPEID = 2805;
    const C_INVALIDTAXRULETYPE = 2806;
    const C_INVALIDHSCODE = 2807;
    const C_NOTAPPLICABLETAXTYPE = 2808;
    const C_INVALIDTAXTYPECODE = 2809;
    const C_CONTENTACCESSDENIED = 2810;
    const C_CONTENTNOTFOUND = 2811;
    const C_REGISTRATIONNUMBERNOTFOUND = 2812;
    const C_INVALIDCOSTCENTER = 2813;

    /**
     * Sync flow restricts one record for Item model
     */
    const C_TOOMANYITEMSINSYNCFLOWREQUEST = 2814;

    /**
     * IMS-2096: Recommendation status update rule
     */
    const C_INVALIDTAXCODEIDINRECOMMENDATIONSTATUSUPDATE = 2815;

    /**
     * ECM communication certificates error
     */
    const C_COMMUNICATIONCERTIFICATESERROR = 2816;

    /**
     * Invalid currency and aggrement type combination
     */
    const C_INVALIDCURRENCYAGGREMENTTYPE = 2817;

    /**
     * ItemTaxCodeRecommendation Status can't be set without particular state of recommendation
     */
    const C_INVALIDTAXCODERECOMMENDATIONSTATUSUPDATE = 2818;

    /**
     * Filing Request Error Codes
     */
    const C_DUPLICATEFILINGREQUEST = 2819;

    /**
     * Occurs when a Header value is incorrect or invalid in some way
     */
    const C_INVALIDHTTPHEADER = 3000;
    const C_SCSSERVICEUNREACHABLE = 3001;
    const C_DUPLICATECONTACTCODE = 3002;
    const C_SCSSERVERERROR = 3003;

    /**
     * Occurs when user reconciliation happens and unable to create user at AvaTax
     */
    const C_USERRECONCILIATIONERROR = 3004;

    /**
     * Occurs when a patch operation is attempted on a field that is not allowed to be patched
     */
    const C_INVALIDHTTPPATCHREQUEST = 3005;

    /**
     * Occurs when a patch operation other than 'given' operation is performed for the fields
     */
    const C_UNSUPPORTEDPATCHOPERATIONERROR = 3006;

    /**
     * Occurs when system code and country code does not have active mapping.
     */
    const C_SYSTEMCODEANDCOUNTRYCODEMISMATCH = 3007;

    /**
     * Occurs when multiple entries for system code and country code exists.
     */
    const C_DUPLICATESYSTEMANDCOUNTRYFORITEM = 3008;
    const C_INVALIDHSCODECLASSIFICATIONSTATUSOVERRIDE = 3009;

    /**
     * Occurs when the field name provided in the request isn't valid.
     */
    const C_INVALIDFIELD = 3010;
    const C_DUPLICATEPATCHOPERATION = 3011;

    /**
     * Avalara Gateway errors:
     */
    const C_NOTFOUND = 4001;
    const C_UNEXPECTED = 4002;
    const C_NOHOSTFOUND = 4003;
    const C_UNEXPECTEDAUTH = 4004;
    const C_SITESELECTIONFAILED = 4006;
    const C_DROPDEFAULTUSERNAME = 4007;
    const C_DROPDEFAULTNOTMIGRATED = 4008;
    const C_DROPBEARERAUTH = 4009;
    const C_SITESELECTIONERROR = 4010;
    const C_RATELIMITEXCEEDED = 4011;
    const C_NOHEALTHYSITE = 4012;
    const C_CLIENTDISCONNECTED = 4013;
    const C_SERVICEDISCONNECTED = 4014;
    const C_SERVICETIMEOUT = 4015;

    /**
     * File Validation Service (FVS) Errors
     */
    const C_UNSUPPORTEDMEDIATYPE = 4016;
    const C_INVALIDMEDIATYPE = 4017;
    const C_FILESIZELIMITEXCEEDED = 4018;
    const C_INVALIDIMAGE = 4019;
    const C_IMAGEALREADYLINKED = 4020;
    const C_ITEMIDMISMATCH = 4021;
    const C_INVALIDFILENAMELENGTH = 4022;

    /**
     * MTCC related error code
     */
    const C_REQUIREDPARAMETERSNOTFOUND = 4023;
    const C_NOCLASSIFICATIONSFOUND = 4024;

    /**
     * Error string from the service unknown
     */
    const C_UNEXPECTEDERROR = -1;

}

/**
 * Swagger Name: AvaTaxClient
 * Severity of message
 */
class SeverityLevel
{
    /**
     * Operation succeeded
     */
    const C_SUCCESS = 0;

    /**
     * Warnings occured, operation succeeded
     */
    const C_WARNING = 1;

    /**
     * Errors occured, operation failed
     */
    const C_ERROR = 2;

    /**
     * Unexpected exceptions occurred, operation failed
     */
    const C_EXCEPTION = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates what level of auditing information is available for a transaction
 */
class ApiCallStatus
{
    /**
     * If the original api call is availabe on S3
     */
    const C_ORIGINALAPICALLAVAILABLE = 0;

    /**
     * if the original api call is not available, reconstructed api call should always be available
     */
    const C_RECONSTRUCTEDAPICALLAVAILABLE = 1;

    /**
     * Any other api call status
     */
    const C_ANY = -1;

}

/**
 * Swagger Name: AvaTaxClient
 * A list of possible AvaFile Form Types.
 */
class FormTypeId
{
    /**
     * Denotes the form type is Sales and Use Tax
     */
    const C_SALESANDUSE = 0;

    /**
     * Denotes the form type is Sales Tax only
     */
    const C_SALES = 1;

    /**
     * Denotes the form type is Sellers Use Tax only
     */
    const C_SELLERSUSE = 2;

    /**
     * Denotes the form type is Lodging Tax only
     */
    const C_LODGING = 3;

    /**
     * Denotes the form type is Sales and Lodging Tax
     */
    const C_SALESANDLODGING = 4;

    /**
     * Denotes the form type is Consumer Use Tax only
     */
    const C_CONSUMERUSE = 5;

    /**
     * Denotes the form type is Resort and Rental Tax
     */
    const C_RESORTANDRENTAL = 6;

    /**
     * Denotes the form type is Tourist and Rental Tax
     */
    const C_TOURISTANDRENTAL = 7;

    /**
     * Denotes the form type is Prepayment
     */
    const C_PREPAYMENT = 8;

    /**
     * Denotes the form type is Prepayment Allowance
     */
    const C_PREPAYMENTALLOWED = 9;

}

/**
 * Swagger Name: AvaTaxClient
 * A list of possible AvaFile filing option types.
 */
class FilingOptionTypeId
{
    /**
     * Denotes the tax return is being filed on paper.
     */
    const C_PAPER = 0;

    /**
     * Denotes the form can be efiled optionally.
     */
    const C_OPTIONALEFILE = 1;

    /**
     * Denotes the form is being filed via efile.
     */
    const C_MANDATORYEFILE = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * A list of possible Due Date Types
 */
class DueDateTypeId
{
    /**
     * Denotes form is due on the due day
     */
    const C_BYDAY = 0;

    /**
     * Denotes form is due by last day of the month
     */
    const C_BYLASTDAY = 1;

    /**
     * Denotes form is due by second to last day of the month
     */
    const C_BYSECONDLASTDAY = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates the rounding behavior of a form
 */
class RoundingTypeId
{
    /**
     * There is no rounding on the return
     */
    const C_NONE = 0;

    /**
     * Round to the nearest whole number
     */
    const C_NEAREST = 1;

    /**
     * Always round up
     */
    const C_UP = 2;

    /**
     * Always round down
     */
    const C_DOWN = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates the behavior of a tax form for a company with multiple places of business.
 *  
 *  Some tax authorities require that a separate form must be filed for each place of business.
 */
class OutletTypeId
{
    /**
     * File a single return per cycle for your entire business.
     */
    const C_NONE = 0;

    /**
     * You may file separate forms for each outlet; contact the tax authority for more details about location based reporting requirements.
     */
    const C_SCHEDULE = 1;

    /**
     * You may file separate forms for each outlet; contact the tax authority for more details about location based reporting requirements.
     */
    const C_DUPLICATE = 2;

    /**
     * File a single return, but you must have a line item for each place of business.
     */
    const C_CONSOLIDATED = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * The type of data contained in this batch
 */
class BatchType
{    const C_AVACERTUPDATE = 0;
    const C_AVACERTUPDATEALL = 1;
    const C_BATCHMAINTENANCE = 2;
    const C_COMPANYLOCATIONIMPORT = 3;
    const C_DOCUMENTIMPORT = 4;
    const C_EXEMPTCERTIMPORT = 5;
    const C_ITEMIMPORT = 6;
    const C_SALESAUDITEXPORT = 7;
    const C_SSTPTESTDECKIMPORT = 8;
    const C_TAXRULEIMPORT = 9;

    /**
     * This batch type represents tax transaction data being uploaded to AvaTax. Each line in the batch represents a single transaction
     *  or a line in a multi-line transaction. For reference, see [Batched Transactions in REST v2](http://developer.avalara.com/blog/2016/10/24/batch-transaction-upload-in-rest-v2)
     */
    const C_TRANSACTIONIMPORT = 10;
    const C_UPCBULKIMPORT = 11;
    const C_UPCVALIDATIONIMPORT = 12;
    const C_CUSTOMERSUPPLIERIMPORT = 13;
    const C_VARIANCEIMPORT = 14;
    const C_COSTCENTERIMPORT = 15;
    const C_GLACCOUNTIMPORT = 16;
    const C_ADVANCEDRULESIMPORT = 17;
    const C_ITEMIMPORTV2 = 18;

}

/**
 * Swagger Name: AvaTaxClient
 * The status of a batch file
 */
class BatchStatus
{
    /**
     * Batch file has been received and is in the queue to be processed.
     */
    const C_WAITING = 0;

    /**
     * Batch file experienced system errors and cannot be processed.
     */
    const C_SYSTEMERRORS = 1;

    /**
     * Batch file is cancelled
     */
    const C_CANCELLED = 2;

    /**
     * Batch file has been completely processed.
     */
    const C_COMPLETED = 3;

    /**
     * Batch file is currently being created.
     */
    const C_CREATING = 4;

    /**
     * Batch file has been deleted.
     */
    const C_DELETED = 5;

    /**
     * Batch file was processed with some errors.
     */
    const C_ERRORS = 6;

    /**
     * Batch processing was paused.
     */
    const C_PAUSED = 7;

    /**
     * Batch is currently being processed.
     */
    const C_PROCESSING = 8;

    /**
     * Batch is currently being cancelled.
     */
    const C_CANCELLING = 9;

}

/**
 * Swagger Name: AvaTaxClient
 * Reason code for voiding or cancelling a transaction
 */
class VoidReasonCode
{
    /**
     * Unspecified reason
     */
    const C_UNSPECIFIED = 0;

    /**
     * Post operation failed - Document status will be changed to unposted
     */
    const C_POSTFAILED = 1;

    /**
     * Document deleted - If committed, document status will be changed to Cancelled. If not committed, document will be
     *  deleted.
     */
    const C_DOCDELETED = 2;

    /**
     * Document has been voided and DocStatus will be set to Cancelled
     */
    const C_DOCVOIDED = 3;

    /**
     * AdjustTax operation has been cancelled. Adjustment will be reversed.
     */
    const C_ADJUSTMENTCANCELLED = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * The way of delivering request
 */
class CertificateRequestDeliveryMethod
{
    /**
     * The invitation will be sent via email to the recipient's email address.
     */
    const C_EMAIL = 1;

    /**
     * The invitation will be sent via facsimile to the recipient's facsimile phone number.
     *  
     *  Facsimile transmission make take time to process and deliver via phone lines.
     */
    const C_FAX = 2;

    /**
     * The request will be processed and turned into a web link (URL) which the user can click on to visit the CertExpress site and immediately
     *  begin entering data about their certificates.
     */
    const C_DOWNLOAD = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates the status of a CertExpress invitation link.
 */
class CertExpressInvitationStatus
{
    /**
     * The CertExpress website is currently building a landing page for the customer. Please
     *  wait about 10 seconds and fetch this request again to see when it will be ready.
     */
    const C_INPROGRESS = 0;

    /**
     * Indicates that the CertExpress invitation has been completed and is ready to use.
     */
    const C_READY = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class CertificateEcmStatus
{    const C_NONE = 0;
    const C_EXPIRED = 1;
    const C_INVALID = 2;
    const C_VALID = 3;
    const C_PENDINGFUTURE = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * Visibility for a parameter.
 */
class Visibility
{
    /**
     * Denotes the Parameter is required
     */
    const C_REQUIRED = 0;

    /**
     * Denotes the Parameter is recommended
     */
    const C_RECOMMENDED = 1;

    /**
     * Denotes the Parameter is optional
     */
    const C_OPTIONAL = 2;

    /**
     * Denotes the Parameter is conditional
     */
    const C_CONDITIONAL = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Choice of rounding level for a transaction
 */
class RoundingLevelId
{
    /**
     * Round tax on each line separately
     */
    const C_LINE = 0;

    /**
     * Round tax at the document level
     */
    const C_DOCUMENT = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * TaxDependencyLevelId
 */
class TaxDependencyLevelId
{
    /**
     * Document
     */
    const C_DOCUMENT = 0;

    /**
     * State
     */
    const C_STATE = 1;

    /**
     * TaxRegion
     */
    const C_TAXREGION = 2;

    /**
     * Address
     */
    const C_ADDRESS = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class UserDefinedFieldDataType
{
    /**
     * Represents String dataType
     */
    const C_STRING = 0;

    /**
     * Represents Number dataType
     */
    const C_NUMBER = 1;

    /**
     * Represents Date dataType
     */
    const C_DATE = 2;

    /**
     * Represents Boolean dataType
     */
    const C_BOOLEAN = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Service modes for tax calculation when using an AvaLocal server.
 */
class ServiceMode
{
    /**
     * Automatically use local or remote (default)
     */
    const C_AUTOMATIC = 0;

    /**
     * Local server only
     */
    const C_LOCAL = 1;

    /**
     * Remote server only
     */
    const C_REMOTE = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates the level of detail requested from a tax API call
 */
class TaxDebugLevel
{
    /**
     * User requests the normal level of debug information when creating a tax transaction
     */
    const C_NORMAL = 0;

    /**
     * User requests additional diagnostic information when creating a tax transaction
     */
    const C_DIAGNOSTIC = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class DeliveryTerms
{
    /**
     * Delivery At Place (DAP) implies that Duty And Tax will be paid by the Buyer or Consignee of the shipment
     */
    const C_DAP = 1;

    /**
     * Delivery Duty Paid (DDP) implies that Duty And Tax will be paid by the Shipper
     */
    const C_DDP = 2;

    /**
     * Free on Board
     */
    const C_FOB = 3;

    /**
     * Free Carrier
     */
    const C_FCA = 4;

    /**
     * Free Alongside Ship
     */
    const C_FAS = 5;

    /**
     * Ex Works
     */
    const C_EXW = 6;

    /**
     * Delivered at Place Unloaded
     */
    const C_DPU = 7;

    /**
     * Carriage Paid To
     */
    const C_CPT = 8;

    /**
     * Carriage Insurance Paid To
     */
    const C_CIP = 9;

    /**
     * Cost, Insurance, and Freight
     */
    const C_CIF = 10;

    /**
     * Cost And Freight
     */
    const C_CFR = 11;

}

/**
 * Swagger Name: AvaTaxClient
 * The status of a custom rule as returned by the custom rule summary endpoint.
 */
class CustomRuleStatus
{
    /**
     * The status of the rule is unknown.
     */
    const C_UNKNOWN = 0;

    /**
     * The rule is enabled and effective on the current date.
     */
    const C_ACTIVE = 1;

    /**
     * The rule is not enabled.
     */
    const C_INACTIVE = 2;

    /**
     * The rule is marked enabled, but it is past the end date of the rule.
     */
    const C_EXPIRED = 3;

    /**
     * The rule is marked enabled, but it is before the first effective date of the rule.
     */
    const C_FUTURE = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * The type of a custom rule
 */
class CustomRuleType
{
    /**
     * An unknown rule type.
     */
    const C_UNKNOWN = 0;

    /**
     * A tax rule.
     */
    const C_TAXRULE = 1;

    /**
     * An advanced rule.
     */
    const C_ADVANCEDRULE = 2;

    /**
     * A dynamic rule.
     */
    const C_DYNAMICRULE = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * The subtype of a custom rule
 */
class CustomRuleSubtype
{
    /**
     * The unknown rule type
     */
    const C_UNKNOWN = 0;

    /**
     * A product taxability tax rule
     */
    const C_PRODUCTTAXABILITYRULE = 1;

    /**
     * An exempt entity tax rule
     */
    const C_EXEMPTENTITYRULE = 2;

    /**
     * A rate override tax rule
     */
    const C_RATEOVERRIDERULE = 3;

    /**
     * A base override tax rule
     */
    const C_BASEOVERRIDERULE = 4;

    /**
     * A Marketplace advanced rule
     */
    const C_MARKETPLACE = 5;

    /**
     * A Bundled Items Allocation advanced rule
     */
    const C_BUNDLEDITEMSALLOCATION = 6;

    /**
     * A Multiple Points of Use Allocation advanced rule
     */
    const C_MULTIPLEPOINTSOFUSEALLOCATION = 7;

    /**
     * A Find and Replace Before Calculationadvanced rule
     */
    const C_FINDANDREPLACEBEFORECALCULATION = 8;

    /**
     * A Find and Replace After Calculation advanced rule
     */
    const C_FINDANDREPLACEAFTERCALCULATION = 9;

    /**
     * A Reporting Location advanced rule
     */
    const C_REPORTINGLOCATION = 10;

    /**
     * A Seller Remits Aggregator advanced rule
     */
    const C_SELLERREMITSAGGREGATOR = 11;

    /**
     * A Consumer Use Allocation advanced rule
     */
    const C_CONSUMERUSEALLOCATION = 12;

    /**
     * A Find and Replace Jurisdiction Match advanced rule
     */
    const C_FINDANDREPLACEJURISDICTIONMATCH = 13;

    /**
     * Updates a transaction field with a value.
     */
    const C_UPDATEFIELD = 14;

    /**
     * Copies a value from one field to another.
     */
    const C_COPYFIELD = 15;

    /**
     * Updates address-related fields.
     */
    const C_UPDATEADDRESS = 16;

    /**
     * Copies address values between address types.
     */
    const C_COPYADDRESS = 17;

    /**
     * Updates a parameter value.
     */
    const C_UPDATEPARAMETER = 18;

    /**
     * Updates a user-defined field value.
     */
    const C_UPDATEUSERDEFINEDFIELD = 19;

    /**
     * Updates a tax override value.
     */
    const C_UPDATETAXOVERRIDE = 20;

    /**
     * Updates the location code.
     */
    const C_UPDATELOCATIONCODE = 21;

    /**
     * Updates the marketplace location code.
     */
    const C_UPDATEMARKETPLACE = 22;

    /**
     * Allocates values based on a field.
     */
    const C_ALLOCATEBYFIELD = 23;

    /**
     * Allocates values based on an address.
     */
    const C_ALLOCATEBYADDRESS = 24;

    /**
     * Allocates consumer use tax.
     */
    const C_ALLOCATECONSUMERUSE = 25;

    /**
     * Aggregates line values post-allocation.
     */
    const C_AGGREGATELINES = 26;

    /**
     * Overrides the tax rate.
     */
    const C_TAXRULERATEOVERRIDE = 27;

    /**
     * Overrides the taxable base.
     */
    const C_TAXRULEBASEOVERRIDE = 28;

    /**
     * Overrides product taxability.
     */
    const C_TAXRULEPRODUCTTAXABILITY = 29;

    /**
     * Updates an exemption stauts.
     */
    const C_TAXRULEEXEMPTENTITY = 30;

}

/**
 * Swagger Name: AvaTaxClient
 * Filing Frequency types
 */
class FilingFrequencyId
{
    /**
     * File once per month
     */
    const C_MONTHLY = 1;

    /**
     * File once per three months
     */
    const C_QUARTERLY = 2;

    /**
     * File twice per year
     */
    const C_SEMIANNUALLY = 3;

    /**
     * File once per year
     */
    const C_ANNUALLY = 4;

    /**
     * File every other month
     */
    const C_BIMONTHLY = 5;

    /**
     * File only when there are documents to report
     */
    const C_OCCASIONAL = 6;

    /**
     * File for the first two months of each quarter, then do not file on the quarterly month.
     */
    const C_INVERSEQUARTERLY = 7;

    /**
     * File every week
     */
    const C_WEEKLY = 8;

}

/**
 * Swagger Name: AvaTaxClient
 * Status when deleting an error transaction
 */
class AvataxDeleteErrorTransactionStatus
{
    /**
     * Successful delete
     */
    const C_SUCCESS = 0;

    /**
     * Failed delete
     */
    const C_FAILURE = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * Jurisdiction Type
 */
class JurisdictionType
{
    /**
     * Country
     */
    const C_COUNTRY = 0;

    /**
     * State
     */
    const C_STATE = 1;

    /**
     * County
     */
    const C_COUNTY = 2;

    /**
     * City
     */
    const C_CITY = 3;

    /**
     * Special Tax Jurisdiction
     */
    const C_SPECIAL = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * Represents the type of component in a dynamic rule.
 */
class DynamicRuleComponentType
{
    /**
     * Unknown component type.
     */
    const C_UNKNOWN = 0;

    /**
     * A condition component that evaluates an expression and returns boolean results.
     */
    const C_CONDITION = 1;

    /**
     * An action component that executes a specific operation when a rule is triggered.
     */
    const C_ACTION = 2;

    /**
     * A variable component that defines a named value that can be referenced within rules.
     */
    const C_VARIABLE = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Identifier for the specific varieties of component behavior.
 *  The subtype determines the expected format of a component's data property.
 */
class DynamicRuleComponentSubtype
{
    /**
     * An unknown or uninitialized subtype.
     */
    const C_UNKNOWN = 0;

    /**
     * Unspecified condition.
     */
    const C_CONDITION = 1;

    /**
     * Compares two arbitrary expressions.
     */
    const C_MATCHEXPRESSION = 2;

    /**
     * Compares a field against one or more specific values.
     */
    const C_MATCHFIELD = 3;

    /**
     * Matches based on the customer code.
     */
    const C_MATCHCUSTOMERCODE = 4;

    /**
     * Matches based on the document type.
     */
    const C_MATCHDOCUMENTTYPE = 5;

    /**
     * Matches based on a user-defined field.
     */
    const C_MATCHUSERDEFINEDFIELD = 6;

    /**
     * Matches based on a parameter.
     */
    const C_MATCHPARAMETER = 7;

    /**
     * Matches based on tax override information.
     */
    const C_MATCHTAXOVERRIDE = 8;

    /**
     * Matches based on address information.
     */
    const C_MATCHADDRESS = 9;

    /**
     * Matches based on the tariff code.
     */
    const C_MATCHTARIFFCODE = 10;

    /**
     * Matches based on the tax code.
     */
    const C_MATCHTAXCODE = 11;

    /**
     * Matches based on jurisdiction and tax applicability.
     */
    const C_MATCHTAX = 12;

    /**
     * Unspecified action.
     */
    const C_ACTION = 256;

    /**
     * Updates a transaction field with a value.
     */
    const C_UPDATEFIELD = 257;

    /**
     * Copies a value from one field to another.
     */
    const C_COPYFIELD = 258;

    /**
     * Updates address-related fields.
     */
    const C_UPDATEADDRESS = 259;

    /**
     * Copies address values between address types.
     */
    const C_COPYADDRESS = 260;

    /**
     * Updates a parameter value.
     */
    const C_UPDATEPARAMETER = 261;

    /**
     * Updates a user-defined field value.
     */
    const C_UPDATEUSERDEFINEDFIELD = 262;

    /**
     * Updates a tax override value.
     */
    const C_UPDATETAXOVERRIDE = 263;

    /**
     * Updates the location code.
     */
    const C_UPDATELOCATIONCODE = 264;

    /**
     * Updates the marketplace location code.
     */
    const C_UPDATEMARKETPLACE = 265;

    /**
     * Allocates values based on a field.
     */
    const C_ALLOCATEBYFIELD = 266;

    /**
     * Allocates values based on an address.
     */
    const C_ALLOCATEBYADDRESS = 267;

    /**
     * Allocates consumer use tax.
     */
    const C_ALLOCATECONSUMERUSE = 268;

    /**
     * Aggregates line values post-allocation.
     */
    const C_AGGREGATELINES = 269;

    /**
     * Overrides the tax rate.
     */
    const C_TAXRULERATEOVERRIDE = 270;

    /**
     * Overrides the taxable base.
     */
    const C_TAXRULEBASEOVERRIDE = 271;

    /**
     * Overrides product taxability.
     */
    const C_TAXRULEPRODUCTTAXABILITY = 272;

    /**
     * Updates an exemption stauts.
     */
    const C_TAXRULEEXEMPTENTITY = 273;

    /**
     * Unspecified variable.
     */
    const C_VARIABLE = 512;

    /**
     * Named expression.
     */
    const C_EXPRESSION = 513;

    /**
     * Named aggregation computation.
     */
    const C_AGGREGATION = 514;

}

/**
 * Swagger Name: AvaTaxClient
 * Exempt Cert type
 */
class ExemptCertTypeId
{
    /**
     * Blanked certificate
     */
    const C_BLANKET = 0;

    /**
     * Single use
     */
    const C_SINGLEUSE = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * Status for this exempt certificate
 */
class ExemptCertStatusId
{
    /**
     * Inactive certificate
     */
    const C_INACTIVE = 0;

    /**
     * Active certificate
     */
    const C_ACTIVE = 1;

    /**
     * Expired certificate
     */
    const C_EXPIRED = 2;

    /**
     * Revoked certificate
     */
    const C_REVOKED = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Exempt certificate review status
 */
class ExemptCertReviewStatusId
{
    /**
     * Review pending
     */
    const C_PENDING = 0;

    /**
     * Certificate was accepted
     */
    const C_ACCEPTED = 1;

    /**
     * Certificate was rejected
     */
    const C_REJECTED = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Different types of formats allowed for exporting a report
 */
class ReportFormat
{
    /**
     * The Comma Separated Values file format
     */
    const C_CSV = 0;

}

/**
 * Swagger Name: AvaTaxClient
 * The date filter type for report
 *  "RD" for Reporting Date, "DD" for Document Date, "TD" for Tax Date, "PD" for Payment Date
 */
class ReportDateFilter
{
    /**
     * The date when the transaction is posted
     */
    const C_DOCUMENTDATE = 68;

    /**
     * The date when the transaction is modified
     */
    const C_MODIFIEDDATE = 77;

    /**
     * The date when the transaction is paid for
     */
    const C_PAYMENTDATE = 80;

    /**
     * The date when the transaction is added to report
     */
    const C_REPORTINGDATE = 82;

    /**
     * The date when the transaction is being taxed
     */
    const C_TAXDATE = 84;

}

/**
 * Swagger Name: AvaTaxClient
 * The output DocumentType for a report
 */
class ReportDocType
{
    /**
     * Output all ConsumerUse tax transactions in the report
     */
    const C_CONSUMERUSE = 67;

    /**
     * Output all Sales tax transactions in the report
     */
    const C_SALES = 83;

}

/**
 * Swagger Name: AvaTaxClient
 * The `DocumentStatus` value indicates the state of the document as it moves through the
 *  AvaTax document workflow. More information about the AvaTax document workflow is available
 *  in the [AvaTax Developer Guide](https://developer.avalara.com/avatax/dev-guide/transactions/should-i-commit).
 */
class DocumentStatus
{
    /**
     * Temporary document not saved (SalesOrder, PurchaseOrder).
     *  
     *  This document has not been recorded to AvaTax
     */
    const C_TEMPORARY = 0;

    /**
     * Saved document (SalesInvoice or PurchaseInvoice) ready to be posted.
     *  
     *  This status indicates that the transaction has been saved to AvaTax, but is not available
     *  to be reported on a tax filing, and has not yet been verified by a business process that
     *  posts transactions.
     *  
     *  To mark this transaction as `Posted`, please call `VerifyTransaction` or `SettleTransaction`.
     *  
     *  To mark this transaction as `Committed`, please call `CommitTransaction` or `SettleTransaction`.
     *  
     *  To adjust or void this transaction, call `AdjustTransaction`, `CreateOrAdjustTransaction`, or
     *  `VoidTransaction`.
     */
    const C_SAVED = 1;

    /**
     * A posted document (not committed).
     *  
     *  This status indicates that the transaction has been saved to AvaTax, and has been verified
     *  by a business process that posts transactions, but is not ready to report on a tax filing.
     *  
     *  To mark this transaction as `Committed`, please call `CommitTransaction` or `SettleTransaction`.
     *  
     *  To adjust or void this transaction, call `AdjustTransaction`, `CreateOrAdjustTransaction`, or
     *  `VoidTransaction`.
     */
    const C_POSTED = 2;

    /**
     * A posted document that has been committed.
     *  
     *  This status indicates that the transaction has been saved to AvaTax and can be reported
     *  on a tax filing.
     *  
     *  If you use Avalara's Managed Returns Service, these transactions will be captured and reported
     *  on a tax return. When this occurs, the transaction's `locked` flag will be set to true. Once
     *  the transaction is locked, no further changes may occur.
     *  
     *  As long as the transaction has not been locked, you may adjust or void this transaction using
     *  `AdjustTransaction`, `CreateOrAdjustTransaction`, or `VoidTransaction`.
     */
    const C_COMMITTED = 3;

    /**
     * A document that has been cancelled.
     *  
     *  This status indicates that the transaction has been cancelled or voided. Cancelled and Voided
     *  are synonyms.
     *  
     *  When a transaction has been cancelled, it is considered to no longer exist. You are free to create
     *  a new transaction with the same code.
     */
    const C_CANCELLED = 4;

    /**
     * An older version of a document that has been adjusted.
     *  
     *  When you call `AdjustTransaction`, AvaTax preserves a record of the old document as well as a record
     *  of the new document. The old document is changed to the status `Adjusted`, and the new document
     *  is created in the status you requested.
     */
    const C_ADJUSTED = 5;

    /**
     * DEPRECATED - A document which is queued for later processing.
     */
    const C_QUEUED = 6;

    /**
     * Indicates that this document requires approval from a governmental agency before it can be finalized.
     *  
     *  Some governments require active verification of transactions before they can be finalized. When AvaTax
     *  detects that a transaction must be verified with a governmental agency, this transaction will be flagged
     *  as `PendingApproval` until the government has certified the transaction.
     */
    const C_PENDINGAPPROVAL = 7;

    /**
     * This new status is added for Reporting API to download get reports with Saved(1) and Posted(2) state.
     */
    const C_UNCOMMITTED = 12;

    /**
     * DEPRECATED - Represents "a document in any status" when searching. Please search using the
     *  [Filtering in REST](/avatax/filtering-in-rest/) documentation.
     */
    const C_ANY = -1;

}

/**
 * Swagger Name: AvaTaxClient
 * Defines report source.
 */
class ReportSource
{
    /**
     * snowflake
     */
    const C_SNOWFLAKE = 0;

    /**
     * mongodb
     */
    const C_MONGODB = 1;

    /**
     * returns api
     */
    const C_RETURNSAPI = 2;

    /**
     * tax region and tax type
     */
    const C_TAXREGION = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Defines compression
 */
class Compression
{
    /**
     * none
     */
    const C_NONE = 0;

    /**
     * gzip
     */
    const C_GZIP = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class AdjustmentPeriodTypeId
{    const C_NONE = 0;
    const C_CURRENTPERIOD = 1;
    const C_NEXTPERIOD = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class PaymentAccountTypeId
{    const C_NONE = 0;
    const C_ACCOUNTSRECEIVABLEACCOUNTSPAYABLE = 1;
    const C_ACCOUNTSRECEIVABLE = 2;
    const C_ACCOUNTSPAYABLE = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * A list of possible AvaFile filing types.
 */
class FilingTypeId
{
    /**
     * Denotes the tax return is being filed on paper.
     */
    const C_PAPERRETURN = 0;

    /**
     * Denotes the tax return is being filed via electronic means; excludes SST electronic filing.
     */
    const C_ELECTRONICRETURN = 1;

    /**
     * Denotes the tax return is an SST filing.
     */
    const C_SER = 2;

    /**
     * Denotes a return is paid via EFT and filed on paper without payment.
     */
    const C_EFTPAPER = 3;

    /**
     * Denotes a return is paid via phone and filed on paper without payment.
     */
    const C_PHONEPAPER = 4;

    /**
     * Denotes a return is prepared but delivered to the customer for filing and payment.
     */
    const C_SIGNATUREREADY = 5;

    /**
     * Denotes a return which is filed online but paid by check.
     */
    const C_EFILECHECK = 6;

}

/**
 * Swagger Name: AvaTaxClient
 * This data type is only used when an object must "Match" tax types. By specifying options here,
 *  you can indicate which tax types will match for the purposes of this object.
 *  For example, if you specify BothSalesAndUseTax, this value matches with both sales and seller's use tax.
 */
class MatchingTaxType
{
    /**
     * Match medical excise type
     */
    const C_E = 5;

    /**
     * Match Lodging tax type
     */
    const C_LODGING = 6;

    /**
     * Match bottle tax type
     */
    const C_BOTTLE = 7;

    /**
     * Match RentToOwn tax type
     */
    const C_RENTTOOWN = 8;

    /**
     * BikeTax tax type
     */
    const C_BIKETAX = 11;

    /**
     * LandedCost tax type
     */
    const C_LANDEDCOST = 12;

    /**
     * CheckoutBag tax type
     */
    const C_CHECKOUTBAG = 13;

    /**
     * Alcohol tax type
     */
    const C_ALCOHOL = 17;

    /**
     * Amusement tax type
     */
    const C_AMUSEMENT = 20;

    /**
     * Hospitality tax type
     */
    const C_HOSPITALITY = 21;

    /**
     * RentalLeasing tax type
     */
    const C_RENTALLEASING = 23;

    /**
     * GrossReceipts tax type
     */
    const C_GROSSRECEIPTS = 24;

    /**
     * Mattress tax type
     */
    const C_MATTRESS = 25;

    /**
     * Lumber tax type
     */
    const C_LUMBER = 27;

    /**
     * Paint tax type
     */
    const C_PAINT = 28;

    /**
     * Tires tax type
     */
    const C_TIRES = 29;

    /**
     * Economic Incentive tax type
     */
    const C_EI = 30;

    /**
     * Match all tax types
     */
    const C_ALL = 65;

    /**
     * Match both Sales and Use Tax only
     */
    const C_BOTHSALESANDUSETAX = 66;

    /**
     * Match Consumer Use Tax only
     */
    const C_CONSUMERUSETAX = 67;

    /**
     * Match both Consumer Use and Seller's Use Tax types
     */
    const C_CONSUMERSUSEANDSELLERSUSETAX = 68;

    /**
     * Match both Consumer Use and Sales Tax types
     */
    const C_CONSUMERUSEANDSALESTAX = 69;

    /**
     * Match Fee tax types only
     */
    const C_FEE = 70;

    /**
     * Match VAT Input Tax only
     */
    const C_VATINPUTTAX = 73;

    /**
     * LightBulbs tax type
     */
    const C_LIGHTBULBS = 76;

    /**
     * Meals tax type
     */
    const C_MEALS = 77;

    /**
     * Match VAT Nonrecoverable Input Tax only
     */
    const C_VATNONRECOVERABLEINPUTTAX = 78;

    /**
     * Match VAT Output Tax only
     */
    const C_VATOUTPUTTAX = 79;

    /**
     * PIF tax type
     */
    const C_PIF = 80;

    /**
     * Match Rental tax types only
     */
    const C_RENTAL = 82;

    /**
     * Match Sales Tax only
     */
    const C_SALESTAX = 83;

    /**
     * Match Seller's Use Tax only
     */
    const C_USETAX = 85;

    /**
     * EWaste tax type
     */
    const C_EWASTE = 87;

    /**
     * Batteries tax type
     */
    const C_BATTERIES = 90;

}

/**
 * Swagger Name: AvaTaxClient
 * A list of bulk account validation statuses for filing calendars.
 */
class BulkAccountValidationStatus
{    const C_NEW = 0;
    const C_ADDED = 1;
    const C_FAILED = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Filing worksheet Type
 */
class WorksheetTypeId
{
    /**
     * The original filing for a period
     */
    const C_ORIGINAL = 0;

    /**
     * Represents an amended filing for a period
     */
    const C_AMENDED = 1;

    /**
     * Represents a test filing
     */
    const C_TEST = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates the type of payments
 */
class PaymentType
{
    /**
     * The payment is for the current payment
     */
    const C_CURRENTPERIOD = 0;

    /**
     * The payment is a prepayment
     */
    const C_PREPAYMENT = 1;

    /**
     * The payment is a prior payment
     */
    const C_PRIORPAYMENT = 2;

    /**
     * The payment is a prior CSP fee
     */
    const C_PRIORCSPFEE = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Filing Status
 */
class FilingStatusId
{    const C_PENDINGAPPROVAL = 0;
    const C_DIRTY = 1;
    const C_APPROVEDTOFILE = 2;
    const C_PENDINGFILING = 3;
    const C_PENDINGFILINGONBEHALF = 4;
    const C_FILED = 5;
    const C_FILEDONBEHALF = 6;
    const C_RETURNACCEPTED = 7;
    const C_RETURNACCEPTEDONBEHALF = 8;
    const C_PAYMENTREMITTED = 9;
    const C_VOIDED = 10;
    const C_PENDINGRETURN = 11;
    const C_PENDINGRETURNONBEHALF = 12;
    const C_DONOTFILE = 13;
    const C_RETURNREJECTED = 14;
    const C_RETURNREJECTEDONBEHALF = 15;
    const C_APPROVEDTOFILEONBEHALF = 16;
    const C_FILEDBYCUSTOMER = 17;

}

/**
 * Swagger Name: AvaTaxClient
 * Filing Request Status types
 */
class FilingRequestStatus
{
    /**
     * Customer is building a request for a new filing calendar
     */
    const C_NEW = 1;

    /**
     * Customer’s information validated before submitting to go live. All required information as per state and form selection is entered.
     */
    const C_VALIDATED = 2;

    /**
     * Customer submitted a request for a new filing calendar
     */
    const C_PENDING = 3;

    /**
     * Filing calender is active
     */
    const C_ACTIVE = 4;

    /**
     * Customer requested to deactivate filing calendar
     */
    const C_PENDINGSTOP = 5;

    /**
     * Filing calendar is inactive
     */
    const C_INACTIVE = 6;

    /**
     * This indicates that there is a new change request.
     */
    const C_CHANGEREQUEST = 7;

    /**
     * This indicates that the change request was approved.
     */
    const C_REQUESTAPPROVED = 8;

    /**
     * This indicates that compliance rejected the request.
     */
    const C_REQUESTDENIED = 9;

}

/**
 * Swagger Name: AvaTaxClient
 * Accrual types
 */
class AccrualType
{
    /**
     * Filing indicates that this tax return should be filed with its tax authority by its due date. For example, if you file annually, you will have eleven months of Accrual returns and one Filing return.
     */
    const C_FILING = 1;

    /**
     * An Accrual filing indicates taxes that are accrued, intended to be filed on a future tax return. For example, if you file annually, you will have eleven months of Accrual returns and one Filing return.
     */
    const C_ACCRUAL = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates whether Avalara Managed Returns has begun filing for this company.
 */
class CompanyFilingStatus
{
    /**
     * This company has not been configured for compliance
     */
    const C_NOTCONFIGUREDFORCOMPLIANCE = 0;

    /**
     * This company is a reporting entity, but Avalara is not currently filing tax returns for this company.
     */
    const C_NOTYETFILING = 1;

    /**
     * The customer has requested that Avalara Managed Returns begin filing for this company, however filing has
     *  not yet started. Avalara's compliance team is reviewing this request and will update the company to
     *  first filing status when complete.
     */
    const C_FILINGREQUESTED = 2;

    /**
     * Avalara has begun filing tax returns for this company. Normally, this status will change to `Active` after
     *  one month of successful filing of tax returns.
     */
    const C_FIRSTFILING = 3;

    /**
     * Avalara currently files tax returns for this company.
     */
    const C_ACTIVE = 4;

    /**
     * This company is not a reporting entity and cannot file taxes. To change this behavior, you must mark
     *  the company as a reporting entity.
     */
    const C_NOREPORTING = 5;

    /**
     * This company is inactive
     */
    const C_INACTIVE = 6;

}

/**
 * Swagger Name: AvaTaxClient
 * Account Linkage status
 */
class FirmClientLinkageStatus
{
    /**
     * Requested
     */
    const C_REQUESTED = 1;

    /**
     * Approved
     */
    const C_APPROVED = 2;

    /**
     * Rejected
     */
    const C_REJECTED = 3;

    /**
     * Revoked
     */
    const C_REVOKED = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class ItemCatalogueResultEvent
{    const C_ITEMCREATED = 0;
    const C_ITEMUPDATED = 1;
    const C_ITEMDELETED = 2;
    const C_ERROR = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Jurisdiction boundary precision level found for address. This depends on the accuracy of the address
 *  as well as the precision level of the state provided jurisdiction boundaries.
 */
class BoundaryLevel
{
    /**
     * Street address precision
     */
    const C_ADDRESS = 0;

    /**
     * 9-digit zip precision
     */
    const C_ZIP9 = 1;

    /**
     * 5-digit zip precision
     */
    const C_ZIP5 = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Defines returns liability type.
 */
class ReturnsLiabilityType
{
    /**
     * all
     */
    const C_ALL = 0;

    /**
     * original
     */
    const C_ORIGINAL = 1;

    /**
     * amend
     */
    const C_AMENDED = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Defines returns report type.
 */
class ReturnsReportType
{
    /**
     * liability summary return detail hospitality
     */
    const C_LIABILITYSUMMARYRETURNDETAILHOSPITALITY = 0;

    /**
     * liability summary return detail
     */
    const C_LIABILITYSUMMARYRETURNDETAIL = 1;

    /**
     * liability carry over credit
     */
    const C_LIABILITYCARRYOVERCREDIT = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * This field will identify who is remitting the tax - Marketplace or Seller.
 */
class MarketplaceLiabilityType
{
    /**
     * MarketPlace
     */
    const C_MARKETPLACE = 1;

    /**
     * Seller
     */
    const C_SELLER = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates whether this address refers to a person or an business
 */
class AddressTypeId
{
    /**
     * A business location, for example a store, warehouse, or office.
     */
    const C_LOCATION = 1;

    /**
     * A person's address who performs sales tasks for the company remotely from an office.
     */
    const C_SALESPERSON = 2;

    /**
     * This location is a marketplace vendor that handles transactions on behalf of the company.
     *  When you select `Marketplace` as the address type for a location, you must then choose either
     *  `SellerRemitsTax` or `MarketplaceRemitsTax` to indicate which business entity is responsible
     *  for collecting and remitting tax for this location.
     */
    const C_MARKETPLACE = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * The type of address represented by this object
 */
class AddressCategoryId
{
    /**
     * Address refers to a storefront location
     */
    const C_STOREFRONT = 1;

    /**
     * Address refers to a main office of this company
     */
    const C_MAINOFFICE = 2;

    /**
     * Address refers to a warehouse or other non-public location
     */
    const C_WAREHOUSE = 3;

    /**
     * Address refers to a location for a single salesperson
     */
    const C_SALESPERSON = 4;

    /**
     * Address is a type not reflected in the other lists
     */
    const C_OTHER = 5;

    /**
     * The marketplace vendor does not collect and remit tax for transactions tied to this
     *  location. Use this option if you are using a marketplace vendor to handle your transactions
     *  and your company is responsible for collecting and remitting all taxes for transactions tied
     *  to this location.
     */
    const C_SELLERREMITSTAX = 6;

    /**
     * The marketplace vendor collects and remits tax on your behalf for all transactions tied
     *  to this location. Use this option if your marketplace vendor already pays sales and use
     *  taxes on your behalf. When this option is selected, all transactions tied to this location
     *  will be treated as already filed, and will be listed on each sales tax return as amounts
     *  already paid.
     */
    const C_MARKETPLACEREMITSTAX = 7;

    /**
     * Address refers to the mailing address of your company which is not a physical location.
     */
    const C_NONPHYSICAL = 8;

    /**
     * Address refers to the vendor's location, used for ACU transaction
     */
    const C_VENDOR = 9;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class MemoryAlertSeverity
{    const C_INFO = 0;
    const C_WARNING = 1;
    const C_CRITICAL = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class MemoryRecommendationPriority
{    const C_LOW = 0;
    const C_MEDIUM = 1;
    const C_HIGH = 2;
    const C_CRITICAL = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Describes the different types of statuses which describe an entity (company).
 */
class NexusTypeId
{
    /**
     * Indicates no nexus
     */
    const C_NONE = 0;

    /**
     * Indicates the entity is voluntarily collecting tax (default)
     */
    const C_SALESORSELLERSUSETAX = 1;

    /**
     * Indicates the entity is required to collect tax in the state
     */
    const C_SALESTAX = 2;

    /**
     * Indicates the entity is registered as a Volunteer in an SST state.
     *  Only your SST administrator may set this option.
     */
    const C_SSTVOLUNTEER = 3;

    /**
     * Indicates the entity is registered as a Non-Volunteer in an SST state.
     *  Only your SST administrator may set this option.
     */
    const C_SSTNONVOLUNTEER = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * Describes nexus type id
 */
class LocalNexusTypeId
{
    /**
     * Only the specific nexus objects declared for this company are declared.
     */
    const C_SELECTED = 0;

    /**
     * Customer declares nexus in all state administered taxing authorities.
     *  
     *  This value only takes effect if you set `hasLocalNexus` = true.
     */
    const C_STATEADMINISTERED = 1;

    /**
     * Customer declares nexus in all local taxing authorities.
     *  
     *  This value only takes effect if you set `hasLocalNexus` = true.
     */
    const C_ALL = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Types of jurisdiction referenced in a transaction
 */
class JurisTypeId
{
    /**
     * State
     */
    const C_STA = 1;

    /**
     * County
     */
    const C_CTY = 2;

    /**
     * City
     */
    const C_CIT = 3;

    /**
     * Special
     */
    const C_STJ = 4;

    /**
     * Country
     */
    const C_CNT = 5;

}

/**
 * Swagger Name: AvaTaxClient
 * Sourcing
 */
class Sourcing
{
    /**
     * Mixed sourcing, for states that do both origin and destination calculation
     */
    const C_MIXED = 42;

    /**
     * Destination
     */
    const C_DESTINATION = 68;

    /**
     * Origin
     */
    const C_ORIGIN = 79;

}

/**
 * Swagger Name: AvaTaxClient
 * Comment Types
 */
class CommentType
{
    /**
     * Internal comments are those comments only intended to be for compliance users
     */
    const C_INTERNAL = 1;

    /**
     * Customer comments are those comments that both compliance and the customer can read
     */
    const C_CUSTOMER = 2;

    /**
     * A comment that has a POA Attachment on it
     */
    const C_POAATTACHMENT = 3;

    /**
     * Used when creating Notice Comments in Returns Console
     */
    const C_NOTICEVOUCHER = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * Notice Customer Types
 */
class NoticeCustomerType
{
    /**
     * AvaTax Returns
     */
    const C_AVATAXRETURNS = 1;

    /**
     * Stand Alone
     */
    const C_STANDALONE = 2;

    /**
     * Strategic
     */
    const C_STRATEGIC = 3;

    /**
     * SST
     */
    const C_SST = 4;

    /**
     * TrustFile
     */
    const C_TRUSTFILE = 5;

    /**
     * PWC
     */
    const C_PWC = 6;

    /**
     * Hudson Group
     */
    const C_HUDSONGROUP = 7;

    /**
     * MRA
     */
    const C_MRA = 8;

    /**
     * None
     */
    const C_NONE = 9;

}

/**
 * Swagger Name: AvaTaxClient
 * A list of possible AvaFile filing types for tax notices.
 */
class TaxNoticeFilingTypeId
{
    /**
     * Denotes the tax return is being filed via electronic means; excludes SST electronic filing.
     */
    const C_ELECTRONICRETURN = 1;

    /**
     * Denotes the tax return is being filed on paper.
     */
    const C_PAPERRETURN = 2;

    /**
     * Denotes the tax return that was not filed.
     */
    const C_RETURNNOTFILED = 3;

    /**
     * Denotes a return is paid via EFT and filed on paper without payment.
     */
    const C_EFTPAPER = 4;

    /**
     * Denotes the tax return is an SST filing.
     */
    const C_SER = 5;

    /**
     * Denotes the tax return is a Trudsfile-EDI filing.
     */
    const C_TRUSTFILEEDI = 6;

    /**
     * Denotes the tax return is an uploaded file.
     */
    const C_UPLOADFILE = 7;

    /**
     * Denotes the tax return was manually filed via paper
     */
    const C_PAPERMANUAL = 8;

    /**
     * Denotes a cert capture return
     */
    const C_CERTCAPTURE = 9;

    /**
     * Denotes a signature ready return
     */
    const C_SIGNATUREREADY = 10;

}

/**
 * Swagger Name: AvaTaxClient
 * Filing Frequency types
 */
class FundingOption
{
    /**
     * Pull
     */
    const C_PULL = 1;

    /**
     * Wire
     */
    const C_WIRE = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Filing Frequency types
 */
class NoticePriorityId
{
    /**
     * Immediate Attention Required
     */
    const C_IMMEDIATEATTENTIONREQUIRED = 1;

    /**
     * High
     */
    const C_HIGH = 2;

    /**
     * Normal
     */
    const C_NORMAL = 3;

    /**
     * Low
     */
    const C_LOW = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * Severity level of a notification.
 */
class NotificationSeverityLevel
{
    /**
     * Low priority notification, Default.
     */
    const C_NEUTRAL = 0;

    /**
     * Medium priority notification.
     */
    const C_ADVISORY = 1;

    /**
     * High priority notification.
     */
    const C_BLOCKING = 2;

    /**
     * A completed notification
     */
    const C_COMPLETE = -1;

}

/**
 * Swagger Name: AvaTaxClient
 * Represents the type of authentication provided to the API call
 */
class AuthenticationTypeId
{
    /**
     * This API call was not authenticated.
     */
    const C_NONE = 0;

    /**
     * This API call was authenticated by your username/password.
     */
    const C_USERNAMEPASSWORD = 1;

    /**
     * This API call was authenticated by your Avalara Account ID and private license key.
     */
    const C_ACCOUNTIDLICENSEKEY = 2;

    /**
     * This API call was authenticated by OpenID Bearer Token.
     */
    const C_OPENIDBEARERTOKEN = 3;

    /**
     * This API call was authenticated by mTLS client certificate.
     */
    const C_CLIENTMTLSCERTIFICATE = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class CertCaptureProvisionStatus
{
    /**
     * Account and company are provisioned
     */
    const C_PROVISIONED = 0;

    /**
     * Provision job is being queued
     *  This could also be an indication that some companies under an account has been provisioned, while others
     *  under the same account has not.
     */
    const C_INPROGRESS = 1;
    const C_NOTPROVISIONED = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Refund types
 */
class RefundType
{
    /**
     * Refund the whole transaction.
     */
    const C_FULL = 0;

    /**
     * Refund only specific lines from the original a transaction.
     */
    const C_PARTIAL = 1;

    /**
     * Only refund the tax part of the transaction.
     */
    const C_TAXONLY = 2;

    /**
     * Refund a percentage of the value of this transaction.
     */
    const C_PERCENTAGE = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class SendSalesOutputFileFormat
{    const C_STANDARD = 1;
    const C_DMA = 2;
    const C_DMA_NEW = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class SendSalesFileType
{
    /**
     * File is in Comma Separated Values format
     */
    const C_CSV = 0;

    /**
     * File is in Javascript Object Notation format
     */
    const C_JSON = 1;

}

/**
 * Swagger Name: AvaTaxClient
 * Type of verification task
 */
class ScraperType
{
    /**
     * Indicates that is is a login type
     */
    const C_LOGIN = 1;

    /**
     * Indicates that it is a Customer DOR Data type
     */
    const C_CUSTOMERDORDATA = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Represents a type of tax override requested by the customer.
 *  
 *  AvaTax allows customers to override some behavior of the AvaTax engine. When you use a
 *  Tax Override, you can import tax that was previously calculated and charged to the customer exactly
 *  as it was charged. AvaTax will record the type of override used for each transaction.
 */
class TaxOverrideType
{
    /**
     * AvaTax calculated the tax for this transaction, and no override occurred.
     */
    const C_NONE = 0;

    /**
     * AvaTax calculated tax for this transaction, but the final tax amount on the transaction was
     *  determined outside of AvaTax. To see the tax amounts determined by AvaTax, look at the
     *  `taxCalculated` field. To see the tax amounts determined by the customer's outside tax engine,
     *  look at the `taxAmount` field.
     *  
     *  This behavior can also occur when a customer requests a refund. For refunds calculated using the
     *  `RefundTransaction` API, AvaTax will ensure that the exact tax charged to the customer is refunded
     *  to the customer using a tax amount override.
     */
    const C_TAXAMOUNT = 1;

    /**
     * Entity exemption was ignored (e.g. item was consumed)
     */
    const C_EXEMPTION = 2;

    /**
     * AvaTax was instructed to calculate this transaction using the tax rules that were in effect
     *  on a different day than the transaction occurred.
     *  
     *  This behavior typically occurs during refunds. If the customer attempts to return a product
     *  without a receipt that shows the exact tax amount paid, AvaTax can calculate tax on the date
     *  when they believed that the product was purchased.
     */
    const C_TAXDATE = 3;

    /**
     * To support Consumer Use Tax
     */
    const C_ACCRUEDTAXAMOUNT = 4;

    /**
     * Derive the taxable amount from the tax amount
     */
    const C_DERIVETAXABLE = 5;

    /**
     * This is for the documents that are calculated outside of AvaTax and passed in to AvaTax
     *  specifically for reporting/Returns purposes
     */
    const C_OUTOFHARBOR = 6;

    /**
     * To support Tax Override Amount with Tax Type feature
     */
    const C_TAXAMOUNTBYTAXTYPE = 7;

    /**
     * To support ACU transaction
     */
    const C_VENDORCHARGEDTAX = 8;

}

/**
 * Swagger Name: AvaTaxClient
 * 
 */
class RateType
{    const C_REDUCEDA = 65;
    const C_REDUCEDB = 66;
    const C_FOOD = 70;
    const C_GENERAL = 71;
    const C_INCREASEDSTANDARD = 73;
    const C_LINENRENTAL = 76;
    const C_MEDICAL = 77;
    const C_CONSTRUCTION = 78;
    const C_PARKING = 80;
    const C_SUPERREDUCED = 81;
    const C_REDUCEDR = 82;
    const C_STANDARD = 83;
    const C_LEASING = 84;
    const C_LEASINGLOW = 85;
    const C_SERVICES = 88;
    const C_ZERO = 90;

}

/**
 * Swagger Name: AvaTaxClient
 * Specifies the type of custom tax rule you have created.
 */
class TaxRuleTypeId
{
    /**
     * Reserved for Avalara internal usage.
     */
    const C_RATERULE = 0;

    /**
     * Specifies a rule that changes the rate of tax for a specified set of criteria.
     *  
     *  This rule can apply to one specific type of product (identified by `TaxCode`) or all products (identified by a null `TaxCode`).
     */
    const C_RATEOVERRIDERULE = 1;

    /**
     * Specifies a rule that changes the tax base of a specific product.
     *  
     *  This rule can apply to one specific type of product (identified by `TaxCode`) or all products (identified by a null `TaxCode`).
     */
    const C_BASERULE = 2;

    /**
     * Indicates that a particular product is exempt from tax due to an exempt usage reason.
     *  
     *  Amounts exempted by this rule are stored in the `exemptAmount` field on the transaction.
     */
    const C_EXEMPTENTITYRULE = 3;

    /**
     * Specifies a rule that changes whether a product is taxable or not.
     *  
     *  This rule must be applied to a specific type of product. If you attempt to create a product taxability rule while
     *  leaving the `TaxCode` and `TaxCodeId` fields empty, you will get an error.
     *  
     *  A `value` field of `1` means that this tax code is taxable; `0` means it is nontaxable.
     *  
     *  Amounts that are considered not taxable according to this rule are stored in the `nonTaxableAmount`
     *  column in a transaction.
     *  
     *  This type of rule can also determine the rate type for a product or to apply a cap or threshold.
     */
    const C_PRODUCTTAXABILITYRULE = 4;

    /**
     * Reserved for Avalara internal usage.
     */
    const C_NEXUSRULE = 5;

    /**
     * RateCapRule
     */
    const C_RATECAPRULE = 6;

    /**
     * TaxOverrideRule
     */
    const C_TAXOVERRIDERULE = 7;

    /**
     * FeeRule
     */
    const C_FEERULE = 8;

    /**
     * OtherRule
     */
    const C_OTHERRULE = 100;

}

/**
 * Swagger Name: AvaTaxClient
 * Liability Type
 */
class LiabilityType
{
    /**
     * Seller
     */
    const C_SELLER = 0;

    /**
     * BuyersAgent
     */
    const C_BUYERSAGENT = 1;

    /**
     * Buyer
     */
    const C_BUYER = 2;

    /**
     * ThirdParty
     */
    const C_THIRDPARTY = 3;

}

/**
 * Swagger Name: AvaTaxClient
 * Charged To
 */
class ChargedTo
{
    /**
     * Buyer
     */
    const C_BUYER = 0;

    /**
     * Seller
     */
    const C_SELLER = 1;

    /**
     * ThirdParty
     */
    const C_THIRDPARTY = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * Represents the different types of DeemedSeller for AVT Marketplace client.
 */
class DeemedSellerType
{    const C_MARKETPLACE = 1;
    const C_MERCHANT = 2;

}

/**
 * Swagger Name: AvaTaxClient
 * /// The user can set some tolerance or threshold limits inorder to take appropriate actions when
 *  their transactions are above or below certain threshold limits.
 *  Account Payable (AP) status code indicates an action that needs to be taken when the tolerance/threshold falls between certain range.
 */
class APStatus
{    const C_NOACCRUALMATCH = 0;
    const C_ACCRUEDSHORTPAYITEMSMATCH = 1;
    const C_NEEDREVIEWMATCH = 2;
    const C_NOACCRUALREJECTMATCH = 3;
    const C_NOACCRUALUNDERCHARGE = 4;
    const C_ACCRUEDUNDERCHARGE = 5;
    const C_ACCRUEDSHORTPAYITEMSUNDERCHARGE = 6;
    const C_NEEDREVIEWUNDERCHARGE = 7;
    const C_NOACCRUALREJECTUNDERCHARGE = 8;
    const C_NOACCRUALOVERCHARGE = 9;
    const C_NOACCRUALSHORTPAYAVALARACALCULATED = 10;
    const C_ACCRUEDSHORTPAYITEMSOVERCHARGE = 11;
    const C_NEEDREVIEWOVERCHARGE = 12;
    const C_NOACCRUALREJECTOVERCHARGE = 13;
    const C_NOACCRUALAMOUNTTHRESHOLDNOTMET = 14;
    const C_NOACCRUALEXEMPTEDCOSTCENTER = 15;
    const C_NOACCRUALEXEMPTEDITEM = 16;
    const C_NOACCRUALTRUSTEDVENDOR = 17;
    const C_ACCRUEDVENDOR = 18;
    const C_NEEDREVIEWVENDOR = 19;
    const C_NOACCRUALEXEMPTEDVENDOR = 20;
    const C_NOACCRUALEXEMPTEDGLACCOUNT = 21;
    const C_PENDINGACCRUALVENDOR = 22;
    const C_PENDINGACCRUALUNDERCHARGE = 23;
    const C_PENDINGSHORTPAYITEMSUNDERCHARGE = 24;
    const C_PENDINGSHORTPAYITEMSMATCH = 25;
    const C_PENDINGSHORTPAYITEMSOVERCHARGE = 26;
    const C_SHORTPAYITEMSACCRUEMATCH = -1;
    const C_MARKFORREVIEWMATCH = -1;
    const C_REJECTMATCH = -1;
    const C_SHORTPAYITEMSACCRUEUNDERCHARGE = -1;
    const C_REJECTUNDERCHARGE = -1;
    const C_SHORTPAYAVALARACALCULATED = -1;
    const C_SHORTPAYITEMSACCRUEOVERCHARGE = -1;
    const C_MARKFORREVIEWOVERCHARGE = -1;
    const C_REJECTOVERCHARGE = -1;

}

/**
 * Swagger Name: AvaTaxClient
 * Indicates the level of companies that can be accessed
 */
class CompanyAccessLevel
{
    /**
     * No permission to access companies.
     */
    const C_NONE = 0;

    /**
     * Permission to access a single company and its children.
     */
    const C_SINGLECOMPANY = 1;

    /**
     * Permission to access all companies in a single account.
     */
    const C_SINGLEACCOUNT = 2;

    /**
     * Permission to access all companies in all accounts. Reserved for system administration tasks.
     */
    const C_ALLCOMPANIES = 3;

    /**
     * Permission to access all companies in all accounts managed by a firm account.
     */
    const C_FIRMMANAGEDACCOUNTS = 4;

}

/**
 * Swagger Name: AvaTaxClient
 * Permission level of a user
 */
class SecurityRoleId
{
    /**
     * NoAccess
     */
    const C_NOACCESS = 0;

    /**
     * SiteAdmin
     */
    const C_SITEADMIN = 1;

    /**
     * AccountOperator
     */
    const C_ACCOUNTOPERATOR = 2;

    /**
     * AccountAdmin
     */
    const C_ACCOUNTADMIN = 3;

    /**
     * AccountUser
     */
    const C_ACCOUNTUSER = 4;

    /**
     * SystemAdmin
     */
    const C_SYSTEMADMIN = 5;

    /**
     * Registrar
     */
    const C_REGISTRAR = 6;

    /**
     * CSPTester
     */
    const C_CSPTESTER = 7;

    /**
     * CSPAdmin
     */
    const C_CSPADMIN = 8;

    /**
     * SystemOperator
     */
    const C_SYSTEMOPERATOR = 9;

    /**
     * TechnicalSupportUser
     */
    const C_TECHNICALSUPPORTUSER = 10;

    /**
     * TechnicalSupportAdmin
     */
    const C_TECHNICALSUPPORTADMIN = 11;

    /**
     * TreasuryUser
     */
    const C_TREASURYUSER = 12;

    /**
     * TreasuryAdmin
     */
    const C_TREASURYADMIN = 13;

    /**
     * ComplianceUser
     */
    const C_COMPLIANCEUSER = 14;

    /**
     * ComplianceAdmin
     */
    const C_COMPLIANCEADMIN = 15;

    /**
     * ProStoresOperator
     */
    const C_PROSTORESOPERATOR = 16;

    /**
     * CompanyUser
     */
    const C_COMPANYUSER = 17;

    /**
     * CompanyAdmin
     */
    const C_COMPANYADMIN = 18;

    /**
     * ComplianceTempUser
     */
    const C_COMPLIANCETEMPUSER = 19;

    /**
     * ComplianceRootUser
     */
    const C_COMPLIANCEROOTUSER = 20;

    /**
     * ComplianceOperator
     */
    const C_COMPLIANCEOPERATOR = 21;

    /**
     * SSTAdmin
     */
    const C_SSTADMIN = 22;

    /**
     * FirmUser
     */
    const C_FIRMUSER = 23;

    /**
     * FirmAdmin
     */
    const C_FIRMADMIN = 24;

    /**
     * BatchServiceAdmin
     */
    const C_BATCHSERVICEADMIN = 25;

    /**
     * ECMAccountUser
     */
    const C_ECMACCOUNTUSER = 26;

    /**
     * ECMCompanyUser
     */
    const C_ECMCOMPANYUSER = 27;

    /**
     * ReturnsOnlyAccountAdmin
     */
    const C_RETURNSONLYACCOUNTADMIN = 28;

    /**
     * ReturnsOnlyAccountUser
     */
    const C_RETURNSONLYACCOUNTUSER = 29;

    /**
     * ReturnsOnlyCompanyAdmin
     */
    const C_RETURNSONLYCOMPANYADMIN = 30;

    /**
     * ReturnsOnlyCompanyUser
     */
    const C_RETURNSONLYCOMPANYUSER = 31;

    /**
     * AvaTaxOnlyAccountAdmin
     */
    const C_AVATAXONLYACCOUNTADMIN = 32;

    /**
     * AvaTaxOnlyAccountUser
     */
    const C_AVATAXONLYACCOUNTUSER = 33;

    /**
     * AvaTaxOnlyCompanyAdmin
     */
    const C_AVATAXONLYCOMPANYADMIN = 34;

    /**
     * AvaTaxOnlyCompanyUser
     */
    const C_AVATAXONLYCOMPANYUSER = 35;

}

/**
 * Swagger Name: AvaTaxClient
 * PasswordStatusId
 */
class PasswordStatusId
{
    /**
     * UserCannotChange
     */
    const C_USERCANNOTCHANGE = 0;

    /**
     * UserCanChange
     */
    const C_USERCANCHANGE = 1;

    /**
     * UserMustChange
     */
    const C_USERMUSTCHANGE = 2;

}

/**
 * Swagger Name: AvaTaxBeverageClient
 * 
 */
class ApiVersionSchema
{    const C_2_1 = 0;
    const C_2_2 = 1;

}

/**
 * Swagger Name: AvaTaxBeverageClient
 * 
 */
class FailureCodes
{    const C_BELOWLEGALDRINKINGAGE = 0;
    const C_SHIPPINGPROHIBITEDTOADDRESS = 1;
    const C_MISSINGREQUIREDLICENSE = 2;
    const C_VOLUMELIMITEXCEEDED = 3;
    const C_INVALIDFIELDVALUE = 4;
    const C_MISSINGREQUIREDFIELD = 5;
    const C_INVALIDFIELDTYPE = 6;
    const C_INVALIDFORMAT = 7;
    const C_INVALIDDATE = 8;
    const C_ALCOHOLCONTENTLIMITEXCEEDED = 9;

}

/**
 * Swagger Name: AvaTaxBeverageClient
 * 
 */
class AgeVerifyFailureCode
{    const C_NOT_FOUND = 0;
    const C_DOB_UNVERIFIABLE = 1;
    const C_UNDER_AGE = 2;
    const C_SUSPECTED_FRAUD = 3;
    const C_DECEASED = 4;
    const C_UNKNOWN_ERROR = 5;

}
?>